/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.entities.Recording;
import org.mobicents.servlet.restcomm.http.converter.AbstractConverter;

@ThreadSafe
public final class RecordingConverter
extends AbstractConverter
implements JsonSerializer<Recording> {
    public RecordingConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Recording.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Recording recording = (Recording)object;
        writer.startNode("Recording");
        this.writeSid(recording.getSid(), writer);
        this.writeDateCreated(recording.getDateCreated(), writer);
        this.writeDateUpdated(recording.getDateUpdated(), writer);
        this.writeAccountSid(recording.getAccountSid(), writer);
        this.writeCallSid(recording.getCallSid(), writer);
        this.writeDuration((double)recording.getDuration(), writer);
        this.writeApiVersion(recording.getApiVersion(), writer);
        this.writeUri(recording.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Recording recording, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(recording.getSid(), object);
        this.writeDateCreated(recording.getDateCreated(), object);
        this.writeDateUpdated(recording.getDateUpdated(), object);
        this.writeAccountSid(recording.getAccountSid(), object);
        this.writeCallSid(recording.getCallSid(), object);
        this.writeDuration((double)recording.getDuration(), object);
        this.writeApiVersion(recording.getApiVersion(), object);
        this.writeUri(recording.getUri(), object);
        return object;
    }
}

