/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.entities.IncomingPhoneNumber;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.converter.AbstractConverter;

@ThreadSafe
public final class IncomingPhoneNumberConverter
extends AbstractConverter
implements JsonSerializer<IncomingPhoneNumber> {
    public IncomingPhoneNumberConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return IncomingPhoneNumber.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        IncomingPhoneNumber incomingPhoneNumber = (IncomingPhoneNumber)object;
        writer.startNode("IncomingPhoneNumber");
        this.writeSid(incomingPhoneNumber.getSid(), writer);
        this.writeAccountSid(incomingPhoneNumber.getAccountSid(), writer);
        this.writeFriendlyName(incomingPhoneNumber.getFriendlyName(), writer);
        this.writePhoneNumber(incomingPhoneNumber.getPhoneNumber(), writer);
        this.writeVoiceUrl(incomingPhoneNumber.getVoiceUrl(), writer);
        this.writeVoiceMethod(incomingPhoneNumber.getVoiceMethod(), writer);
        this.writeVoiceFallbackUrl(incomingPhoneNumber.getVoiceFallbackUrl(), writer);
        this.writeVoiceFallbackMethod(incomingPhoneNumber.getVoiceFallbackMethod(), writer);
        this.writeStatusCallback(incomingPhoneNumber.getStatusCallback(), writer);
        this.writeStatusCallbackMethod(incomingPhoneNumber.getStatusCallbackMethod(), writer);
        this.writeVoiceCallerIdLookup((boolean)incomingPhoneNumber.hasVoiceCallerIdLookup(), writer);
        this.writeVoiceApplicationSid(incomingPhoneNumber.getVoiceApplicationSid(), writer);
        this.writeDateCreated(incomingPhoneNumber.getDateCreated(), writer);
        this.writeDateUpdated(incomingPhoneNumber.getDateUpdated(), writer);
        this.writeSmsUrl(incomingPhoneNumber.getSmsUrl(), writer);
        this.writeSmsMethod(incomingPhoneNumber.getSmsMethod(), writer);
        this.writeSmsFallbackUrl(incomingPhoneNumber.getSmsFallbackUrl(), writer);
        this.writeSmsFallbackMethod(incomingPhoneNumber.getSmsFallbackMethod(), writer);
        this.writeSmsApplicationSid(incomingPhoneNumber.getSmsApplicationSid(), writer);
        this.writeCapabilities(incomingPhoneNumber.isVoiceCapable(), incomingPhoneNumber.isSmsCapable(), incomingPhoneNumber.isMmsCapable(), incomingPhoneNumber.isFaxCapable(), writer);
        this.writeApiVersion(incomingPhoneNumber.getApiVersion(), writer);
        this.writeUri(incomingPhoneNumber.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(IncomingPhoneNumber incomingPhoneNumber, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(incomingPhoneNumber.getSid(), object);
        this.writeAccountSid(incomingPhoneNumber.getAccountSid(), object);
        this.writeFriendlyName(incomingPhoneNumber.getFriendlyName(), object);
        this.writePhoneNumber(incomingPhoneNumber.getPhoneNumber(), object);
        this.writeVoiceUrl(incomingPhoneNumber.getVoiceUrl(), object);
        this.writeVoiceMethod(incomingPhoneNumber.getVoiceMethod(), object);
        this.writeVoiceFallbackUrl(incomingPhoneNumber.getVoiceFallbackUrl(), object);
        this.writeVoiceFallbackMethod(incomingPhoneNumber.getVoiceFallbackMethod(), object);
        this.writeStatusCallback(incomingPhoneNumber.getStatusCallback(), object);
        this.writeStatusCallbackMethod(incomingPhoneNumber.getStatusCallbackMethod(), object);
        this.writeVoiceCallerIdLookup((boolean)incomingPhoneNumber.hasVoiceCallerIdLookup(), object);
        this.writeVoiceApplicationSid(incomingPhoneNumber.getVoiceApplicationSid(), object);
        this.writeDateCreated(incomingPhoneNumber.getDateCreated(), object);
        this.writeDateUpdated(incomingPhoneNumber.getDateUpdated(), object);
        this.writeSmsUrl(incomingPhoneNumber.getSmsUrl(), object);
        this.writeSmsMethod(incomingPhoneNumber.getSmsMethod(), object);
        this.writeSmsFallbackUrl(incomingPhoneNumber.getSmsFallbackUrl(), object);
        this.writeSmsFallbackMethod(incomingPhoneNumber.getSmsFallbackMethod(), object);
        this.writeSmsApplicationSid(incomingPhoneNumber.getSmsApplicationSid(), object);
        this.writeCapabilities(incomingPhoneNumber.isVoiceCapable(), incomingPhoneNumber.isSmsCapable(), incomingPhoneNumber.isMmsCapable(), incomingPhoneNumber.isFaxCapable(), object);
        this.writeApiVersion(incomingPhoneNumber.getApiVersion(), object);
        this.writeUri(incomingPhoneNumber.getUri(), object);
        return object;
    }

    private void writeSmsApplicationSid(Sid smsApplicationSid, HierarchicalStreamWriter writer) {
        writer.startNode("SmsApplicationSid");
        if (smsApplicationSid != null) {
            writer.setValue(smsApplicationSid.toString());
        } else {
            writer.setValue(null);
        }
        writer.endNode();
    }

    private void writeSmsApplicationSid(Sid smsApplicationSid, JsonObject object) {
        if (smsApplicationSid != null) {
            object.addProperty("sms_application_sid", smsApplicationSid.toString());
        } else {
            object.add("sms_application_sid", (JsonElement)JsonNull.INSTANCE);
        }
    }
}

