/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.converter;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.entities.AvailablePhoneNumber;
import org.mobicents.servlet.restcomm.http.converter.AbstractConverter;

public final class AvailablePhoneNumberConverter
extends AbstractConverter {
    public AvailablePhoneNumberConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return AvailablePhoneNumber.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        AvailablePhoneNumber number = (AvailablePhoneNumber)object;
        writer.startNode("AvailablePhoneNumber");
        this.writeFriendlyName(number.getFriendlyName(), writer);
        this.writePhoneNumber(number.getPhoneNumber(), writer);
        this.writeLata(number.getLata(), writer);
        this.writeRateCenter(number.getRateCenter(), writer);
        this.writeLatitude(number.getLatitude(), writer);
        this.writeLongitude(number.getLongitude(), writer);
        this.writeRegion(number.getRegion(), writer);
        this.writePostalCode(number.getPostalCode(), writer);
        this.writeIsoCountry(number.getIsoCountry(), writer);
        this.writeCapabilities(number.isVoiceCapable(), number.isSmsCapable(), number.isMmsCapable(), number.isFaxCapable(), writer);
        writer.endNode();
    }

    private void writeLata(Integer lata, HierarchicalStreamWriter writer) {
        writer.startNode("Lata");
        if (lata != null) {
            writer.setValue(lata.toString());
        }
        writer.endNode();
    }

    private void writeRateCenter(String center, HierarchicalStreamWriter writer) {
        writer.startNode("RateCenter");
        if (center != null) {
            writer.setValue(center);
        }
        writer.endNode();
    }

    private void writeLatitude(Double latitude, HierarchicalStreamWriter writer) {
        writer.startNode("Latitude");
        if (latitude != null) {
            writer.setValue(latitude.toString());
        }
        writer.endNode();
    }

    private void writeLongitude(Double longitude, HierarchicalStreamWriter writer) {
        writer.startNode("Longitude");
        if (longitude != null) {
            writer.setValue(longitude.toString());
        }
        writer.endNode();
    }

    private void writeRegion(String region, HierarchicalStreamWriter writer) {
        writer.startNode("Region");
        if (region != null) {
            writer.setValue(region);
        }
        writer.endNode();
    }

    private void writePostalCode(Integer postalCode, HierarchicalStreamWriter writer) {
        writer.startNode("PostalCode");
        if (postalCode != null) {
            writer.setValue(postalCode.toString());
        }
        writer.endNode();
    }

    private void writeIsoCountry(String country, HierarchicalStreamWriter writer) {
        writer.startNode("IsoCountry");
        if (country != null) {
            writer.setValue(country);
        }
        writer.endNode();
    }
}

