/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.entities.Application;
import org.mobicents.servlet.restcomm.http.converter.AbstractConverter;

@ThreadSafe
public final class ApplicationConverter
extends AbstractConverter
implements JsonSerializer<Application> {
    public ApplicationConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Application.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Application application = (Application)object;
        writer.startNode("Application");
        this.writeSid(application.getSid(), writer);
        this.writeDateCreated(application.getDateCreated(), writer);
        this.writeDateUpdated(application.getDateUpdated(), writer);
        this.writeFriendlyName(application.getFriendlyName(), writer);
        this.writeAccountSid(application.getAccountSid(), writer);
        this.writeApiVersion(application.getApiVersion(), writer);
        this.writeVoiceUrl(application.getVoiceUrl(), writer);
        this.writeVoiceMethod(application.getVoiceMethod(), writer);
        this.writeVoiceFallbackUrl(application.getVoiceFallbackUrl(), writer);
        this.writeVoiceFallbackMethod(application.getVoiceFallbackMethod(), writer);
        this.writeStatusCallback(application.getStatusCallback(), writer);
        this.writeStatusCallbackMethod(application.getStatusCallbackMethod(), writer);
        this.writeVoiceCallerIdLookup((boolean)application.hasVoiceCallerIdLookup(), writer);
        this.writeSmsUrl(application.getSmsUrl(), writer);
        this.writeSmsMethod(application.getSmsMethod(), writer);
        this.writeSmsFallbackUrl(application.getSmsFallbackUrl(), writer);
        this.writeSmsFallbackMethod(application.getSmsFallbackMethod(), writer);
        this.writeSmsStatusCallback(application.getSmsStatusCallback(), writer);
        this.writeUri(application.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Application application, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(application.getSid(), object);
        this.writeDateCreated(application.getDateCreated(), object);
        this.writeDateUpdated(application.getDateUpdated(), object);
        this.writeFriendlyName(application.getFriendlyName(), object);
        this.writeAccountSid(application.getAccountSid(), object);
        this.writeApiVersion(application.getApiVersion(), object);
        this.writeVoiceUrl(application.getVoiceUrl(), object);
        this.writeVoiceMethod(application.getVoiceMethod(), object);
        this.writeVoiceFallbackUrl(application.getVoiceFallbackUrl(), object);
        this.writeVoiceFallbackMethod(application.getVoiceFallbackMethod(), object);
        this.writeStatusCallback(application.getStatusCallback(), object);
        this.writeStatusCallbackMethod(application.getStatusCallbackMethod(), object);
        this.writeVoiceCallerIdLookup((boolean)application.hasVoiceCallerIdLookup(), object);
        this.writeSmsUrl(application.getSmsUrl(), object);
        this.writeSmsMethod(application.getSmsMethod(), object);
        this.writeSmsFallbackUrl(application.getSmsFallbackUrl(), object);
        this.writeSmsFallbackMethod(application.getSmsFallbackMethod(), object);
        this.writeSmsStatusCallback(application.getSmsStatusCallback(), object);
        this.writeUri(application.getUri(), object);
        return object;
    }

    private void writeSmsStatusCallback(URI smsStatusCallback, HierarchicalStreamWriter writer) {
        writer.startNode("SmsStatusCallback");
        if (smsStatusCallback != null) {
            writer.setValue(smsStatusCallback.toString());
        }
        writer.endNode();
    }

    private void writeSmsStatusCallback(URI smsStatusCallback, JsonObject object) {
        if (smsStatusCallback != null) {
            object.addProperty("sms_status_callback", smsStatusCallback.toString());
        } else {
            object.add("sms_status_callback", (JsonElement)JsonNull.INSTANCE);
        }
    }
}

