/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.entities.Announcement;
import org.mobicents.servlet.restcomm.http.converter.AbstractConverter;

@ThreadSafe
public final class AnnouncementConverter
extends AbstractConverter
implements JsonSerializer<Announcement> {
    public AnnouncementConverter(Configuration configuration) {
        super(configuration);
    }

    public JsonElement serialize(Announcement announcement, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(announcement.getSid(), object);
        this.writeDateCreated(announcement.getDateCreated(), object);
        this.writeAccountSid(announcement.getAccountSid(), object);
        this.writeGender(announcement.getGender(), object);
        this.writeLanguage(announcement.getLanguage(), object);
        this.writeText(announcement.getText(), object);
        if (announcement.getUri() != null) {
            this.writeUri(announcement.getUri(), object);
        }
        return object;
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Announcement announcement = (Announcement)object;
        writer.startNode("Announcement");
        this.writeSid(announcement.getSid(), writer);
        this.writeDateCreated(announcement.getDateCreated(), writer);
        this.writeAccountSid(announcement.getAccountSid(), writer);
        this.writeGender(announcement.getGender(), writer);
        this.writeLanguage(announcement.getLanguage(), writer);
        this.writeText(announcement.getText(), writer);
        this.writeUri(announcement.getUri(), writer);
        writer.endNode();
    }

    @Override
    public boolean canConvert(Class klass) {
        return Announcement.class.equals((Object)klass);
    }

    private void writeText(String text, JsonObject object) {
        object.addProperty("text", text);
    }

    private void writeLanguage(String language, JsonObject object) {
        object.addProperty("language", language);
    }

    private void writeGender(String gender, JsonObject object) {
        object.addProperty("gender", gender);
    }

    private void writeText(String text, HierarchicalStreamWriter writer) {
        writer.startNode("Text");
        if (text != null) {
            writer.setValue(text);
        }
        writer.endNode();
    }

    private void writeLanguage(String language, HierarchicalStreamWriter writer) {
        writer.startNode("Language");
        if (language != null) {
            writer.setValue(language);
        }
        writer.endNode();
    }

    private void writeGender(String gender, HierarchicalStreamWriter writer) {
        writer.startNode("Gender");
        if (gender != null) {
            writer.setValue(gender);
        }
        writer.endNode();
    }
}

