/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.math.BigDecimal;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Locale;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.entities.Sid;

public abstract class AbstractConverter
implements Converter {
    protected final Configuration configuration;

    public AbstractConverter(Configuration configuration) {
        this.configuration = configuration;
    }

    public abstract boolean canConvert(Class var1);

    public abstract void marshal(Object var1, HierarchicalStreamWriter var2, MarshallingContext var3);

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return null;
    }

    protected void writeAccountSid(Sid accountSid, HierarchicalStreamWriter writer) {
        writer.startNode("AccountSid");
        writer.setValue(accountSid.toString());
        writer.endNode();
    }

    protected void writeAccountSid(Sid accountSid, JsonObject object) {
        object.addProperty("account_sid", accountSid.toString());
    }

    protected void writeApiVersion(String apiVersion, HierarchicalStreamWriter writer) {
        writer.startNode("ApiVersion");
        writer.setValue(apiVersion);
        writer.endNode();
    }

    protected void writeApiVersion(String apiVersion, JsonObject object) {
        object.addProperty("api_version", apiVersion);
    }

    protected void writeCallSid(Sid callSid, HierarchicalStreamWriter writer) {
        if (callSid != null) {
            writer.startNode("CallSid");
            writer.setValue(callSid.toString());
            writer.endNode();
        }
    }

    protected void writeCallSid(Sid callSid, JsonObject object) {
        if (callSid != null) {
            object.addProperty("call_sid", callSid.toString());
        }
    }

    protected void writeDateCreated(DateTime dateCreated, HierarchicalStreamWriter writer) {
        writer.startNode("DateCreated");
        writer.setValue(new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(dateCreated.toDate()));
        writer.endNode();
    }

    protected void writeDateCreated(DateTime dateCreated, JsonObject object) {
        object.addProperty("date_created", new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(dateCreated.toDate()));
    }

    protected void writeDateUpdated(DateTime dateUpdated, HierarchicalStreamWriter writer) {
        writer.startNode("DateUpdated");
        writer.setValue(new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(dateUpdated.toDate()));
        writer.endNode();
    }

    protected void writeDateUpdated(DateTime dateUpdated, JsonObject object) {
        object.addProperty("date_updated", new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(dateUpdated.toDate()));
    }

    protected void writeDuration(double duration, HierarchicalStreamWriter writer) {
        writer.startNode("Duration");
        writer.setValue(Double.toString(duration));
        writer.endNode();
    }

    protected void writeDuration(double duration, JsonObject object) {
        object.addProperty("duration", Double.toString(duration));
    }

    protected void writeFriendlyName(String friendlyName, HierarchicalStreamWriter writer) {
        writer.startNode("FriendlyName");
        writer.setValue(friendlyName);
        writer.endNode();
    }

    protected void writeFriendlyName(String friendlyName, JsonObject object) {
        object.addProperty("friendly_name", friendlyName);
    }

    protected void writeFrom(String from, HierarchicalStreamWriter writer) {
        writer.startNode("From");
        writer.setValue(from);
        writer.endNode();
    }

    protected void writeFrom(String from, JsonObject object) {
        object.addProperty("from", from);
    }

    protected void writePhoneNumber(String phoneNumber, HierarchicalStreamWriter writer) {
        writer.startNode("PhoneNumber");
        writer.setValue(phoneNumber);
        writer.endNode();
    }

    protected void writePhoneNumber(String phoneNumber, JsonObject object) {
        object.addProperty("phone_number", phoneNumber);
    }

    protected void writePrice(BigDecimal price, HierarchicalStreamWriter writer) {
        writer.startNode("Price");
        writer.setValue(price.toString());
        writer.endNode();
    }

    protected void writePrice(BigDecimal price, JsonObject object) {
        object.addProperty("price", price.toString());
    }

    protected void writePriceUnit(Currency priceUnit, HierarchicalStreamWriter writer) {
        writer.startNode("PriceUnit");
        if (priceUnit != null) {
            writer.setValue(priceUnit.toString());
        }
        writer.endNode();
    }

    protected void writePriceUnit(Currency priceUnit, JsonObject object) {
        if (priceUnit != null) {
            object.addProperty("price_unit", priceUnit.toString());
        } else {
            object.add("price_unit", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeSid(Sid sid, HierarchicalStreamWriter writer) {
        writer.startNode("Sid");
        writer.setValue(sid.toString());
        writer.endNode();
    }

    protected void writeSid(Sid sid, JsonObject object) {
        object.addProperty("sid", sid.toString());
    }

    protected void writeSmsFallbackUrl(URI smsFallbackUrl, HierarchicalStreamWriter writer) {
        writer.startNode("SmsFallbackUrl");
        if (smsFallbackUrl != null) {
            writer.setValue(smsFallbackUrl.toString());
        } else {
            writer.setValue(null);
        }
        writer.endNode();
    }

    protected void writeSmsFallbackUrl(URI smsFallbackUrl, JsonObject object) {
        if (smsFallbackUrl != null) {
            object.addProperty("sms_fallback_url", smsFallbackUrl.toString());
        } else {
            object.add("sms_fallback_url", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeSmsFallbackMethod(String smsFallbackMethod, HierarchicalStreamWriter writer) {
        writer.startNode("SmsFallbackMethod");
        if (smsFallbackMethod != null) {
            writer.setValue(smsFallbackMethod);
        }
        writer.endNode();
    }

    protected void writeSmsFallbackMethod(String smsFallbackMethod, JsonObject object) {
        if (smsFallbackMethod != null) {
            object.addProperty("sms_fallback_method", smsFallbackMethod);
        } else {
            object.add("sms_fallback_method", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeSmsUrl(URI smsUrl, HierarchicalStreamWriter writer) {
        writer.startNode("SmsUrl");
        if (smsUrl != null) {
            writer.setValue(smsUrl.toString());
        } else {
            writer.setValue(null);
        }
        writer.endNode();
    }

    protected void writeSmsUrl(URI smsUrl, JsonObject object) {
        if (smsUrl != null) {
            object.addProperty("sms_url", smsUrl.toString());
        } else {
            object.add("sms_url", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeSmsMethod(String smsMethod, HierarchicalStreamWriter writer) {
        writer.startNode("SmsMethod");
        if (smsMethod != null) {
            writer.setValue(smsMethod);
        }
        writer.endNode();
    }

    protected void writeSmsMethod(String smsMethod, JsonObject object) {
        if (smsMethod != null) {
            object.addProperty("sms_method", smsMethod);
        } else {
            object.add("sms_method", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeStatus(String status, HierarchicalStreamWriter writer) {
        writer.startNode("Status");
        writer.setValue(status);
        writer.endNode();
    }

    protected void writeStatus(String status, JsonObject object) {
        object.addProperty("status", status);
    }

    protected void writeStatusCallback(URI statusCallback, HierarchicalStreamWriter writer) {
        writer.startNode("StatusCallback");
        if (statusCallback != null) {
            writer.setValue(statusCallback.toString());
        } else {
            writer.setValue(null);
        }
        writer.endNode();
    }

    protected void writeStatusCallback(URI statusCallback, JsonObject object) {
        if (statusCallback != null) {
            object.addProperty("status_callback", statusCallback.toString());
        } else {
            object.add("status_callback", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeStatusCallbackMethod(String statusCallbackMethod, HierarchicalStreamWriter writer) {
        writer.startNode("StatusCallbackMethod");
        if (statusCallbackMethod != null) {
            writer.setValue(statusCallbackMethod);
        }
        writer.endNode();
    }

    protected void writeStatusCallbackMethod(String statusCallbackMethod, JsonObject object) {
        if (statusCallbackMethod != null) {
            object.addProperty("status_callback_method", statusCallbackMethod);
        } else {
            object.add("status_callback_method", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeTo(String to, HierarchicalStreamWriter writer) {
        writer.startNode("To");
        writer.setValue(to);
        writer.endNode();
    }

    protected void writeTo(String to, JsonObject object) {
        object.addProperty("to", to);
    }

    protected void writeTimeToLive(int timeToLive, HierarchicalStreamWriter writer) {
        writer.startNode("TimeToLive");
        writer.setValue(Integer.toString(timeToLive));
        writer.endNode();
    }

    protected void writeTimeToLive(int timeToLive, JsonObject object) {
        object.addProperty("time_to_live", (Number)timeToLive);
    }

    protected void writeType(String type, HierarchicalStreamWriter writer) {
        writer.startNode("Type");
        writer.setValue(type);
        writer.endNode();
    }

    protected void writeType(String type, JsonObject object) {
        object.addProperty("type", type);
    }

    protected void writeUri(URI uri, HierarchicalStreamWriter writer) {
        writer.startNode("Uri");
        writer.setValue(uri.toString());
        writer.endNode();
    }

    protected void writeUri(URI uri, JsonObject object) {
        object.addProperty("uri", uri.toString() + ".json");
    }

    protected void writeUserName(String userName, HierarchicalStreamWriter writer) {
        writer.startNode("UserName");
        writer.setValue(userName);
        writer.endNode();
    }

    protected void writeUserName(String userName, JsonObject object) {
        object.addProperty("user_name", userName);
    }

    protected void writeVoiceApplicationSid(Sid voiceApplicationSid, HierarchicalStreamWriter writer) {
        writer.startNode("VoiceApplicationSid");
        if (voiceApplicationSid != null) {
            writer.setValue(voiceApplicationSid.toString());
        } else {
            writer.setValue(null);
        }
        writer.endNode();
    }

    protected void writeVoiceApplicationSid(Sid voiceApplicationSid, JsonObject object) {
        if (voiceApplicationSid != null) {
            object.addProperty("voice_application_sid", voiceApplicationSid.toString());
        } else {
            object.add("voice_application_sid", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeVoiceCallerIdLookup(boolean voiceCallerIdLookup, HierarchicalStreamWriter writer) {
        writer.startNode("VoiceCallerIdLookup");
        writer.setValue(Boolean.toString(voiceCallerIdLookup));
        writer.endNode();
    }

    protected void writeVoiceCallerIdLookup(boolean voiceCallerIdLookup, JsonObject object) {
        object.addProperty("voice_caller_id_lookup", Boolean.valueOf(voiceCallerIdLookup));
    }

    protected void writeVoiceFallbackMethod(String voiceFallbackMethod, HierarchicalStreamWriter writer) {
        writer.startNode("VoiceFallbackMethod");
        if (voiceFallbackMethod != null) {
            writer.setValue(voiceFallbackMethod);
        }
        writer.endNode();
    }

    protected void writeVoiceFallbackMethod(String voiceFallbackMethod, JsonObject object) {
        if (voiceFallbackMethod != null) {
            object.addProperty("voice_fallback_method", voiceFallbackMethod);
        } else {
            object.add("voice_fallback_method", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeVoiceFallbackUrl(URI voiceFallbackUri, HierarchicalStreamWriter writer) {
        writer.startNode("VoiceFallbackUrl");
        if (voiceFallbackUri != null) {
            writer.setValue(voiceFallbackUri.toString());
        } else {
            writer.setValue(null);
        }
        writer.endNode();
    }

    protected void writeVoiceFallbackUrl(URI voiceFallbackUri, JsonObject object) {
        if (voiceFallbackUri != null) {
            object.addProperty("voice_fallback_url", voiceFallbackUri.toString());
        } else {
            object.add("voice_fallback_url", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeVoiceMethod(String voiceMethod, HierarchicalStreamWriter writer) {
        writer.startNode("VoiceMethod");
        if (voiceMethod != null) {
            writer.setValue(voiceMethod);
        }
        writer.endNode();
    }

    protected void writeVoiceMethod(String voiceMethod, JsonObject object) {
        if (voiceMethod != null) {
            object.addProperty("voice_method", voiceMethod);
        } else {
            object.add("voice_method", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeVoiceUrl(URI voiceUrl, HierarchicalStreamWriter writer) {
        writer.startNode("VoiceUrl");
        if (voiceUrl != null) {
            writer.setValue(voiceUrl.toString());
        } else {
            writer.setValue(null);
        }
        writer.endNode();
    }

    protected void writeVoiceUrl(URI voiceUrl, JsonObject object) {
        if (voiceUrl != null) {
            object.addProperty("voice_url", voiceUrl.toString());
        } else {
            object.add("voice_url", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeCapabilities(Boolean voiceCapable, Boolean smsCapable, Boolean mmsCapable, Boolean faxCapable, HierarchicalStreamWriter writer) {
        writer.startNode("Capabilities");
        this.writeVoiceCapability(voiceCapable, writer);
        this.writeSmsCapability(smsCapable, writer);
        this.writeMmsCapability(mmsCapable, writer);
        this.writeFaxCapability(faxCapable, writer);
        writer.endNode();
    }

    protected void writeCapabilities(Boolean voiceCapable, Boolean smsCapable, Boolean mmsCapable, Boolean faxCapable, JsonObject object) {
        JsonObject capabilities = new JsonObject();
        this.writeVoiceCapability(voiceCapable, capabilities);
        this.writeSmsCapability(smsCapable, capabilities);
        this.writeMmsCapability(mmsCapable, capabilities);
        this.writeFaxCapability(faxCapable, capabilities);
        object.add("capabilities", (JsonElement)capabilities);
    }

    protected void writeVoiceCapability(Boolean voiceCapable, HierarchicalStreamWriter writer) {
        writer.startNode("Voice");
        if (voiceCapable == null) {
            writer.setValue(Boolean.FALSE.toString());
        } else {
            writer.setValue(voiceCapable.toString());
        }
        writer.endNode();
    }

    protected void writeVoiceCapability(Boolean voiceCapable, JsonObject object) {
        if (voiceCapable != null) {
            object.addProperty("voice_capable", voiceCapable);
        } else {
            object.addProperty("voice_capable", Boolean.FALSE);
        }
    }

    protected void writeSmsCapability(Boolean smsCapable, HierarchicalStreamWriter writer) {
        writer.startNode("Sms");
        if (smsCapable == null) {
            writer.setValue(Boolean.FALSE.toString());
        } else {
            writer.setValue(smsCapable.toString());
        }
        writer.endNode();
    }

    protected void writeSmsCapability(Boolean smsCapable, JsonObject object) {
        if (smsCapable != null) {
            object.addProperty("sms_capable", smsCapable);
        } else {
            object.addProperty("sms_capable", Boolean.FALSE);
        }
    }

    protected void writeMmsCapability(Boolean mmsCapable, HierarchicalStreamWriter writer) {
        writer.startNode("Mms");
        if (mmsCapable == null) {
            writer.setValue(Boolean.FALSE.toString());
        } else {
            writer.setValue(mmsCapable.toString());
        }
        writer.endNode();
    }

    protected void writeMmsCapability(Boolean mmsCapable, JsonObject object) {
        if (mmsCapable != null) {
            object.addProperty("mms_capable", mmsCapable);
        } else {
            object.addProperty("mms_capable", Boolean.FALSE);
        }
    }

    protected void writeFaxCapability(Boolean faxCapable, HierarchicalStreamWriter writer) {
        writer.startNode("Fax");
        if (faxCapable == null) {
            writer.setValue(Boolean.FALSE.toString());
        } else {
            writer.setValue(faxCapable.toString());
        }
        writer.endNode();
    }

    protected void writeFaxCapability(Boolean faxCapable, JsonObject object) {
        if (faxCapable != null) {
            object.addProperty("fax_capable", faxCapable);
        } else {
            object.addProperty("fax_capable", Boolean.FALSE);
        }
    }
}

