/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.Header;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.util.HttpUtils;
import org.mobicents.servlet.restcomm.util.StringUtils;

@ThreadSafe
public final class HttpResponseDescriptor {
    private final URI uri;
    private final int statusCode;
    private final String statusDescription;
    private final InputStream content;
    private final long contentLength;
    private final String contentEncoding;
    private final String contentType;
    private final boolean isChunked;
    private final Header[] headers;
    private volatile String buffer;

    private HttpResponseDescriptor(URI uri, int statusCode, String statusDescription, InputStream content, long contentLength, String contentEncoding, String contentType, boolean isChunked, Header[] headers) {
        this.uri = uri;
        this.statusCode = statusCode;
        this.statusDescription = statusDescription;
        this.content = content;
        this.contentLength = contentLength;
        this.contentEncoding = contentEncoding;
        this.contentType = contentType;
        this.isChunked = isChunked;
        this.headers = headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public InputStream getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsString() throws IOException {
        if (this.buffer != null) {
            return this.buffer;
        }
        HttpResponseDescriptor httpResponseDescriptor = this;
        synchronized (httpResponseDescriptor) {
            if (this.buffer == null) {
                this.buffer = StringUtils.toString((InputStream)this.content);
            }
        }
        return this.buffer;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public String getHeadersAsString() {
        return HttpUtils.toString((Header[])this.headers);
    }

    public URI getURI() {
        return this.uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private URI uri;
        private int statusCode;
        private String statusDescription;
        private InputStream content;
        private long contentLength;
        private String contentEncoding;
        private String contentType;
        private boolean isChunked;
        private Header[] headers;

        private Builder() {
        }

        public HttpResponseDescriptor build() {
            return new HttpResponseDescriptor(this.uri, this.statusCode, this.statusDescription, this.content, this.contentLength, this.contentEncoding, this.contentType, this.isChunked, this.headers);
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        public void setContent(InputStream content) {
            this.content = content;
        }

        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
        }

        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setIsChunked(boolean isChunked) {
            this.isChunked = isChunked;
        }

        public void setHeaders(Header[] headers) {
            this.headers = headers;
        }

        public void setURI(URI uri) {
            this.uri = uri;
        }
    }
}

