/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.client;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;

@Immutable
public final class HttpRequestDescriptor {
    private final URI uri;
    private final String method;
    private final List<NameValuePair> parameters;

    public HttpRequestDescriptor(URI uri, String method, List<NameValuePair> parameters) {
        this.uri = this.base(uri);
        this.method = method;
        this.parameters = parameters != null ? parameters : new ArrayList<NameValuePair>();
        String query = uri.getQuery();
        if (query != null) {
            List other = URLEncodedUtils.parse((URI)uri, (String)"UTF-8");
            parameters.addAll(other);
        }
    }

    public HttpRequestDescriptor(URI uri, String method) throws UnsupportedEncodingException, URISyntaxException {
        this(uri, method, null);
    }

    private URI base(URI uri) {
        try {
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setScheme(uri.getScheme());
            uriBuilder.setHost(uri.getHost());
            uriBuilder.setPort(uri.getPort());
            uriBuilder.setPath(uri.getPath());
            if (uri.getUserInfo() != null) {
                uriBuilder.setUserInfo(uri.getUserInfo());
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException ignored) {
            return null;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public List<NameValuePair> getParameters() {
        return this.parameters;
    }

    public String getParametersAsString() {
        return URLEncodedUtils.format(this.parameters, (String)"UTF-8");
    }

    public URI getUri() {
        return this.uri;
    }
}

