/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.mobicents.servlet.restcomm.http.client.DownloaderResponse;
import org.mobicents.servlet.restcomm.http.client.HttpRequestDescriptor;
import org.mobicents.servlet.restcomm.http.client.HttpResponseDescriptor;

public final class Downloader
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));

    public HttpResponseDescriptor fetch(HttpRequestDescriptor descriptor) throws IllegalArgumentException, IOException, URISyntaxException {
        int code = -1;
        HttpUriRequest request = null;
        HttpResponse response = null;
        HttpRequestDescriptor temp = descriptor;
        do {
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
            request = this.request(temp);
            response = client.execute(request);
            code = response.getStatusLine().getStatusCode();
            if (!this.isRedirect(code)) continue;
            Header header = response.getFirstHeader("Location");
            if (header == null) break;
            String location = header.getValue();
            URI uri = URI.create(location);
            temp = new HttpRequestDescriptor(uri, temp.getMethod(), temp.getParameters());
        } while (this.isRedirect(code));
        if (this.isHttpError(code)) {
            String requestUrl = request.getRequestLine().getUri();
            String errorReason = response.getStatusLine().getReasonPhrase();
            String httpErrorMessage = String.format("Error while fetching http resource: %s \n Http error code: %d \n Http error message: %s", requestUrl, code, errorReason);
            this.logger.warning(httpErrorMessage);
        }
        return this.response((HttpRequest)request, response);
    }

    private boolean isRedirect(int code) {
        return 301 == code || 302 == code || 303 == code || 307 == code;
    }

    private boolean isHttpError(int code) {
        return code >= 400;
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (HttpRequestDescriptor.class.equals(klass)) {
            HttpRequestDescriptor request = (HttpRequestDescriptor)message;
            DownloaderResponse response = null;
            try {
                response = new DownloaderResponse(this.fetch(request));
            }
            catch (Exception exception) {
                response = new DownloaderResponse(exception);
            }
            if (sender != null) {
                sender.tell((Object)response, self);
            }
        }
    }

    public HttpUriRequest request(HttpRequestDescriptor descriptor) throws IllegalArgumentException, URISyntaxException, UnsupportedEncodingException {
        URI uri = descriptor.getUri();
        String method = descriptor.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            String query = descriptor.getParametersAsString();
            URI result = null;
            result = query != null && !query.isEmpty() ? new URIBuilder().setScheme(uri.getScheme()).setHost(uri.getHost()).setPort(uri.getPort()).setPath(uri.getPath()).setQuery(query).build() : uri;
            return new HttpGet(result);
        }
        if ("POST".equalsIgnoreCase(method)) {
            List<NameValuePair> parameters = descriptor.getParameters();
            HttpPost post = new HttpPost(uri);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, "UTF-8"));
            return post;
        }
        throw new IllegalArgumentException(method + " is not a supported downloader method.");
    }

    private HttpResponseDescriptor response(HttpRequest request, HttpResponse response) throws IOException {
        HttpResponseDescriptor.Builder builder = HttpResponseDescriptor.builder();
        URI uri = URI.create(request.getRequestLine().getUri());
        builder.setURI(uri);
        builder.setStatusCode(response.getStatusLine().getStatusCode());
        builder.setStatusDescription(response.getStatusLine().getReasonPhrase());
        builder.setHeaders(response.getAllHeaders());
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            Header contentType;
            Header contentEncoding = entity.getContentEncoding();
            if (contentEncoding != null) {
                builder.setContentEncoding(contentEncoding.getValue());
            }
            if ((contentType = entity.getContentType()) != null) {
                builder.setContentType(contentType.getValue());
            }
            builder.setContent(entity.getContent());
            builder.setContentLength(entity.getContentLength());
            builder.setIsChunked(entity.isChunked());
        }
        return builder.build();
    }
}

