/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.authz.AuthorizationException;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.entities.CallDetailRecord;
import org.mobicents.servlet.restcomm.entities.CallDetailRecordList;
import org.mobicents.servlet.restcomm.entities.RestCommResponse;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.AbstractEndpoint;
import org.mobicents.servlet.restcomm.http.converter.CallDetailRecordConverter;
import org.mobicents.servlet.restcomm.http.converter.CallDetailRecordListConverter;
import org.mobicents.servlet.restcomm.http.converter.RestCommResponseConverter;
import org.mobicents.servlet.restcomm.telephony.CallInfo;
import org.mobicents.servlet.restcomm.telephony.CallManagerResponse;
import org.mobicents.servlet.restcomm.telephony.CallResponse;
import org.mobicents.servlet.restcomm.telephony.CreateCall;
import org.mobicents.servlet.restcomm.telephony.ExecuteCallScript;
import org.mobicents.servlet.restcomm.telephony.GetCallInfo;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class UssdPushEndpoint
extends AbstractEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    private ActorRef ussdCallManager;
    private DaoManager daos;
    private Gson gson;
    private GsonBuilder builder;
    private XStream xstream;
    private CallDetailRecordListConverter listConverter;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.ussdCallManager = (ActorRef)this.context.getAttribute("org.mobicents.servlet.restcomm.ussd.telephony.UssdCallManager");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        super.init(this.configuration);
        CallDetailRecordConverter converter = new CallDetailRecordConverter(this.configuration);
        this.listConverter = new CallDetailRecordListConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(CallDetailRecord.class, (Object)converter);
        this.builder.registerTypeAdapter(CallDetailRecordList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
    }

    protected Response putCall(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        Sid accountId = new Sid(accountSid);
        try {
            this.secure(this.daos.getAccountsDao().getAccount(accountSid), "RestComm:Create:Calls");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.validate(data);
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        String from = (String)data.getFirst((Object)"From");
        String to = (String)data.getFirst((Object)"To");
        String username = (String)data.getFirst((Object)"Username");
        String password = (String)data.getFirst((Object)"Password");
        Integer timeout = this.getTimeout(data);
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        CreateCall create = null;
        try {
            CallResponse callResponse;
            ActorRef call;
            CallManagerResponse managerResponse;
            create = new CreateCall(from, to, username, password, true, timeout != null ? timeout : 30, CreateCall.Type.USSD, accountId);
            create.setCreateCDR(false);
            Future future = Patterns.ask((ActorRef)this.ussdCallManager, (Object)create, (Timeout)expires);
            Object object = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
            Class<?> klass = object.getClass();
            if (CallManagerResponse.class.equals(klass) && (managerResponse = (CallManagerResponse)object).succeeded() && CallResponse.class.equals(klass = (object = Await.result((Awaitable)(future = Patterns.ask((ActorRef)(call = (ActorRef)managerResponse.get()), (Object)new GetCallInfo(), (Timeout)expires)), (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS))).getClass()) && (callResponse = (CallResponse)object).succeeded()) {
                CallInfo callInfo = (CallInfo)callResponse.get();
                String version = this.getApiVersion(data);
                URI url = this.getUrl("Url", data);
                String method = this.getMethod("Method", data);
                URI fallbackUrl = this.getUrl("FallbackUrl", data);
                String fallbackMethod = this.getMethod("FallbackMethod", data);
                URI callback = this.getUrl("StatusCallback", data);
                String callbackMethod = this.getMethod("StatusCallbackMethod", data);
                ExecuteCallScript execute = new ExecuteCallScript(call, accountId, version, url, method, fallbackUrl, fallbackMethod, callback, callbackMethod);
                this.ussdCallManager.tell((Object)execute, null);
                CallDetailRecord cdr = this.daos.getCallDetailRecordsDao().getCallDetailRecord(callInfo.sid());
                if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                    return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
                }
                if (MediaType.APPLICATION_XML_TYPE == responseType) {
                    return Response.ok((Object)this.xstream.toXML((Object)new RestCommResponse((Object)cdr)), (String)"application/xml").build();
                }
                return null;
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
    }

    private Integer getTimeout(MultivaluedMap<String, String> data) {
        Integer result = 60;
        if (data.containsKey((Object)"Timeout")) {
            result = Integer.parseInt((String)data.getFirst((Object)"Timeout"));
        }
        return result;
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"From")) {
            throw new NullPointerException("From can not be null.");
        }
        if (!data.containsKey((Object)"To")) {
            throw new NullPointerException("To can not be null.");
        }
        if (!data.containsKey((Object)"Url")) {
            throw new NullPointerException("Url can not be null.");
        }
    }
}

