/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.AuthorizationException;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.TranscriptionsEndpoint;

@Path(value="/Accounts/{accountSid}/Transcriptions")
public final class TranscriptionsXmlEndpoint
extends TranscriptionsEndpoint {
    @Path(value="/{sid}")
    @DELETE
    public Response deleteTranscription(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Delete:Transcriptions");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.dao.removeTranscription(new Sid(sid));
        return Response.ok().build();
    }

    @Path(value="/{sid}.json")
    @GET
    public Response getTranscriptionAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getTranscription(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getTranscriptionAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getTranscription(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getTranscriptions(@PathParam(value="accountSid") String accountSid) {
        return this.getTranscriptions(accountSid, MediaType.APPLICATION_XML_TYPE);
    }
}

