/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.authz.AuthorizationException;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.SmsMessagesDao;
import org.mobicents.servlet.restcomm.entities.RestCommResponse;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.entities.SmsMessage;
import org.mobicents.servlet.restcomm.entities.SmsMessageList;
import org.mobicents.servlet.restcomm.http.AbstractEndpoint;
import org.mobicents.servlet.restcomm.http.converter.RestCommResponseConverter;
import org.mobicents.servlet.restcomm.http.converter.SmsMessageConverter;
import org.mobicents.servlet.restcomm.http.converter.SmsMessageListConverter;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.sms.CreateSmsSession;
import org.mobicents.servlet.restcomm.sms.SmsServiceResponse;
import org.mobicents.servlet.restcomm.sms.SmsSessionAttribute;
import org.mobicents.servlet.restcomm.sms.SmsSessionInfo;
import org.mobicents.servlet.restcomm.sms.SmsSessionRequest;
import org.mobicents.servlet.restcomm.sms.SmsSessionResponse;
import org.mobicents.servlet.restcomm.util.StringUtils;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

@NotThreadSafe
public abstract class SmsMessagesEndpoint
extends AbstractEndpoint {
    @Context
    protected ServletContext context;
    protected ActorSystem system;
    protected Configuration configuration;
    protected ActorRef aggregator;
    protected SmsMessagesDao dao;
    protected Gson gson;
    protected XStream xstream;
    protected AccountsDao accountsDao;
    private boolean normalizePhoneNumbers;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.dao = storage.getSmsMessagesDao();
        this.accountsDao = storage.getAccountsDao();
        this.aggregator = (ActorRef)this.context.getAttribute("org.mobicents.servlet.restcomm.sms.SmsService");
        this.system = (ActorSystem)this.context.getAttribute(ActorSystem.class.getName());
        super.init(this.configuration);
        SmsMessageConverter converter = new SmsMessageConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(SmsMessage.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new SmsMessageListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.normalizePhoneNumbers = this.configuration.getBoolean("normalize-numbers-for-outbound-calls");
    }

    protected Response getSmsMessage(String accountSid, String sid, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:SmsMessages");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SmsMessage smsMessage = this.dao.getSmsMessage(new Sid(sid));
        if (smsMessage == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)smsMessage), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)smsMessage);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getSmsMessages(String accountSid, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:SmsMessages");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List smsMessages = this.dao.getSmsMessages(new Sid(accountSid));
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)smsMessages), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new SmsMessageList(smsMessages));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    private void normalize(MultivaluedMap<String, String> data) throws IllegalArgumentException {
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        String from = (String)data.getFirst((Object)"From");
        data.remove((Object)"From");
        try {
            data.putSingle((Object)"From", (Object)phoneNumberUtil.format(phoneNumberUtil.parse(from, "US"), PhoneNumberUtil.PhoneNumberFormat.E164));
        }
        catch (NumberParseException exception) {
            throw new IllegalArgumentException(exception);
        }
        String to = (String)data.getFirst((Object)"To");
        data.remove((Object)"To");
        try {
            data.putSingle((Object)"To", (Object)phoneNumberUtil.format(phoneNumberUtil.parse(to, "US"), PhoneNumberUtil.PhoneNumberFormat.E164));
        }
        catch (NumberParseException exception) {
            throw new IllegalArgumentException(exception);
        }
        String body = (String)data.getFirst((Object)"Body");
        if (body.getBytes().length > 160) {
            data.remove((Object)"Body");
            data.putSingle((Object)"Body", (Object)body.substring(0, 159));
        }
    }

    protected Response putSmsMessage(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Create:SmsMessages");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.validate(data);
            if (this.normalizePhoneNumbers) {
                this.normalize(data);
            }
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        String sender = (String)data.getFirst((Object)"From");
        String recipient = (String)data.getFirst((Object)"To");
        String body = (String)data.getFirst((Object)"Body");
        ConcurrentHashMap<String, Object> customRestOutgoingHeaderMap = new ConcurrentHashMap<String, Object>();
        for (String name : data.keySet()) {
            if (!name.startsWith("X-")) continue;
            customRestOutgoingHeaderMap.put(name, data.getFirst((Object)name));
        }
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        try {
            SmsServiceResponse smsServiceResponse;
            Future future = Patterns.ask((ActorRef)this.aggregator, (Object)new CreateSmsSession(), (Timeout)expires);
            Object object = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
            Class<?> klass = object.getClass();
            if (SmsServiceResponse.class.equals(klass) && (smsServiceResponse = (SmsServiceResponse)object).succeeded()) {
                SmsMessage record = this.sms(new Sid(accountSid), this.getApiVersion(data), sender, recipient, body, SmsMessage.Status.SENDING, SmsMessage.Direction.OUTBOUND_API);
                this.dao.addSmsMessage(record);
                ActorRef session = (ActorRef)smsServiceResponse.get();
                ActorRef observer = this.observer();
                session.tell((Object)new Observe(observer), observer);
                session.tell((Object)new SmsSessionAttribute("record", (Object)record), null);
                SmsSessionRequest request = new SmsSessionRequest(sender, recipient, body, customRestOutgoingHeaderMap);
                session.tell((Object)request, null);
                if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                    return Response.ok((Object)this.gson.toJson((Object)record), (String)"application/json").build();
                }
                if (MediaType.APPLICATION_XML_TYPE == responseType) {
                    RestCommResponse response = new RestCommResponse((Object)record);
                    return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
                }
                return null;
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
    }

    private SmsMessage sms(Sid accountSid, String apiVersion, String sender, String recipient, String body, SmsMessage.Status status, SmsMessage.Direction direction) {
        SmsMessage.Builder builder = SmsMessage.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.SMS_MESSAGE);
        builder.setSid(sid);
        builder.setAccountSid(accountSid);
        builder.setSender(sender);
        builder.setRecipient(recipient);
        builder.setBody(body);
        builder.setStatus(status);
        builder.setDirection(direction);
        builder.setPrice(new BigDecimal(0.0));
        builder.setPriceUnit(Currency.getInstance("USD"));
        builder.setApiVersion(apiVersion);
        String rootUri = this.configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(apiVersion).append("/Accounts/");
        buffer.append(accountSid.toString()).append("/SMS/Messages/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"From")) {
            throw new NullPointerException("From can not be null.");
        }
        if (!data.containsKey((Object)"To")) {
            throw new NullPointerException("To can not be null.");
        }
        if (!data.containsKey((Object)"Body")) {
            throw new NullPointerException("Body can not be null.");
        }
    }

    private ActorRef observer() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmsSessionObserver();
            }
        }));
    }

    private final class SmsSessionObserver
    extends UntypedActor {
        public void onReceive(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (SmsSessionResponse.class.equals(klass)) {
                SmsSessionResponse response = (SmsSessionResponse)message;
                SmsSessionInfo info = response.info();
                SmsMessage record = (SmsMessage)info.attributes().get("record");
                if (response.succeeded()) {
                    DateTime now = DateTime.now();
                    record = record.setDateSent(now);
                    record = record.setStatus(SmsMessage.Status.SENT);
                } else {
                    record = record.setStatus(SmsMessage.Status.FAILED);
                }
                SmsMessagesEndpoint.this.dao.updateSmsMessage(record);
                UntypedActorContext context = this.getContext();
                ActorRef self = this.self();
                context.stop(self);
            }
        }
    }
}

