/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.AuthorizationException;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.OutgoingCallerIdsEndpoint;

@Path(value="/Accounts/{accountSid}/OutgoingCallerIds")
@ThreadSafe
public final class OutgoingCallerIdsXmlEndpoint
extends OutgoingCallerIdsEndpoint {
    private Response deleteOutgoingCallerId(String accountSid, String sid) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Delete:OutgoingCallerIds");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.dao.removeOutgoingCallerId(new Sid(sid));
        return Response.ok().build();
    }

    @Path(value="/{sid}.json")
    @DELETE
    public Response deleteOutgoingCallerIdAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteOutgoingCallerId(accountSid, sid);
    }

    @Path(value="/{sid}")
    @DELETE
    public Response deleteOutgoingCallerIdAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteOutgoingCallerId(accountSid, sid);
    }

    @Path(value="/{sid}.json")
    @GET
    public Response getCallerIdAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getCallerId(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getCallerIdAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getCallerId(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getCallerIds(@PathParam(value="accountSid") String accountSid) {
        return this.getCallerIds(accountSid, MediaType.APPLICATION_XML_TYPE);
    }

    @POST
    public Response putOutgoingCallerId(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putOutgoingCallerId(accountSid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}.json")
    @PUT
    public Response updateOutgoingCallerIdAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateOutgoingCallerId(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @PUT
    public Response updateOutgoingCallerIdAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateOutgoingCallerId(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }
}

