/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.http.IncomingPhoneNumbersEndpoint;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberType;

@Path(value="/Accounts/{accountSid}/IncomingPhoneNumbers")
@ThreadSafe
public final class IncomingPhoneNumbersXmlEndpoint
extends IncomingPhoneNumbersEndpoint {
    @Path(value="/{sid}.json")
    @DELETE
    public Response deleteIncomingPhoneNumberAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return super.deleteIncomingPhoneNumber(accountSid, sid);
    }

    @Path(value="/{sid}")
    @DELETE
    public Response deleteIncomingPhoneNumberAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return super.deleteIncomingPhoneNumber(accountSid, sid);
    }

    @Path(value="/{sid}.json")
    @GET
    public Response getIncomingPhoneNumberAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getIncomingPhoneNumber(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getIncomingPhoneNumberAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getIncomingPhoneNumber(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/AvailableCountries.json")
    @GET
    public Response getAvailableCountriesAsJson(@PathParam(value="accountSid") String accountSid) {
        return this.getAvailableCountries(accountSid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/AvailableCountries")
    @GET
    public Response getAvailableCountriesAsXml(@PathParam(value="accountSid") String accountSid) {
        return this.getAvailableCountries(accountSid, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getIncomingPhoneNumbers(@PathParam(value="accountSid") String accountSid, @QueryParam(value="PhoneNumber") String phoneNumber, @QueryParam(value="FriendlyName") String friendlyName) {
        return this.getIncomingPhoneNumbers(accountSid, phoneNumber, friendlyName, PhoneNumberType.Global, MediaType.APPLICATION_XML_TYPE);
    }

    @POST
    public Response putIncomingPhoneNumber(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putIncomingPhoneNumber(accountSid, data, PhoneNumberType.Global, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}.json")
    @PUT
    public Response updateIncomingPhoneNumberAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateIncomingPhoneNumber(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}.json")
    @POST
    public Response updateIncomingPhoneNumberAsJsonPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateIncomingPhoneNumber(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @PUT
    public Response updateIncomingPhoneNumberAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateIncomingPhoneNumber(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}")
    @POST
    public Response updateIncomingPhoneNumberAsXmlPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateIncomingPhoneNumber(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Local")
    @GET
    public Response getIncomingLocalPhoneNumbersAsXml(@PathParam(value="accountSid") String accountSid, @QueryParam(value="PhoneNumber") String phoneNumber, @QueryParam(value="FriendlyName") String friendlyName) {
        return this.getIncomingPhoneNumbers(accountSid, phoneNumber, friendlyName, PhoneNumberType.Local, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Local")
    @POST
    public Response putIncomingLocalPhoneNumberAsXml(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putIncomingPhoneNumber(accountSid, data, PhoneNumberType.Local, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Local.json")
    @GET
    public Response getIncomingLocalPhoneNumbersAsJSon(@PathParam(value="accountSid") String accountSid, @QueryParam(value="PhoneNumber") String phoneNumber, @QueryParam(value="FriendlyName") String friendlyName) {
        return this.getIncomingPhoneNumbers(accountSid, phoneNumber, friendlyName, PhoneNumberType.Local, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Local.json")
    @POST
    public Response putIncomingLocalPhoneNumberAsJSon(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putIncomingPhoneNumber(accountSid, data, PhoneNumberType.Local, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/TollFree")
    @GET
    public Response getIncomingTollFreePhoneNumbersAsXml(@PathParam(value="accountSid") String accountSid, @QueryParam(value="PhoneNumber") String phoneNumber, @QueryParam(value="FriendlyName") String friendlyName) {
        return this.getIncomingPhoneNumbers(accountSid, phoneNumber, friendlyName, PhoneNumberType.TollFree, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/TollFree")
    @POST
    public Response putIncomingTollFreePhoneNumberAsXml(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putIncomingPhoneNumber(accountSid, data, PhoneNumberType.TollFree, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/TollFree.json")
    @GET
    public Response getIncomingTollFreePhoneNumbersAsJSon(@PathParam(value="accountSid") String accountSid, @QueryParam(value="PhoneNumber") String phoneNumber, @QueryParam(value="FriendlyName") String friendlyName) {
        return this.getIncomingPhoneNumbers(accountSid, phoneNumber, friendlyName, PhoneNumberType.TollFree, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/TollFree.json")
    @POST
    public Response putIncomingTollFreePhoneNumberAsJSon(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putIncomingPhoneNumber(accountSid, data, PhoneNumberType.TollFree, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Mobile")
    @GET
    public Response getIncomingMobilePhoneNumbersAsXml(@PathParam(value="accountSid") String accountSid, @QueryParam(value="PhoneNumber") String phoneNumber, @QueryParam(value="FriendlyName") String friendlyName) {
        return this.getIncomingPhoneNumbers(accountSid, phoneNumber, friendlyName, PhoneNumberType.Mobile, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Mobile")
    @POST
    public Response putIncomingMobilePhoneNumberAsXml(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putIncomingPhoneNumber(accountSid, data, PhoneNumberType.Mobile, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Mobile.json")
    @GET
    public Response getIncomingMobilePhoneNumbersAsJSon(@PathParam(value="accountSid") String accountSid, @QueryParam(value="PhoneNumber") String phoneNumber, @QueryParam(value="FriendlyName") String friendlyName) {
        return this.getIncomingPhoneNumbers(accountSid, phoneNumber, friendlyName, PhoneNumberType.Mobile, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Mobile.json")
    @POST
    public Response putIncomingMobilePhoneNumberAsJSon(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putIncomingPhoneNumber(accountSid, data, PhoneNumberType.Mobile, MediaType.APPLICATION_JSON_TYPE);
    }
}

