/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipURI;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.authz.AuthorizationException;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.IncomingPhoneNumbersDao;
import org.mobicents.servlet.restcomm.entities.IncomingPhoneNumber;
import org.mobicents.servlet.restcomm.entities.IncomingPhoneNumberFilter;
import org.mobicents.servlet.restcomm.entities.IncomingPhoneNumberList;
import org.mobicents.servlet.restcomm.entities.RestCommResponse;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.AbstractEndpoint;
import org.mobicents.servlet.restcomm.http.converter.AvailableCountriesConverter;
import org.mobicents.servlet.restcomm.http.converter.AvailableCountriesList;
import org.mobicents.servlet.restcomm.http.converter.IncomingPhoneNumberConverter;
import org.mobicents.servlet.restcomm.http.converter.IncomingPhoneNumberListConverter;
import org.mobicents.servlet.restcomm.http.converter.RestCommResponseConverter;
import org.mobicents.servlet.restcomm.loader.ObjectFactory;
import org.mobicents.servlet.restcomm.loader.ObjectInstantiationException;
import org.mobicents.servlet.restcomm.provisioning.number.api.ContainerConfiguration;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumber;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberParameters;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberProvisioningManager;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberType;
import org.mobicents.servlet.restcomm.util.StringUtils;

@NotThreadSafe
public abstract class IncomingPhoneNumbersEndpoint
extends AbstractEndpoint {
    @Context
    protected ServletContext context;
    protected PhoneNumberProvisioningManager phoneNumberProvisioningManager;
    PhoneNumberParameters phoneNumberParameters;
    private IncomingPhoneNumbersDao dao;
    protected AccountsDao accountsDao;
    private XStream xstream;
    protected Gson gson;

    @PostConstruct
    public void init() throws ObjectInstantiationException {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        super.init(this.configuration.subset("runtime-settings"));
        this.dao = storage.getIncomingPhoneNumbersDao();
        this.accountsDao = storage.getAccountsDao();
        this.phoneNumberProvisioningManager = (PhoneNumberProvisioningManager)this.context.getAttribute("PhoneNumberProvisioningManager");
        if (this.phoneNumberProvisioningManager == null) {
            String phoneNumberProvisioningManagerClass = this.configuration.getString("phone-number-provisioning[@class]");
            Configuration phoneNumberProvisioningConfiguration = this.configuration.subset("phone-number-provisioning");
            Configuration telestaxProxyConfiguration = this.configuration.subset("runtime-settings").subset("telestax-proxy");
            this.phoneNumberProvisioningManager = (PhoneNumberProvisioningManager)new ObjectFactory(this.getClass().getClassLoader()).getObjectInstance(phoneNumberProvisioningManagerClass);
            ContainerConfiguration containerConfiguration = new ContainerConfiguration(this.getOutboundInterfaces());
            this.phoneNumberProvisioningManager.init(phoneNumberProvisioningConfiguration, telestaxProxyConfiguration, containerConfiguration);
            this.context.setAttribute("phoneNumberProvisioningManager", (Object)this.phoneNumberProvisioningManager);
        }
        Configuration callbackUrlsConfiguration = this.configuration.subset("phone-number-provisioning").subset("callback-urls");
        this.phoneNumberParameters = new PhoneNumberParameters(callbackUrlsConfiguration.getString("voice[@url]"), callbackUrlsConfiguration.getString("voice[@method]"), false, callbackUrlsConfiguration.getString("sms[@url]"), callbackUrlsConfiguration.getString("sms[@method]"), callbackUrlsConfiguration.getString("fax[@url]"), callbackUrlsConfiguration.getString("fax[@method]"), callbackUrlsConfiguration.getString("ussd[@url]"), callbackUrlsConfiguration.getString("ussd[@method]"));
        IncomingPhoneNumberConverter converter = new IncomingPhoneNumberConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        builder.registerTypeAdapter(IncomingPhoneNumber.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new IncomingPhoneNumberListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new AvailableCountriesConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    private IncomingPhoneNumber createFrom(Sid accountSid, MultivaluedMap<String, String> data) {
        IncomingPhoneNumber.Builder builder = IncomingPhoneNumber.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.PHONE_NUMBER);
        builder.setSid(sid);
        builder.setAccountSid(accountSid);
        String phoneNumber = (String)data.getFirst((Object)"PhoneNumber");
        builder.setPhoneNumber(phoneNumber);
        builder.setFriendlyName(this.getFriendlyName(phoneNumber, data));
        if (data.containsKey((Object)"VoiceCapable")) {
            builder.setVoiceCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"VoiceCapable"))));
        }
        if (data.containsKey((Object)"SmsCapable")) {
            builder.setSmsCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"SmsCapable"))));
        }
        if (data.containsKey((Object)"MmsCapable")) {
            builder.setMmsCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"MmsCapable"))));
        }
        if (data.containsKey((Object)"FaxCapable")) {
            builder.setFaxCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"FaxCapable"))));
        }
        if (data.containsKey((Object)"isSIP")) {
            builder.setPureSip(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"isSIP"))));
        } else {
            builder.setPureSip(Boolean.valueOf(false));
        }
        String apiVersion = this.getApiVersion(data);
        builder.setApiVersion(apiVersion);
        builder.setVoiceUrl(this.getUrl("VoiceUrl", data));
        builder.setVoiceMethod(this.getMethod("VoiceMethod", data));
        builder.setVoiceFallbackUrl(this.getUrl("VoiceFallbackUrl", data));
        builder.setVoiceFallbackMethod(this.getMethod("VoiceFallbackMethod", data));
        builder.setStatusCallback(this.getUrl("StatusCallback", data));
        builder.setStatusCallbackMethod(this.getMethod("StatusCallbackMethod", data));
        builder.setHasVoiceCallerIdLookup(this.getHasVoiceCallerIdLookup(data));
        builder.setVoiceApplicationSid(this.getSid("VoiceApplicationSid", data));
        builder.setSmsUrl(this.getUrl("SmsUrl", data));
        builder.setSmsMethod(this.getMethod("SmsMethod", data));
        builder.setSmsFallbackUrl(this.getUrl("SmsFallbackUrl", data));
        builder.setSmsFallbackMethod(this.getMethod("SmsFallbackMethod", data));
        builder.setSmsApplicationSid(this.getSid("SmsApplicationSid", data));
        Configuration configuration = this.configuration.subset("runtime-settings");
        String rootUri = configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(apiVersion).append("/Accounts/").append(accountSid.toString()).append("/IncomingPhoneNumbers/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        return builder.build();
    }

    private String e164(String number) throws NumberParseException {
        Phonenumber.PhoneNumber result;
        PhoneNumberUtil numbersUtil = PhoneNumberUtil.getInstance();
        if (!number.startsWith("+")) {
            number = "+" + number;
        }
        if (numbersUtil.isValidNumber(result = numbersUtil.parse(number, "US"))) {
            return numbersUtil.format(result, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "This is not a valid number");
    }

    private String getFriendlyName(String phoneNumber, MultivaluedMap<String, String> data) {
        String friendlyName = phoneNumber;
        if (data.containsKey((Object)"FriendlyName")) {
            friendlyName = (String)data.getFirst((Object)"FriendlyName");
        }
        return friendlyName;
    }

    protected Response getIncomingPhoneNumber(String accountSid, String sid, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:IncomingPhoneNumbers");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        IncomingPhoneNumber incomingPhoneNumber = this.dao.getIncomingPhoneNumber(new Sid(sid));
        if (incomingPhoneNumber == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)incomingPhoneNumber), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)incomingPhoneNumber);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getAvailableCountries(String accountSid, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:IncomingPhoneNumbers");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<String> countries = this.phoneNumberProvisioningManager.getAvailableCountries();
        if (countries == null) {
            countries = new ArrayList<String>();
            countries.add("US");
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson(countries), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new AvailableCountriesList(countries));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getIncomingPhoneNumbers(String accountSid, String phoneNumberFilter, String friendlyNameFilter, PhoneNumberType phoneNumberType, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:IncomingPhoneNumbers");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        IncomingPhoneNumberFilter incomingPhoneNumberFilter = new IncomingPhoneNumberFilter(accountSid, friendlyNameFilter, phoneNumberFilter);
        List incomingPhoneNumbers = this.dao.getIncomingPhoneNumbersByFilter(incomingPhoneNumberFilter);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)incomingPhoneNumbers), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new IncomingPhoneNumberList(incomingPhoneNumbers));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response putIncomingPhoneNumber(String accountSid, MultivaluedMap<String, String> data, PhoneNumberType phoneNumberType, MediaType responseType) {
        IncomingPhoneNumber incomingPhoneNumber;
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Create:IncomingPhoneNumbers");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.validate(data);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        String number = (String)data.getFirst((Object)"PhoneNumber");
        String isSIP = (String)data.getFirst((Object)"isSIP");
        if (isSIP == null) {
            try {
                number = this.e164(number);
            }
            catch (NumberParseException e) {
                // empty catch block
            }
        }
        if ((incomingPhoneNumber = this.dao.getIncomingPhoneNumber(number)) == null) {
            incomingPhoneNumber = this.createFrom(new Sid(accountSid), data);
            this.phoneNumberParameters.setPhoneNumberType(phoneNumberType);
            PhoneNumber phoneNumber = this.convertIncomingPhoneNumbertoPhoneNumber(incomingPhoneNumber);
            boolean hasSuceeded = false;
            if (this.phoneNumberProvisioningManager != null && isSIP == null) {
                hasSuceeded = this.phoneNumberProvisioningManager.buyNumber(phoneNumber, this.phoneNumberParameters);
            } else if (isSIP != null) {
                hasSuceeded = true;
            }
            if (hasSuceeded) {
                if (phoneNumber.getFriendlyName() != null) {
                    incomingPhoneNumber.setFriendlyName(phoneNumber.getFriendlyName());
                }
                if (phoneNumber.getPhoneNumber() != null) {
                    incomingPhoneNumber.setPhoneNumber(phoneNumber.getPhoneNumber());
                }
                this.dao.addIncomingPhoneNumber(incomingPhoneNumber);
                if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                    return Response.ok((Object)this.gson.toJson((Object)incomingPhoneNumber), (String)"application/json").build();
                }
                if (MediaType.APPLICATION_XML_TYPE == responseType) {
                    RestCommResponse response = new RestCommResponse((Object)incomingPhoneNumber);
                    return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
                }
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"21452").build();
    }

    public Response updateIncomingPhoneNumber(String accountSid, String sid, MultivaluedMap<String, String> data, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Modify:IncomingPhoneNumbers");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        IncomingPhoneNumber incomingPhoneNumber = this.dao.getIncomingPhoneNumber(new Sid(sid));
        boolean updated = true;
        if (!(this.phoneNumberProvisioningManager == null || incomingPhoneNumber.isPureSip() != null && incomingPhoneNumber.isPureSip().booleanValue())) {
            updated = this.phoneNumberProvisioningManager.updateNumber(this.convertIncomingPhoneNumbertoPhoneNumber(incomingPhoneNumber), this.phoneNumberParameters);
        }
        if (updated) {
            this.dao.updateIncomingPhoneNumber(this.update(incomingPhoneNumber, data));
            if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                return Response.ok((Object)this.gson.toJson((Object)incomingPhoneNumber), (String)"application/json").build();
            }
            if (MediaType.APPLICATION_XML_TYPE == responseType) {
                RestCommResponse response = new RestCommResponse((Object)incomingPhoneNumber);
                return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
            }
            return null;
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"21452").build();
    }

    private void validate(MultivaluedMap<String, String> data) throws RuntimeException {
        if (!data.containsKey((Object)"PhoneNumber") && !data.containsKey((Object)"AreaCode")) {
            throw new NullPointerException("Phone number can not be null.");
        }
    }

    private IncomingPhoneNumber update(IncomingPhoneNumber incomingPhoneNumber, MultivaluedMap<String, String> data) {
        if (data.containsKey((Object)"ApiVersion")) {
            incomingPhoneNumber.setApiVersion(this.getApiVersion(data));
        }
        if (data.containsKey((Object)"FriendlyName")) {
            incomingPhoneNumber.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        }
        if (data.containsKey((Object)"VoiceUrl")) {
            incomingPhoneNumber.setVoiceUrl(this.getUrl("VoiceUrl", data));
        }
        if (data.containsKey((Object)"VoiceMethod")) {
            incomingPhoneNumber.setVoiceMethod(this.getMethod("VoiceMethod", data));
        }
        if (data.containsKey((Object)"VoiceFallbackUrl")) {
            incomingPhoneNumber.setVoiceFallbackUrl(this.getUrl("VoiceFallbackUrl", data));
        }
        if (data.containsKey((Object)"VoiceFallbackMethod")) {
            incomingPhoneNumber.setVoiceFallbackMethod(this.getMethod("VoiceFallbackMethod", data));
        }
        if (data.containsKey((Object)"StatusCallback")) {
            incomingPhoneNumber.setStatusCallback(this.getUrl("StatusCallback", data));
        }
        if (data.containsKey((Object)"StatusCallbackMethod")) {
            incomingPhoneNumber.setStatusCallbackMethod(this.getMethod("StatusCallbackMethod", data));
        }
        if (data.containsKey((Object)"VoiceCallerIdLookup")) {
            incomingPhoneNumber.setHasVoiceCallerIdLookup(Boolean.valueOf(this.getHasVoiceCallerIdLookup(data)));
        }
        if (data.containsKey((Object)"VoiceApplicationSid")) {
            incomingPhoneNumber.setVoiceApplicationSid(this.getSid("VoiceApplicationSid", data));
        }
        if (data.containsKey((Object)"SmsUrl")) {
            incomingPhoneNumber.setSmsUrl(this.getUrl("SmsUrl", data));
        }
        if (data.containsKey((Object)"SmsMethod")) {
            incomingPhoneNumber.setSmsMethod(this.getMethod("SmsMethod", data));
        }
        if (data.containsKey((Object)"SmsFallbackUrl")) {
            incomingPhoneNumber.setSmsFallbackUrl(this.getUrl("SmsFallbackUrl", data));
        }
        if (data.containsKey((Object)"SmsFallbackMethod")) {
            incomingPhoneNumber.setSmsFallbackMethod(this.getMethod("SmsFallbackMethod", data));
        }
        if (data.containsKey((Object)"SmsApplicationSid")) {
            incomingPhoneNumber.setSmsApplicationSid(this.getSid("SmsApplicationSid", data));
        }
        if (data.containsKey((Object)"VoiceCapable")) {
            incomingPhoneNumber.setVoiceCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"VoiceCapable"))));
        }
        if (data.containsKey((Object)"SmsCapable")) {
            incomingPhoneNumber.setSmsCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"SmsCapable"))));
        }
        if (data.containsKey((Object)"MmsCapable")) {
            incomingPhoneNumber.setMmsCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"MmsCapable"))));
        }
        if (data.containsKey((Object)"FaxCapable")) {
            incomingPhoneNumber.setFaxCapable(Boolean.valueOf(Boolean.parseBoolean((String)data.getFirst((Object)"FaxCapable"))));
        }
        incomingPhoneNumber.setDateUpdated(DateTime.now());
        return incomingPhoneNumber;
    }

    public Response deleteIncomingPhoneNumber(String accountSid, String sid) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Delete:IncomingPhoneNumbers");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        IncomingPhoneNumber incomingPhoneNumber = this.dao.getIncomingPhoneNumber(new Sid(sid));
        if (!(this.phoneNumberProvisioningManager == null || incomingPhoneNumber.isPureSip() != null && incomingPhoneNumber.isPureSip().booleanValue())) {
            this.phoneNumberProvisioningManager.cancelNumber(this.convertIncomingPhoneNumbertoPhoneNumber(incomingPhoneNumber));
        }
        this.dao.removeIncomingPhoneNumber(new Sid(sid));
        return Response.noContent().build();
    }

    private List<SipURI> getOutboundInterfaces() {
        List uris = (List)this.context.getAttribute("javax.servlet.sip.outboundInterfaces");
        return uris;
    }

    protected PhoneNumber convertIncomingPhoneNumbertoPhoneNumber(IncomingPhoneNumber incomingPhoneNumber) {
        return new PhoneNumber(incomingPhoneNumber.getFriendlyName(), incomingPhoneNumber.getPhoneNumber(), null, null, null, null, null, null, null, incomingPhoneNumber.isVoiceCapable(), incomingPhoneNumber.isSmsCapable(), incomingPhoneNumber.isMmsCapable(), incomingPhoneNumber.isFaxCapable(), Boolean.valueOf(false));
    }
}

