/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.AuthorizationException;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.GatewaysEndpoint;

@Path(value="/Accounts/{accountSid}/Management/Gateways")
@ThreadSafe
public final class GatewaysXmlEndpoint
extends GatewaysEndpoint {
    private Response deleteGateway(String accountSid, String sid) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Modify:Gateways");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.dao.removeGateway(new Sid(sid));
        return Response.ok().build();
    }

    @Path(value="/{sid}.json")
    @DELETE
    public Response deleteGatewayAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteGateway(accountSid, sid);
    }

    @Path(value="/{sid}")
    @DELETE
    public Response deleteGatewayAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteGateway(accountSid, sid);
    }

    @Path(value="/{sid}.json")
    @GET
    public Response getGatewayAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getGateway(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getGatewayAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getGateway(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getGatewaysList(@PathParam(value="accountSid") String accountSid) {
        return this.getGateways(accountSid, MediaType.APPLICATION_XML_TYPE);
    }

    @POST
    public Response createGateway(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putGateway(accountSid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}.json")
    @POST
    public Response updateGatewayAsJsonPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGateway(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}.json")
    @PUT
    public Response updateGatewayAsJsonPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGateway(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @POST
    public Response updateGatewayAsXmlPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGateway(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}")
    @PUT
    public Response updateGatewayAsXmlPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGateway(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }
}

