/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.authz.AuthorizationException;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.ClientsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.entities.Client;
import org.mobicents.servlet.restcomm.entities.ClientList;
import org.mobicents.servlet.restcomm.entities.RestCommResponse;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.AbstractEndpoint;
import org.mobicents.servlet.restcomm.http.converter.ClientConverter;
import org.mobicents.servlet.restcomm.http.converter.ClientListConverter;
import org.mobicents.servlet.restcomm.http.converter.RestCommResponseConverter;
import org.mobicents.servlet.restcomm.util.StringUtils;

@NotThreadSafe
public abstract class ClientsEndpoint
extends AbstractEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected ClientsDao dao;
    protected Gson gson;
    protected XStream xstream;
    protected AccountsDao accountsDao;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.dao = storage.getClientsDao();
        this.accountsDao = storage.getAccountsDao();
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        ClientConverter converter = new ClientConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Client.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new ClientListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    private Client createFrom(Sid accountSid, MultivaluedMap<String, String> data) {
        Client.Builder builder = Client.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.CLIENT);
        builder.setSid(sid);
        builder.setApiVersion(this.getApiVersion(data));
        builder.setFriendlyName(this.getFriendlyName((String)data.getFirst((Object)"Login"), data));
        builder.setAccountSid(accountSid);
        builder.setLogin((String)data.getFirst((Object)"Login"));
        builder.setPassword((String)data.getFirst((Object)"Password"));
        builder.setStatus(this.getStatus(data));
        builder.setVoiceUrl(this.getUrl("VoiceUrl", data));
        builder.setVoiceMethod(this.getMethod("VoiceMethod", data));
        builder.setVoiceFallbackUrl(this.getUrl("VoiceFallbackUrl", data));
        builder.setVoiceFallbackMethod(this.getMethod("VoiceFallbackMethod", data));
        builder.setVoiceApplicationSid(this.getSid("VoiceApplicationSid", data));
        String rootUri = this.configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(this.getApiVersion(data)).append("/Accounts/").append(accountSid.toString()).append("/Clients/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        return builder.build();
    }

    protected Response getClient(String accountSid, String sid, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Clients");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Client client = this.dao.getClient(new Sid(sid));
        if (client == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)client);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)client), (String)"application/json").build();
        }
        return null;
    }

    protected Response getClients(String accountSid, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Clients");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List clients = this.dao.getClients(new Sid(accountSid));
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new ClientList(clients));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)clients), (String)"application/json").build();
        }
        return null;
    }

    private String getFriendlyName(String login, MultivaluedMap<String, String> data) {
        String friendlyName = login;
        if (data.containsKey((Object)"FriendlyName")) {
            friendlyName = (String)data.getFirst((Object)"FriendlyName");
        }
        return friendlyName;
    }

    private int getStatus(MultivaluedMap<String, String> data) {
        int status = 1;
        if (data.containsKey((Object)"Status")) {
            try {
                status = Integer.parseInt((String)data.getFirst((Object)"Status"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return status;
    }

    public Response putClient(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Create:Clients");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.validate(data);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        Client client = this.dao.getClient((String)data.getFirst((Object)"Login"));
        if (client == null) {
            client = this.createFrom(new Sid(accountSid), data);
            this.dao.addClient(client);
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)client);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)client), (String)"application/json").build();
        }
        return null;
    }

    protected Response updateClient(String accountSid, String sid, MultivaluedMap<String, String> data, MediaType responseType) {
        try {
            this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Modify:Clients");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Client client = this.dao.getClient(new Sid(sid));
        if (client == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.dao.updateClient(this.update(client, data));
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)client);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)client), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) throws RuntimeException {
        if (!data.containsKey((Object)"Login")) {
            throw new NullPointerException("Login can not be null.");
        }
        if (!data.containsKey((Object)"Password")) {
            throw new NullPointerException("Password can not be null.");
        }
    }

    private Client update(Client client, MultivaluedMap<String, String> data) {
        Client result = client;
        if (data.containsKey((Object)"FriendlyName")) {
            result = result.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        }
        if (data.containsKey((Object)"Password")) {
            result = result.setPassword((String)data.getFirst((Object)"Password"));
        }
        if (data.containsKey((Object)"Status")) {
            result = result.setStatus(this.getStatus(data));
        }
        if (data.containsKey((Object)"VoiceUrl")) {
            result = result.setVoiceUrl(this.getUrl("VoiceUrl", data));
        }
        if (data.containsKey((Object)"VoiceMethod")) {
            result = result.setVoiceMethod(this.getMethod("VoiceMethod", data));
        }
        if (data.containsKey((Object)"VoiceFallbackUrl")) {
            result = result.setVoiceFallbackUrl(this.getUrl("VoiceFallbackUrl", data));
        }
        if (data.containsKey((Object)"VoiceFallbackMethod")) {
            result = result.setVoiceFallbackMethod(this.getMethod("VoiceFallbackMethod", data));
        }
        if (data.containsKey((Object)"VoiceApplicationSid")) {
            result = result.setVoiceApplicationSid(this.getSid("VoiceApplicationSid", data));
        }
        return result;
    }
}

