/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.authz.AuthorizationException;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.dao.CallDetailRecordsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.entities.CallDetailRecord;
import org.mobicents.servlet.restcomm.entities.CallDetailRecordFilter;
import org.mobicents.servlet.restcomm.entities.CallDetailRecordList;
import org.mobicents.servlet.restcomm.entities.RestCommResponse;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.AbstractEndpoint;
import org.mobicents.servlet.restcomm.http.converter.CallDetailRecordConverter;
import org.mobicents.servlet.restcomm.http.converter.CallDetailRecordListConverter;
import org.mobicents.servlet.restcomm.http.converter.RestCommResponseConverter;
import org.mobicents.servlet.restcomm.telephony.CallInfo;
import org.mobicents.servlet.restcomm.telephony.CallManagerResponse;
import org.mobicents.servlet.restcomm.telephony.CallResponse;
import org.mobicents.servlet.restcomm.telephony.CreateCall;
import org.mobicents.servlet.restcomm.telephony.ExecuteCallScript;
import org.mobicents.servlet.restcomm.telephony.GetCall;
import org.mobicents.servlet.restcomm.telephony.GetCallInfo;
import org.mobicents.servlet.restcomm.telephony.Hangup;
import org.mobicents.servlet.restcomm.telephony.UpdateCallScript;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

@NotThreadSafe
public abstract class CallsEndpoint
extends AbstractEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    private ActorRef callManager;
    private DaoManager daos;
    private Gson gson;
    private GsonBuilder builder;
    private XStream xstream;
    private CallDetailRecordListConverter listConverter;
    private boolean normalizePhoneNumbers;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.callManager = (ActorRef)this.context.getAttribute("org.mobicents.servlet.restcomm.telephony.CallManager");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        super.init(this.configuration);
        CallDetailRecordConverter converter = new CallDetailRecordConverter(this.configuration);
        this.listConverter = new CallDetailRecordListConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(CallDetailRecord.class, (Object)converter);
        this.builder.registerTypeAdapter(CallDetailRecordList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.normalizePhoneNumbers = this.configuration.getBoolean("normalize-numbers-for-outbound-calls");
    }

    protected Response getCall(String accountSid, String sid, MediaType responseType) {
        try {
            this.secure(this.daos.getAccountsDao().getAccount(accountSid), "RestComm:Read:Calls");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        CallDetailRecord cdr = dao.getCallDetailRecord(new Sid(sid));
        if (cdr == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)cdr);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
        }
        return null;
    }

    protected Response getCalls(String accountSid, UriInfo info, MediaType responseType) {
        try {
            this.secure(this.daos.getAccountsDao().getAccount(accountSid), "RestComm:Read:Calls");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String recipient = (String)info.getQueryParameters().getFirst((Object)"To");
        String sender = (String)info.getQueryParameters().getFirst((Object)"From");
        String status = (String)info.getQueryParameters().getFirst((Object)"Status");
        String startTime = (String)info.getQueryParameters().getFirst((Object)"StartTime");
        String parentCallSid = (String)info.getQueryParameters().getFirst((Object)"ParentCallSid");
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        int limit = Integer.parseInt(pageSize);
        int offset = page == "0" ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        CallDetailRecordFilter filterForTotal = new CallDetailRecordFilter(accountSid, recipient, sender, status, startTime, parentCallSid, null, null);
        int total = dao.getTotalCallDetailRecords(filterForTotal);
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        CallDetailRecordFilter filter = new CallDetailRecordFilter(accountSid, recipient, sender, status, startTime, parentCallSid, Integer.valueOf(limit), Integer.valueOf(offset));
        List cdrs = dao.getCallDetailRecords(filter);
        this.listConverter.setCount(total);
        this.listConverter.setPage(Integer.parseInt(page));
        this.listConverter.setPageSize(Integer.parseInt(pageSize));
        this.listConverter.setPathUri(info.getRequestUri().getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new CallDetailRecordList(cdrs));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new CallDetailRecordList(cdrs)), (String)"application/json").build();
        }
        return null;
    }

    private void normalize(MultivaluedMap<String, String> data) throws IllegalArgumentException {
        String to;
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        String from = (String)data.getFirst((Object)"From");
        if (!from.contains("@")) {
            data.remove((Object)"From");
            try {
                data.putSingle((Object)"From", (Object)phoneNumberUtil.format(phoneNumberUtil.parse(from, "US"), PhoneNumberUtil.PhoneNumberFormat.E164));
            }
            catch (NumberParseException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        if ((to = (String)data.getFirst((Object)"To")).startsWith("client")) {
            if (to.split(":").length != 2) {
                throw new IllegalArgumentException(to + " is an invalid client identifier.");
            }
        } else if (!to.contains("@")) {
            data.remove((Object)"To");
            try {
                data.putSingle((Object)"To", (Object)phoneNumberUtil.format(phoneNumberUtil.parse(to, "US"), PhoneNumberUtil.PhoneNumberFormat.E164));
            }
            catch (NumberParseException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        URI.create((String)data.getFirst((Object)"Url"));
    }

    protected Response putCall(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        Sid accountId = new Sid(accountSid);
        try {
            this.secure(this.daos.getAccountsDao().getAccount(accountSid), "RestComm:Create:Calls");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.validate(data);
            if (this.normalizePhoneNumbers) {
                this.normalize(data);
            }
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        String from = (String)data.getFirst((Object)"From");
        String to = (String)data.getFirst((Object)"To");
        String username = (String)data.getFirst((Object)"Username");
        String password = (String)data.getFirst((Object)"Password");
        Integer timeout = this.getTimeout(data);
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        CreateCall create = null;
        try {
            Future future;
            Object object;
            Class<?> klass;
            create = to.contains("@") ? new CreateCall(from, to, username, password, true, timeout != null ? timeout : 30, CreateCall.Type.SIP, accountId) : (to.startsWith("client") ? new CreateCall(from, to, username, password, true, timeout != null ? timeout : 30, CreateCall.Type.CLIENT, accountId) : new CreateCall(from, to, username, password, true, timeout != null ? timeout : 30, CreateCall.Type.PSTN, accountId));
            create.setCreateCDR(false);
            if (this.callManager == null) {
                this.callManager = (ActorRef)this.context.getAttribute("org.mobicents.servlet.restcomm.telephony.CallManager");
            }
            if (CallManagerResponse.class.equals(klass = (object = Await.result((Awaitable)(future = Patterns.ask((ActorRef)this.callManager, (Object)create, (Timeout)expires)), (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS))).getClass())) {
                CallManagerResponse managerResponse = (CallManagerResponse)object;
                if (managerResponse.succeeded()) {
                    CallResponse callResponse;
                    ActorRef call = (ActorRef)managerResponse.get();
                    future = Patterns.ask((ActorRef)call, (Object)new GetCallInfo(), (Timeout)expires);
                    object = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
                    klass = object.getClass();
                    if (CallResponse.class.equals(klass) && (callResponse = (CallResponse)object).succeeded()) {
                        CallInfo callInfo = (CallInfo)callResponse.get();
                        String version = this.getApiVersion(data);
                        URI url = this.getUrl("Url", data);
                        String method = this.getMethod("Method", data);
                        URI fallbackUrl = this.getUrl("FallbackUrl", data);
                        String fallbackMethod = this.getMethod("FallbackMethod", data);
                        URI callback = this.getUrl("StatusCallback", data);
                        String callbackMethod = this.getMethod("StatusCallbackMethod", data);
                        ExecuteCallScript execute = new ExecuteCallScript(call, accountId, version, url, method, fallbackUrl, fallbackMethod, callback, callbackMethod);
                        this.callManager.tell((Object)execute, null);
                        CallDetailRecord cdr = this.daos.getCallDetailRecordsDao().getCallDetailRecord(callInfo.sid());
                        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
                            return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
                        }
                        if (MediaType.APPLICATION_XML_TYPE == responseType) {
                            return Response.ok((Object)this.xstream.toXML((Object)new RestCommResponse((Object)cdr)), (String)"application/xml").build();
                        }
                        return null;
                    }
                } else {
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(managerResponse.cause() + " : " + managerResponse.error())).build();
                }
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
    }

    protected Response updateCall(String sid, String callSid, MultivaluedMap<String, String> data, MediaType responseType) {
        CallInfo callInfo;
        ActorRef call;
        Sid accountSid = new Sid(sid);
        try {
            this.secure(this.daos.getAccountsDao().getAccount(accountSid), "RestComm:Modify:Calls");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        CallDetailRecordsDao dao = this.daos.getCallDetailRecordsDao();
        CallDetailRecord cdr = dao.getCallDetailRecord(new Sid(callSid));
        String url = (String)data.getFirst((Object)"Url");
        String method = (String)data.getFirst((Object)"Method");
        String status = (String)data.getFirst((Object)"Status");
        String fallBackUrl = (String)data.getFirst((Object)"FallbackUrl");
        String fallBackMethod = (String)data.getFirst((Object)"FallbackMethod");
        String statusCallBack = (String)data.getFirst((Object)"StatusCallback");
        String statusCallbackMethod = (String)data.getFirst((Object)"StatusCallbackMethod");
        Boolean moveConnectedCallLeg = Boolean.valueOf((String)data.getFirst((Object)"MoveConnectedCallLeg"));
        String callPath = null;
        try {
            callPath = cdr.getCallPath();
            Future future = Patterns.ask((ActorRef)this.callManager, (Object)new GetCall(callPath), (Timeout)expires);
            call = (ActorRef)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
            future = Patterns.ask((ActorRef)call, (Object)new GetCallInfo(), (Timeout)expires);
            CallResponse response = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
            callInfo = (CallInfo)response.get();
        }
        catch (Exception exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
        if (method == null) {
            method = "POST";
        }
        if (url != null && status != null) {
            String errorMessage = "You can either redirect a running call using \"Url\" or change the state of a Call with \"Status\"";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"You can either redirect a running call using \"Url\" or change the state of a Call with \"Status\"").build();
        }
        if (status != null) {
            if (status.equalsIgnoreCase("canceled") && (callInfo.state().name().equalsIgnoreCase("queued") || callInfo.state().name().equalsIgnoreCase("ringing")) && call != null) {
                call.tell((Object)new Hangup(), null);
            }
            if (status.equalsIgnoreCase("completed") && call != null) {
                call.tell((Object)new Hangup(), null);
            }
        }
        if (url != null && call != null) {
            try {
                String version = this.getApiVersion(data);
                URI uri = new URL(url).toURI();
                URI fallbackUri = fallBackUrl != null ? new URL(fallBackUrl).toURI() : null;
                fallBackMethod = fallBackMethod == null ? "POST" : fallBackMethod;
                URI callbackUri = statusCallBack != null ? new URL(statusCallBack).toURI() : null;
                statusCallbackMethod = statusCallbackMethod == null ? "POST" : statusCallbackMethod;
                UpdateCallScript update = new UpdateCallScript(call, accountSid, version, uri, method, fallbackUri, fallBackMethod, callbackUri, statusCallbackMethod, moveConnectedCallLeg);
                this.callManager.tell((Object)update, null);
            }
            catch (Exception exception) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
            }
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)cdr), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            return Response.ok((Object)this.xstream.toXML((Object)new RestCommResponse((Object)cdr)), (String)"application/xml").build();
        }
        return null;
    }

    private Integer getTimeout(MultivaluedMap<String, String> data) {
        Integer result = 60;
        if (data.containsKey((Object)"Timeout")) {
            result = Integer.parseInt((String)data.getFirst((Object)"Timeout"));
        }
        return result;
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"From")) {
            throw new NullPointerException("From can not be null.");
        }
        if (!data.containsKey((Object)"To")) {
            throw new NullPointerException("To can not be null.");
        }
        if (!data.containsKey((Object)"Url")) {
            throw new NullPointerException("Url can not be null.");
        }
    }
}

