/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.log4j.Logger;
import org.apache.shiro.authz.AuthorizationException;
import org.mobicents.servlet.restcomm.cache.DiskCache;
import org.mobicents.servlet.restcomm.cache.DiskCacheRequest;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.entities.Announcement;
import org.mobicents.servlet.restcomm.entities.RestCommResponse;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.AbstractEndpoint;
import org.mobicents.servlet.restcomm.http.converter.AnnouncementConverter;
import org.mobicents.servlet.restcomm.http.converter.AnnouncementListConverter;
import org.mobicents.servlet.restcomm.http.converter.RestCommResponseConverter;
import org.mobicents.servlet.restcomm.tts.api.SpeechSynthesizerRequest;
import org.mobicents.servlet.restcomm.tts.api.SpeechSynthesizerResponse;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

@NotThreadSafe
public abstract class AnnouncementsEndpoint
extends AbstractEndpoint {
    private static Logger logger = Logger.getLogger(AnnouncementsEndpoint.class);
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected Configuration runtime;
    protected ActorSystem system;
    protected ActorRef synthesizer;
    protected ActorRef cache;
    protected Gson gson;
    protected XStream xstream;
    protected AccountsDao dao;
    private URI uri;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.dao = storage.getAccountsDao();
        this.system = (ActorSystem)this.context.getAttribute(ActorSystem.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        Configuration ttsConfiguration = this.configuration.subset("speech-synthesizer");
        this.runtime = this.configuration.subset("runtime-settings");
        this.synthesizer = this.tts(ttsConfiguration);
        super.init(this.runtime);
        AnnouncementConverter converter = new AnnouncementConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Announcement.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new AnnouncementListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    public Response putAnnouncement(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) throws Exception {
        try {
            this.secure(this.dao.getAccount(accountSid), "RestComm:Create:Announcements");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.cache == null) {
            this.createCacheActor(accountSid);
        }
        Announcement announcement = this.createFrom(accountSid, data);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)announcement), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)announcement);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    private void createCacheActor(String accountId) {
        String path = this.runtime.getString("cache-path");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + accountId.toString();
        String uri = this.runtime.getString("cache-uri");
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + accountId.toString();
        this.cache = this.cache(path, uri);
    }

    private void precache(String text, String gender, String language) throws Exception {
        logger.info((Object)"Synthesizing announcement");
        SpeechSynthesizerRequest synthesize = new SpeechSynthesizerRequest(gender, language, text);
        Timeout expires = new Timeout(Duration.create((long)6000L, (TimeUnit)TimeUnit.SECONDS));
        Future future = Patterns.ask((ActorRef)this.synthesizer, (Object)synthesize, (Timeout)expires);
        Object object = Await.result((Awaitable)future, (Duration)Duration.create((long)6000L, (TimeUnit)TimeUnit.SECONDS));
        if (object != null) {
            SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)object;
            this.uri = (URI)response.get();
        }
        DiskCacheRequest request = new DiskCacheRequest(this.uri);
        logger.info((Object)"Caching announcement");
        this.cache.tell((Object)request, null);
    }

    private Announcement createFrom(String accountSid, MultivaluedMap<String, String> data) throws Exception {
        String text;
        String language;
        Sid sid = Sid.generate((Sid.Type)Sid.Type.ANNOUNCEMENT);
        String gender = (String)data.getFirst((Object)"Gender");
        if (gender == null) {
            gender = "man";
        }
        if ((language = (String)data.getFirst((Object)"Language")) == null) {
            language = "en";
        }
        if ((text = (String)data.getFirst((Object)"Text")) != null) {
            this.precache(text, gender, language);
        }
        logger.info((Object)"Creating annnouncement");
        Announcement announcement = new Announcement(sid, new Sid(accountSid), gender, language, text, this.uri);
        return announcement;
    }

    private ActorRef tts(final Configuration configuration) {
        final String classpath = configuration.getString("[@class]");
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return (UntypedActor)Class.forName(classpath).getConstructor(Configuration.class).newInstance(configuration);
            }
        }));
    }

    private ActorRef cache(final String path, final String uri) {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return new DiskCache(path, uri, true);
            }
        }));
    }

    @PreDestroy
    private void cleanup() {
        logger.info((Object)"Stopping actors before endpoint destroy");
        this.system.stop(this.cache);
        this.system.stop(this.synthesizer);
    }
}

