/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.apache.shiro.subject.Subject;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.entities.Account;
import org.mobicents.servlet.restcomm.entities.AccountList;
import org.mobicents.servlet.restcomm.entities.RestCommResponse;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.http.AbstractEndpoint;
import org.mobicents.servlet.restcomm.http.converter.AccountConverter;
import org.mobicents.servlet.restcomm.http.converter.AccountListConverter;
import org.mobicents.servlet.restcomm.http.converter.RestCommResponseConverter;
import org.mobicents.servlet.restcomm.util.StringUtils;

public abstract class AccountsEndpoint
extends AbstractEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected AccountsDao dao;
    protected Gson gson;
    protected XStream xstream;

    @PostConstruct
    private void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        this.dao = storage.getAccountsDao();
        AccountConverter converter = new AccountConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Account.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new AccountListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    private Account createFrom(Sid accountSid, MultivaluedMap<String, String> data) {
        this.validate(data);
        DateTime now = DateTime.now();
        String emailAddress = (String)data.getFirst((Object)"EmailAddress");
        Sid sid = Sid.generate((Sid.Type)Sid.Type.ACCOUNT, (String)emailAddress);
        String friendlyName = emailAddress;
        if (data.containsKey((Object)"FriendlyName")) {
            friendlyName = (String)data.getFirst((Object)"FriendlyName");
        }
        Account.Type type = Account.Type.FULL;
        Account.Status status = Account.Status.ACTIVE;
        if (data.containsKey((Object)"Status")) {
            status = Account.Status.valueOf((String)((String)data.getFirst((Object)"Status")));
        }
        String password = (String)data.getFirst((Object)"Password");
        String authToken = new Md5Hash((Object)password).toString();
        String role = (String)data.getFirst((Object)"Role");
        String rootUri = this.configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(this.getApiVersion(null)).append("/Accounts/").append(sid.toString());
        URI uri = URI.create(buffer.toString());
        return new Account(sid, now, now, emailAddress, friendlyName, accountSid, type, status, authToken, role, uri);
    }

    protected Response getAccount(String accountSid, MediaType responseType) {
        Sid sid = null;
        Account account = null;
        if (Sid.pattern.matcher(accountSid).matches()) {
            try {
                sid = new Sid(accountSid);
                account = this.dao.getAccount(sid);
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        try {
            account = this.dao.getAccount(accountSid);
            sid = account.getSid();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            Subject subject = SecurityUtils.getSubject();
            if (!(subject.hasRole("Administrator") || subject.getPrincipal().equals(accountSid) && subject.isPermitted("RestComm:Modify:Accounts"))) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)account);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)account), (String)"application/json").build();
        }
        return null;
    }

    protected Response deleteAccount(String sid) {
        Subject subject = SecurityUtils.getSubject();
        Sid accountSid = new Sid((String)subject.getPrincipal());
        Sid sidToBeRemoved = new Sid(sid);
        try {
            Account account = this.dao.getAccount(sidToBeRemoved);
            this.secure(account, "RestComm:Delete:Accounts");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (sid.equalsIgnoreCase(accountSid.toString())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (this.dao.getAccount(sidToBeRemoved) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.dao.removeAccount(sidToBeRemoved);
        return Response.ok().build();
    }

    protected Response getAccounts(MediaType responseType) {
        Account account;
        Subject subject = SecurityUtils.getSubject();
        Sid sid = new Sid((String)subject.getPrincipal());
        try {
            account = this.dao.getAccount(sid);
            this.secure(account, "RestComm:Read:Accounts");
        }
        catch (AuthorizationException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        account = this.dao.getAccount(sid);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ArrayList<Account> accounts = new ArrayList<Account>();
        accounts.add(account);
        accounts.addAll(this.dao.getAccounts(sid));
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new AccountList(accounts));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson(accounts), (String)"application/json").build();
        }
        return null;
    }

    protected Response putAccount(MultivaluedMap<String, String> data, MediaType responseType) {
        Subject subject = SecurityUtils.getSubject();
        Sid sid = new Sid((String)subject.getPrincipal());
        Account account = null;
        try {
            account = this.createFrom(sid, data);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        if (this.dao.getAccount(account.getSid()) == null) {
            Account parent = this.dao.getAccount(sid);
            if (parent.getStatus().equals((Object)Account.Status.ACTIVE) && (subject.hasRole("Administrator") || subject.isPermitted("RestComm:Create:Accounts"))) {
                if (!subject.hasRole("Administrator") || !data.containsKey((Object)"Role")) {
                    account = account.setRole(parent.getRole());
                }
                this.dao.addAccount(account);
            } else {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)account), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)account);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    private Account update(Account account, MultivaluedMap<String, String> data) {
        Account result = account;
        if (data.containsKey((Object)"FriendlyName")) {
            result = result.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        }
        result = data.containsKey((Object)"Status") ? result.setStatus(Account.Status.getValueOf((String)((String)data.getFirst((Object)"Status")))) : result.setStatus(Account.Status.ACTIVE);
        if (data.containsKey((Object)"Password")) {
            String hash = new Md5Hash(data.getFirst((Object)"Password")).toString();
            result = result.setAuthToken(hash);
        }
        if (data.containsKey((Object)"Auth_Token")) {
            result = result.setAuthToken((String)data.getFirst((Object)"Auth_Token"));
        }
        return result;
    }

    protected Response updateAccount(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        Sid sid = new Sid(accountSid);
        Account account = this.dao.getAccount(sid);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        account = this.update(account, data);
        Subject subject = SecurityUtils.getSubject();
        if (!(subject.hasRole("Administrator") || subject.getPrincipal().equals(accountSid) && subject.isPermitted("RestComm:Modify:Accounts"))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.dao.updateAccount(account);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)account), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)account);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"EmailAddress")) {
            throw new NullPointerException("Email address can not be null.");
        }
        if (!data.containsKey((Object)"Password")) {
            throw new NullPointerException("Password can not be null.");
        }
    }
}

