/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.PathHelper;

public class UriBuilderImpl
extends UriBuilder {
    private String host;
    private String scheme;
    private int port = -1;
    private String userInfo;
    private String path;
    private String query;
    private String fragment;
    private String ssp;
    private static final Pattern uriPattern = Pattern.compile("([a-zA-Z0-9+.-]+)://([^/:]+)(:(\\d+))?(/[^?]*)?(\\?([^#]+))?(#(.*))?");
    private static final Pattern sspPattern = Pattern.compile("([^:/]+):(.+)");
    private static final Pattern pathPattern = Pattern.compile("([^?]*)?(\\?([^#]+))?(#(.*))?");
    private static final Pattern PARAM_REPLACEMENT = Pattern.compile("_resteasy_uri_parameter");

    public UriBuilder clone() {
        UriBuilderImpl impl = new UriBuilderImpl();
        impl.host = this.host;
        impl.scheme = this.scheme;
        impl.port = this.port;
        impl.userInfo = this.userInfo;
        impl.path = this.path;
        impl.query = this.query;
        impl.fragment = this.fragment;
        impl.ssp = this.ssp;
        return impl;
    }

    public static UriBuilder fromTemplate(String uriTemplate) {
        UriBuilderImpl impl = new UriBuilderImpl();
        impl.uriTemplate(uriTemplate);
        return impl;
    }

    public UriBuilder uriTemplate(String uriTemplate) {
        Matcher match = uriPattern.matcher(uriTemplate);
        if (match.matches()) {
            int at;
            this.scheme(match.group(1));
            String host = match.group(2);
            if (host != null && (at = host.indexOf(64)) > -1) {
                String user = host.substring(0, at);
                host = host.substring(at + 1);
                this.userInfo(user);
            }
            this.host(host);
            if (match.group(4) != null) {
                this.port(Integer.valueOf(match.group(4)));
            }
            if (match.group(5) != null) {
                this.path(match.group(5));
            }
            if (match.group(7) != null) {
                this.replaceQuery(match.group(7));
            }
            if (match.group(9) != null) {
                this.fragment(match.group(9));
            }
            return this;
        }
        match = sspPattern.matcher(uriTemplate);
        if (match.matches()) {
            this.scheme(match.group(1));
            this.schemeSpecificPart(match.group(2));
            return this;
        }
        match = pathPattern.matcher(uriTemplate);
        if (match.matches()) {
            if (match.group(1) != null) {
                this.path(match.group(1));
            }
            if (match.group(3) != null) {
                this.replaceQuery(match.group(3));
            }
            if (match.group(5) != null) {
                this.fragment(match.group(5));
            }
            return this;
        }
        throw new RuntimeException("Illegal uri template: " + uriTemplate);
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("URI was null");
        }
        if (uri.getScheme() != null) {
            this.scheme = uri.getScheme();
        }
        if (uri.getRawSchemeSpecificPart() != null && uri.getRawPath() == null) {
            this.ssp = uri.getRawSchemeSpecificPart();
        } else {
            this.ssp = null;
            if (uri.getHost() != null) {
                this.host = uri.getHost();
            }
            if (uri.getPort() != -1) {
                this.port = uri.getPort();
            }
            if (uri.getUserInfo() != null) {
                this.userInfo = uri.getRawUserInfo();
            }
            if (uri.getPath() != null && !uri.getPath().equals("")) {
                this.path = uri.getRawPath();
            }
            if (uri.getQuery() != null) {
                this.query = uri.getRawQuery();
            }
            if (uri.getFragment() != null) {
                this.fragment = uri.getRawFragment();
            }
        }
        return this;
    }

    public UriBuilder scheme(String scheme) throws IllegalArgumentException {
        this.scheme = scheme;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        URI uri;
        if (ssp == null) {
            throw new IllegalArgumentException("schemeSpecificPart was null");
        }
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (ssp != null) {
            sb.append(ssp);
        }
        if (this.fragment != null && this.fragment.length() > 0) {
            sb.append('#').append(this.fragment);
        }
        if ((uri = URI.create(sb.toString())).getRawSchemeSpecificPart() != null && uri.getRawPath() == null) {
            this.ssp = uri.getRawSchemeSpecificPart();
        } else {
            this.ssp = null;
            this.userInfo = uri.getRawUserInfo();
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.path = uri.getRawPath();
            this.query = uri.getRawQuery();
        }
        return this;
    }

    public UriBuilder userInfo(String ui) {
        this.userInfo = ui;
        return this;
    }

    public UriBuilder host(String host) throws IllegalArgumentException {
        if (host == null) {
            throw new IllegalArgumentException("schemeSpecificPart was null");
        }
        if (host.equals("")) {
            throw new IllegalArgumentException("invalid host");
        }
        this.host = host;
        return this;
    }

    public UriBuilder port(int port) throws IllegalArgumentException {
        if (port < -1) {
            throw new IllegalArgumentException("Invalid port value");
        }
        this.port = port;
        return this;
    }

    protected static String paths(boolean encode, String basePath, String ... segments) {
        String path = basePath;
        if (path == null) {
            path = "";
        }
        for (String segment : segments) {
            if ("".equals(segment)) continue;
            if (path.endsWith("/")) {
                if (segment.startsWith("/") && "".equals(segment = segment.substring(1))) continue;
                if (encode) {
                    segment = Encode.encodePath(segment);
                }
                path = path + segment;
                continue;
            }
            if (encode) {
                segment = Encode.encodePath(segment);
            }
            path = "".equals(path) ? segment : (segment.startsWith("/") ? path + segment : path + "/" + segment);
        }
        return path;
    }

    public UriBuilder path(String segment) throws IllegalArgumentException {
        if (segment == null) {
            throw new IllegalArgumentException("path was null");
        }
        this.path = UriBuilderImpl.paths(true, this.path, segment);
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("path was null");
        }
        Path ann = resource.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("Class must be annotated with @Path to invoke path(Class)");
        }
        String[] segments = new String[]{ann.value()};
        this.path = UriBuilderImpl.paths(true, this.path, segments);
        return this;
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource was null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method was null");
        }
        Method theMethod = null;
        for (Method m : resource.getMethods()) {
            if (!m.getName().equals(method)) continue;
            if (theMethod != null && m.isAnnotationPresent(Path.class)) {
                throw new IllegalArgumentException("there are two method named " + method);
            }
            if (!m.isAnnotationPresent(Path.class)) continue;
            theMethod = m;
        }
        return this.path(theMethod);
    }

    public UriBuilder path(Method method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("method was null");
        }
        Path ann = method.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("method is not annotated with @Path");
        }
        this.path = UriBuilderImpl.paths(true, this.path, ann.value());
        return this;
    }

    public UriBuilder replaceMatrix(String matrix) throws IllegalArgumentException {
        if (!matrix.startsWith(";")) {
            matrix = ";" + matrix;
        }
        if (this.path == null) {
            this.path = matrix;
        } else {
            int matrixIndex;
            int start = this.path.lastIndexOf(47);
            if (start < 0) {
                start = 0;
            }
            this.path = (matrixIndex = this.path.indexOf(59, start)) > -1 ? this.path.substring(0, matrixIndex) + matrix : this.path + matrix;
        }
        return this;
    }

    public UriBuilder replaceQuery(String query) throws IllegalArgumentException {
        if (query == null) {
            this.query = null;
            return this;
        }
        this.query = Encode.encodeQueryString(query);
        return this;
    }

    public UriBuilder fragment(String fragment) throws IllegalArgumentException {
        this.fragment = Encode.encodeFragment(fragment);
        return this;
    }

    public UriBuilder substitutePathParam(String name, Object value, boolean isEncoded) {
        if (this.path != null) {
            StringBuffer buffer = new StringBuffer();
            this.replacePathParameter(name, value.toString(), isEncoded, this.path, buffer);
            this.path = buffer.toString();
        }
        return this;
    }

    public URI buildFromMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromMap(values, false);
    }

    public URI buildFromEncodedMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromMap(values, true);
    }

    public URI buildFromMap(Map<String, ? extends Object> paramMap, boolean fromEncodedMap) throws IllegalArgumentException, UriBuilderException {
        StringBuffer buffer = new StringBuffer();
        if (this.scheme != null) {
            this.replaceParameter(paramMap, fromEncodedMap, this.scheme, buffer).append(":");
        }
        if (this.ssp != null) {
            buffer.append(this.ssp);
        } else if (this.userInfo != null || this.host != null || this.port != -1) {
            buffer.append("//");
            if (this.userInfo != null) {
                this.replaceParameter(paramMap, fromEncodedMap, this.userInfo, buffer).append("@");
            }
            if (this.host != null) {
                this.replaceParameter(paramMap, fromEncodedMap, this.host, buffer);
            }
            if (this.port != -1) {
                buffer.append(":").append(Integer.toString(this.port));
            }
        }
        if (this.path != null) {
            StringBuffer tmp = new StringBuffer();
            this.replaceParameter(paramMap, fromEncodedMap, this.path, tmp);
            String tmpPath = tmp.toString();
            if (!(this.userInfo == null && this.host == null || tmpPath.startsWith("/"))) {
                buffer.append("/");
            }
            buffer.append(tmpPath);
        }
        if (this.query != null) {
            buffer.append("?");
            this.replaceQueryStringParameter(paramMap, fromEncodedMap, this.query, buffer);
        }
        if (this.fragment != null) {
            buffer.append("#");
            this.replaceParameter(paramMap, fromEncodedMap, this.fragment, buffer);
        }
        String buf = buffer.toString();
        try {
            return URI.create(buf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create URI: " + buf, e);
        }
    }

    protected StringBuffer replacePathParameter(String name, String value, boolean isEncoded, String string, StringBuffer buffer) {
        Matcher matcher = UriBuilderImpl.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            if (!param.equals(name)) continue;
            value = !isEncoded ? Encode.encodePath(value) : Encode.encodeNonCodes(value);
            value = value.replace("$", "\\$");
            matcher.appendReplacement(buffer, value);
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    public static Matcher createUriParamMatcher(String string) {
        Matcher matcher = PathHelper.URI_PARAM_PATTERN.matcher(PathHelper.replaceEnclosedCurlyBraces(string));
        return matcher;
    }

    protected StringBuffer replaceParameter(Map<String, ? extends Object> paramMap, boolean fromEncodedMap, String string, StringBuffer buffer) {
        Matcher matcher = UriBuilderImpl.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            Object valObj = paramMap.get(param);
            if (valObj == null) {
                throw new IllegalArgumentException("NULL value for template parameter: " + param);
            }
            String value = valObj.toString();
            if (value != null) {
                value = !fromEncodedMap ? Encode.encodePathAsIs(value) : Encode.encodePathSaveEncodings(value);
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
                continue;
            }
            throw new IllegalArgumentException("path param " + param + " has not been provided by the parameter map");
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    protected StringBuffer replaceQueryStringParameter(Map<String, ? extends Object> paramMap, boolean fromEncodedMap, String string, StringBuffer buffer) {
        Matcher matcher = UriBuilderImpl.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            String value = paramMap.get(param).toString();
            if (value != null) {
                value = !fromEncodedMap ? Encode.encodeQueryParamAsIs(value) : Encode.encodeQueryParamSaveEncodings(value);
                matcher.appendReplacement(buffer, value);
                continue;
            }
            throw new IllegalArgumentException("path param " + param + " has not been provided by the parameter map");
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    public List<String> getPathParamNamesInDeclarationOrder() {
        ArrayList<String> params = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        if (this.scheme != null) {
            this.addToPathParamList(params, set, this.scheme);
        }
        if (this.userInfo != null) {
            this.addToPathParamList(params, set, this.userInfo);
        }
        if (this.host != null) {
            this.addToPathParamList(params, set, this.host);
        }
        if (this.path != null) {
            this.addToPathParamList(params, set, this.path);
        }
        if (this.query != null) {
            this.addToPathParamList(params, set, this.query);
        }
        if (this.fragment != null) {
            this.addToPathParamList(params, set, this.fragment);
        }
        return params;
    }

    private void addToPathParamList(List<String> params, HashSet<String> set, String string) {
        Matcher matcher = PathHelper.URI_PARAM_PATTERN.matcher(PathHelper.replaceEnclosedCurlyBraces(string));
        while (matcher.find()) {
            String param = matcher.group(1);
            if (set.contains(param)) continue;
            set.add(param);
            params.add(param);
        }
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromValues(false, values);
    }

    protected URI buildFromValues(boolean encoded, Object ... values) {
        List<String> params = this.getPathParamNamesInDeclarationOrder();
        if (values.length < params.size()) {
            throw new IllegalArgumentException("You did not supply enough values to fill path parameters");
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        for (int i = 0; i < params.size(); ++i) {
            String pathParam = params.get(i);
            Object val = values[i];
            if (val == null) {
                throw new IllegalArgumentException("A value was null");
            }
            pathParams.put(pathParam, val.toString());
        }
        return this.buildFromMap(pathParams, encoded);
    }

    public UriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (this.path == null) {
            this.path = "";
        }
        for (Object val : values) {
            this.path = this.path + ";" + Encode.encodeMatrixParam(name) + "=" + Encode.encodeMatrixParam(val.toString());
        }
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) throws IllegalArgumentException {
        int matrixIndex;
        if (this.path == null) {
            return this.matrixParam(name, values);
        }
        ArrayList<String> pathParams = new ArrayList<String>();
        boolean foundParam = false;
        Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(PathHelper.replaceEnclosedCurlyBraces(this.path));
        StringBuffer newSegment = new StringBuffer();
        while (matcher.find()) {
            foundParam = true;
            String group = matcher.group();
            pathParams.add(PathHelper.recoverEnclosedCurlyBraces(group));
            matcher.appendReplacement(newSegment, "_resteasy_uri_parameter");
        }
        matcher.appendTail(newSegment);
        this.path = newSegment.toString();
        int start = this.path.lastIndexOf(47);
        if (start < 0) {
            start = 0;
        }
        if ((matrixIndex = this.path.indexOf(59, start)) > -1) {
            String[] params;
            String matrixParams = this.path.substring(matrixIndex + 1);
            this.path = this.path.substring(0, matrixIndex);
            MultivaluedMapImpl<String, String> map = new MultivaluedMapImpl<String, String>();
            for (String param : params = matrixParams.split(";")) {
                String[] namevalue = param.split("=");
                if (namevalue == null || namevalue.length <= 0) continue;
                String theName = namevalue[0];
                String value = "";
                if (namevalue.length > 1) {
                    value = namevalue[1];
                }
                map.add(theName, value);
            }
            map.remove(name);
            for (String theName : map.keySet()) {
                List vals = (List)map.get(theName);
                for (String val : vals) {
                    this.path = this.path + ";" + theName + "=" + val.toString();
                }
            }
        }
        this.matrixParam(name, values);
        if (foundParam) {
            matcher = PARAM_REPLACEMENT.matcher(this.path);
            newSegment = new StringBuffer();
            int i = 0;
            while (matcher.find()) {
                matcher.appendReplacement(newSegment, (String)pathParams.get(i++));
            }
            matcher.appendTail(newSegment);
            this.path = newSegment.toString();
        }
        return this;
    }

    public UriBuilder clientQueryParam(String name, Object value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("A passed in value was null");
        }
        this.query = this.query == null ? "" : this.query + "&";
        this.query = this.query + Encode.encodeQueryParamAsIs(name) + "=" + Encode.encodeQueryParamAsIs(value.toString());
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException("A passed in value was null");
            }
            this.query = this.query == null ? "" : this.query + "&";
            this.query = this.query + Encode.encodeQueryParam(name) + "=" + Encode.encodeQueryParam(value.toString());
        }
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        if (this.query == null || this.query.equals("")) {
            return this.queryParam(name, values);
        }
        String[] params = this.query.split("&");
        this.query = null;
        String replacedName = Encode.encodeQueryParam(name);
        for (String param : params) {
            String paramName;
            int pos = param.indexOf(61);
            if (pos < 0 ? param.equals(replacedName) : (paramName = param.substring(0, pos)).equals(replacedName)) continue;
            this.query = this.query == null ? "" : this.query + "&";
            this.query = this.query + param;
        }
        if (values == null) {
            return this;
        }
        if (values == null) {
            return this;
        }
        return this.queryParam(name, values);
    }

    public String getHost() {
        return this.host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public UriBuilder segment(String ... segments) throws IllegalArgumentException {
        if (segments == null) {
            throw new IllegalArgumentException("segments parameter was null");
        }
        for (String segment : segments) {
            if (segment == null) {
                throw new IllegalArgumentException("A segment is null");
            }
            this.path(Encode.encodePathSegment(segment));
        }
        return this;
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromValues(true, values);
    }

    public UriBuilder replacePath(String path) {
        if (path == null) {
            this.path = null;
            return this;
        }
        this.path = Encode.encodePath(path);
        return this;
    }
}

