/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.io.IOException;
import java.net.URL;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesFactory;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;

public final class JBossWebservicesDescriptorDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        URL jbossWebservicesDescriptorURL = this.getJBossWebServicesDescriptorURL(deploymentRoot);
        if (jbossWebservicesDescriptorURL != null) {
            JBossWebservicesMetaData jbossWebservicesMD = JBossWebservicesFactory.load((URL)jbossWebservicesDescriptorURL);
            unit.putAttachment(WSAttachmentKeys.JBOSS_WEBSERVICES_METADATA_KEY, (Object)jbossWebservicesMD);
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }

    private URL getJBossWebServicesDescriptorURL(ResourceRoot deploymentRoot) throws DeploymentUnitProcessingException {
        VirtualFile jwsdd = deploymentRoot.getRoot().getChild("WEB-INF/jboss-webservices.xml");
        if (!jwsdd.exists()) {
            jwsdd = deploymentRoot.getRoot().getChild("META-INF/jboss-webservices.xml");
        }
        try {
            return jwsdd.exists() ? jwsdd.toURL() : null;
        }
        catch (IOException e) {
            throw WSMessages.MESSAGES.cannotGetURLForDescriptor(e, jwsdd.getPathName());
        }
    }
}

