/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.provisioning.number.nexmo;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.mobicents.servlet.restcomm.provisioning.number.api.ContainerConfiguration;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumber;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberParameters;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberProvisioningManager;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberSearchFilters;
import org.mobicents.servlet.restcomm.util.StringUtils;

public class NexmoPhoneNumberProvisioningManager
implements PhoneNumberProvisioningManager {
    private static final Logger logger = Logger.getLogger(NexmoPhoneNumberProvisioningManager.class);
    protected Boolean telestaxProxyEnabled;
    protected String uri;
    protected String apiKey;
    protected String apiSecret;
    protected String searchURI;
    protected String buyURI;
    protected String updateURI;
    protected String cancelURI;
    protected Configuration activeConfiguration;
    protected ContainerConfiguration containerConfiguration;

    public void init(Configuration phoneNumberProvisioningConfiguration, Configuration telestaxProxyConfiguration, ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        this.telestaxProxyEnabled = telestaxProxyConfiguration.getBoolean("enabled", false);
        if (this.telestaxProxyEnabled.booleanValue()) {
            this.uri = telestaxProxyConfiguration.getString("uri");
            this.apiKey = telestaxProxyConfiguration.getString("api-key");
            this.apiSecret = telestaxProxyConfiguration.getString("api-secret");
            this.activeConfiguration = telestaxProxyConfiguration;
        } else {
            Configuration nexmoConfiguration = phoneNumberProvisioningConfiguration.subset("nexmo");
            this.uri = nexmoConfiguration.getString("uri");
            this.apiKey = nexmoConfiguration.getString("api-key");
            this.apiSecret = nexmoConfiguration.getString("api-secret");
            this.activeConfiguration = nexmoConfiguration;
        }
        this.searchURI = this.uri + "/number/search/" + this.apiKey + "/" + this.apiSecret + "/";
        this.buyURI = this.uri + "/number/buy/" + this.apiKey + "/" + this.apiSecret + "/";
        this.updateURI = this.uri + "/number/update/" + this.apiKey + "/" + this.apiSecret + "/";
        this.cancelURI = this.uri + "/number/cancel/" + this.apiKey + "/" + this.apiSecret + "/";
    }

    private String getFriendlyName(String number, String countryCode) {
        try {
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil.parse(number, countryCode);
            String friendlyName = phoneNumberUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
            return friendlyName;
        }
        catch (Exception ignored) {
            return number;
        }
    }

    private List<PhoneNumber> toAvailablePhoneNumbers(JsonArray phoneNumbers, PhoneNumberSearchFilters listFilters) {
        Pattern searchPattern = listFilters.getFilterPattern();
        ArrayList<PhoneNumber> numbers = new ArrayList<PhoneNumber>();
        for (int i = 0; i < phoneNumbers.size(); ++i) {
            JsonObject number = phoneNumbers.get(i).getAsJsonObject();
            String countryCode = number.get("country").getAsString();
            String features = null;
            if (number.get("features") != null) {
                features = number.get("features").toString();
            }
            boolean isVoiceCapable = false;
            boolean isSmsCapable = false;
            if (features.contains("SMS")) {
                isSmsCapable = true;
            }
            if (features.contains("VOICE")) {
                isVoiceCapable = true;
            }
            PhoneNumber phoneNumber = new PhoneNumber(this.getFriendlyName(number.get("msisdn").getAsString(), countryCode), number.get("msisdn").getAsString(), null, null, null, null, null, null, countryCode, Boolean.valueOf(isVoiceCapable), Boolean.valueOf(isSmsCapable), null, null, null);
            numbers.add(phoneNumber);
        }
        return numbers;
    }

    public List<PhoneNumber> searchForNumbers(String country, PhoneNumberSearchFilters listFilters) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchPattern " + listFilters.getFilterPattern()));
        }
        Pattern filterPattern = listFilters.getFilterPattern();
        String queryUri = this.searchURI + country;
        boolean queryParamAdded = false;
        if (filterPattern != null) {
            queryUri = queryUri + "?pattern=" + filterPattern.toString();
            queryParamAdded = true;
        }
        if (listFilters.getSmsEnabled() != null || listFilters.getVoiceEnabled() != null) {
            if (!queryParamAdded) {
                queryUri = queryUri + "?";
                queryParamAdded = true;
            } else {
                queryUri = queryUri + "&";
            }
            queryUri = listFilters.getSmsEnabled() != null && listFilters.getVoiceEnabled() != null ? queryUri + "features=" + listFilters.getSmsEnabled() + "," + listFilters.getVoiceEnabled() : (listFilters.getSmsEnabled() != null ? queryUri + "features=" + listFilters.getSmsEnabled() : queryUri + "features=" + listFilters.getVoiceEnabled());
        }
        if (listFilters.getRangeIndex() != -1) {
            if (!queryParamAdded) {
                queryUri = queryUri + "?";
                queryParamAdded = true;
            } else {
                queryUri = queryUri + "&";
            }
            queryUri = queryUri + "index=" + listFilters.getRangeIndex();
        }
        if (listFilters.getRangeSize() != -1) {
            if (!queryParamAdded) {
                queryUri = queryUri + "?";
                queryParamAdded = true;
            } else {
                queryUri = queryUri + "&";
            }
            queryUri = queryUri + "size=" + listFilters.getRangeSize();
        }
        HttpGet get = new HttpGet(queryUri);
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                String content = StringUtils.toString((InputStream)response.getEntity().getContent());
                JsonParser parser = new JsonParser();
                JsonObject jsonResponse = parser.parse(content).getAsJsonObject();
                long count = jsonResponse.getAsJsonPrimitive("count").getAsLong();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Number of numbers found : " + count));
                }
                JsonArray nexmoNumbers = jsonResponse.getAsJsonArray("numbers");
                List<PhoneNumber> numbers = this.toAvailablePhoneNumbers(nexmoNumbers, listFilters);
                return numbers;
            }
            logger.warn((Object)("Couldn't reach uri for getting Phone Numbers. Response status was: " + response.getStatusLine().getStatusCode()));
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't reach uri for getting Phone Numbers" + this.uri), (Throwable)e);
        }
        return new ArrayList<PhoneNumber>();
    }

    public boolean buyNumber(PhoneNumber phoneNumberObject, PhoneNumberParameters phoneNumberParameters) {
        String phoneNumber = phoneNumberObject.getPhoneNumber();
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        String country = null;
        try {
            Phonenumber.PhoneNumber numberProto = null;
            numberProto = phoneNumber.startsWith("+") ? phoneUtil.parse(phoneNumber, "US") : phoneUtil.parse("+" + phoneNumber, "US");
            int countryCode = numberProto.getCountryCode();
            country = phoneUtil.getRegionCodeForCountryCode(countryCode);
        }
        catch (NumberParseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("problem parsing phone number " + phoneNumber), (Throwable)e);
            }
            return false;
        }
        String queryUri = null;
        queryUri = phoneNumber.startsWith("+") ? this.buyURI + country + "/" + phoneNumber.substring(1, phoneNumber.length()) : this.buyURI + country + "/" + phoneNumber;
        HttpPost post = new HttpPost(queryUri);
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                this.updateNumber(phoneNumberObject, phoneNumberParameters);
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Couldn't buy Phone Number " + phoneNumber + ". Response status was: " + response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't reach uri for buying Phone Numbers" + this.uri), (Throwable)e);
        }
        return false;
    }

    public boolean updateNumber(PhoneNumber phoneNumberObj, PhoneNumberParameters phoneNumberParameters) {
        String phoneNumber = phoneNumberObj.getPhoneNumber();
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        String country = null;
        try {
            Phonenumber.PhoneNumber numberProto = null;
            numberProto = phoneNumber.startsWith("+") ? phoneUtil.parse(phoneNumber, "US") : phoneUtil.parse("+" + phoneNumber, "US");
            int countryCode = numberProto.getCountryCode();
            country = phoneUtil.getRegionCodeForCountryCode(countryCode);
        }
        catch (NumberParseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("problem parsing phone number " + phoneNumber), (Throwable)e);
            }
            return false;
        }
        String updateUri = null;
        updateUri = phoneNumber.startsWith("+") ? this.updateURI + country + "/" + phoneNumber.substring(1, phoneNumber.length()) : this.updateURI + country + "/" + phoneNumber;
        try {
            HttpPost updatePost;
            DefaultHttpClient client;
            HttpResponse updateResponse;
            if (phoneNumberParameters.getVoiceUrl() != null && !phoneNumberParameters.getVoiceUrl().isEmpty() || phoneNumberParameters.getSmsUrl() != null && phoneNumberParameters.getSmsUrl().isEmpty()) {
                updateUri = updateUri + "?";
                updateUri = phoneNumberParameters.getSmsUrl() != null && !phoneNumberParameters.getSmsUrl().isEmpty() && phoneNumberParameters.getVoiceUrl() != null && !phoneNumberParameters.getVoiceUrl().isEmpty() ? updateUri + "voiceCallbackValue=" + URLEncoder.encode(phoneNumber + "@" + phoneNumberParameters.getVoiceUrl(), "UTF-8") + "&voiceCallbackType=sip" + "&moHttpUrl=" + URLEncoder.encode(phoneNumber + "@" + phoneNumberParameters.getSmsUrl(), "UTF-8") + "&moSmppSysType=inbound" : (phoneNumberParameters.getVoiceUrl() != null && !phoneNumberParameters.getVoiceUrl().isEmpty() ? updateUri + "voiceCallbackValue=" + URLEncoder.encode(phoneNumber + "@" + phoneNumberParameters.getVoiceUrl(), "UTF-8") + "&voiceCallbackType=sip" : updateUri + "moHttpUrl=" + URLEncoder.encode(phoneNumber + "@" + phoneNumberParameters.getSmsUrl(), "UTF-8") + "&moSmppSysType=inbound");
            }
            if ((updateResponse = (client = new DefaultHttpClient()).execute((HttpUriRequest)(updatePost = new HttpPost(updateUri)))).getStatusLine().getStatusCode() == 200) {
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Couldn't update Phone Number " + phoneNumber + ". Response status was: " + updateResponse.getStatusLine().getStatusCode()));
            }
            return false;
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't reach uri for update Phone Numbers" + this.uri), (Throwable)e);
            return false;
        }
    }

    public boolean cancelNumber(PhoneNumber phoneNumberObj) {
        String phoneNumber = phoneNumberObj.getPhoneNumber();
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        String country = null;
        try {
            Phonenumber.PhoneNumber numberProto = null;
            numberProto = phoneNumber.startsWith("+") ? phoneUtil.parse(phoneNumber, "US") : phoneUtil.parse("+" + phoneNumber, "US");
            int countryCode = numberProto.getCountryCode();
            country = phoneUtil.getRegionCodeForCountryCode(countryCode);
        }
        catch (NumberParseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("problem parsing phone number " + phoneNumber), (Throwable)e);
            }
            return false;
        }
        String queryUri = null;
        queryUri = phoneNumber.startsWith("+") ? this.cancelURI + country + "/" + phoneNumber.substring(1, phoneNumber.length()) : this.cancelURI + country + "/" + phoneNumber;
        HttpPost post = new HttpPost(queryUri);
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Couldn't cancel Phone Number " + phoneNumber + ". Response status was: " + response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't reach uri for cancelling Phone Numbers" + this.uri), (Throwable)e);
        }
        return false;
    }

    public List<String> getAvailableCountries() {
        String[] locales;
        ArrayList<String> countries = new ArrayList<String>();
        for (String countryCode : locales = Locale.getISOCountries()) {
            countries.add(countryCode);
        }
        return countries;
    }
}

