/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core;

import org.mobicents.media.server.impl.rtp.sdp.MediaDescriptorField;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.impl.rtp.sdp.SdpComparator;
import org.mobicents.media.server.impl.rtp.sdp.SessionDescription;
import org.mobicents.media.server.spi.format.AudioFormat;

@Deprecated
public class SdpTemplate {
    private SdpComparator sdpComparator;
    private SessionDescription sessionDescription;
    private String template;
    private String bindAddress = "";
    private String connectionAddress = "";
    private String networkType = "";
    private String addressType = "";
    private int rtpAudioPort = 0;
    private int rtcpAudioPort = 0;
    private int videoPort = 0;
    private int applicationPort = 0;
    private String connectionMode = "";
    private long ssrc = 0L;
    private String cname = "";
    private RTPFormats offeredAudioFormats;
    private RTPFormats offeredVideoFormats;
    private RTPFormats offeredApplicationFormats;
    private RTPFormats supportedAudioFormats;
    private RTPFormats supportedVideoFormats;
    private RTPFormats supportedApplicationFormats;
    private RTPFormats negotiatedAudioFormats;
    private RTPFormats negotiatedVideoFormats;
    private RTPFormats negotiatedApplicationFormats;
    private String headerTemplate = "";
    private String audioTemplate = "";
    private String videoTemplate = "";
    private String applicationTemplate = "";
    @Deprecated
    private boolean isAudioSupported;
    @Deprecated
    private boolean isVideoSupported;

    public SdpTemplate(SessionDescription sessionDescription) {
        this.sdpComparator = new SdpComparator();
        this.sessionDescription = sessionDescription;
        this.setOfferedAudioFormats(sessionDescription);
        this.setOfferedVideoFormats(sessionDescription);
        this.setOfferedApplicationFormats(sessionDescription);
    }

    @Deprecated
    public SdpTemplate(RTPFormats audio, RTPFormats video) {
        StringBuilder builder = new StringBuilder();
        this.writeHeader(builder);
        if (audio != null && !audio.isEmpty()) {
            this.isAudioSupported = true;
            this.writeAudioDescriptor(builder, audio);
        }
        if (video != null && !video.isEmpty()) {
            this.isVideoSupported = true;
            this.writeVideoDescriptor(builder, video);
        }
        this.template = builder.toString();
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        this.headerTemplate = this.writeHeader();
        builder.append(String.format(this.headerTemplate, System.currentTimeMillis(), this.bindAddress, this.networkType, this.addressType, this.connectionAddress));
        if (this.offeredAudioFormats != null) {
            this.audioTemplate = this.writeAudioDescriptor();
            boolean audioSupported = this.isAudioSupported();
            int rtpPort = audioSupported ? this.rtpAudioPort : 0;
            int rtcpPort = audioSupported ? this.rtcpAudioPort : 0;
            builder.append(String.format(this.audioTemplate, rtpPort, rtcpPort, this.ssrc, this.cname));
        }
        if (this.offeredVideoFormats != null) {
            this.videoTemplate = this.writeVideoDescriptor();
            builder.append(String.format(this.videoTemplate, this.isVideoSupported() ? this.videoPort : 0));
        }
        if (this.offeredApplicationFormats != null) {
            this.applicationTemplate = this.writeApplicationDescriptor();
            builder.append(String.format(this.applicationTemplate, this.isApplicationSupported() ? this.applicationPort : 0));
        }
        return builder.toString();
    }

    protected String getMediaProfile() {
        return "RTP/AVP";
    }

    protected String getApplicationProfile() {
        if (this.sessionDescription != null && this.sessionDescription.getApplicationDescriptor() != null) {
            return this.sessionDescription.getApplicationDescriptor().getProfile().toString();
        }
        return "";
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setConnectionAddress(String connectionAddress) {
        this.connectionAddress = connectionAddress;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public void setConnectionMode(String connectionMode) {
        this.connectionMode = connectionMode;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }

    public void setCname(String cname) {
        this.cname = cname;
    }

    public void setSupportedAudioFormats(RTPFormats supported) {
        this.supportedAudioFormats = supported;
        this.negotiatedAudioFormats = this.offeredAudioFormats != null && !this.offeredAudioFormats.isEmpty() ? this.sdpComparator.negotiateAudio(this.sessionDescription, this.supportedAudioFormats) : null;
    }

    public void setSupportedApplicationFormats(RTPFormats formats) {
        this.supportedApplicationFormats = formats;
        this.negotiatedApplicationFormats = this.isApplicationSupported() ? this.sdpComparator.negotiateApplication(this.sessionDescription, this.supportedApplicationFormats) : null;
    }

    public void setSupportedVideoFormats(RTPFormats supportedVideoFormats) {
        this.supportedVideoFormats = supportedVideoFormats;
        this.negotiatedVideoFormats = this.isVideoSupported() ? this.sdpComparator.negotiateVideo(this.sessionDescription, this.supportedVideoFormats) : null;
    }

    private void setOfferedAudioFormats(SessionDescription sdp) {
        MediaDescriptorField audioDescriptor = sdp.getAudioDescriptor();
        this.offeredAudioFormats = audioDescriptor != null ? audioDescriptor.getFormats() : null;
    }

    private void setOfferedVideoFormats(SessionDescription sdp) {
        MediaDescriptorField videoDescriptor = sdp.getVideoDescriptor();
        this.offeredVideoFormats = videoDescriptor != null ? videoDescriptor.getFormats() : null;
    }

    private void setOfferedApplicationFormats(SessionDescription sdp) {
        MediaDescriptorField applicationDescriptor = sdp.getApplicationDescriptor();
        this.offeredApplicationFormats = applicationDescriptor != null ? applicationDescriptor.getFormats() : null;
    }

    public RTPFormats getNegotiatedAudioFormats() {
        return this.negotiatedAudioFormats;
    }

    public RTPFormats getNegotiatedVideoFormats() {
        return this.negotiatedVideoFormats;
    }

    public RTPFormats getNegotiatedApplicationFormats() {
        return this.negotiatedApplicationFormats;
    }

    public boolean isAudioSupported() {
        return this.negotiatedAudioFormats != null && !this.negotiatedAudioFormats.isEmpty();
    }

    public boolean isApplicationSupported() {
        return this.negotiatedApplicationFormats != null && !this.negotiatedApplicationFormats.isEmpty();
    }

    public boolean isVideoSupported() {
        return this.negotiatedVideoFormats != null && !this.negotiatedVideoFormats.isEmpty();
    }

    public void setRtpAudioPort(int port) {
        this.rtpAudioPort = port;
    }

    public void setRtcpAudioPort(int port) {
        this.rtcpAudioPort = port;
    }

    public void setVideoPort(int videoPort) {
        this.videoPort = videoPort;
    }

    public void setApplicationPort(int applicationPort) {
        this.applicationPort = applicationPort;
    }

    protected String getExtendedAudioAttributes() {
        return "";
    }

    protected String getExtendedVideoAttributes() {
        return "";
    }

    protected String getExtendedApplicationAttributes() {
        return "";
    }

    private String getSdpSessionSetupAttribute() {
        return "a=setup:passive\n";
    }

    private String payloads(RTPFormats formats) {
        StringBuilder builder = new StringBuilder();
        formats.rewind();
        while (formats.hasMore()) {
            RTPFormat f = formats.next();
            builder.append(f.getID());
            builder.append(" ");
        }
        return builder.toString().trim();
    }

    @Deprecated
    private void writeHeader(StringBuilder builder) {
        builder.append("v=0\n");
        builder.append("o=- %s 1 IN IP4 %s\n");
        builder.append("s=Mobicents Media Server \n");
        builder.append("c=%s %s %s\n");
        builder.append("t=0 0\n");
    }

    private String writeHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("v=0\n");
        builder.append("o=- %s 1 IN IP4 %s\n");
        builder.append("s=Mobicents Media Server \n");
        builder.append("c=%s %s %s\n");
        builder.append("t=0 0\n");
        return builder.toString();
    }

    @Deprecated
    private void writeAudioDescriptor(StringBuilder builder, RTPFormats formats) {
        builder.append("m=audio %s ");
        builder.append(this.getMediaProfile());
        builder.append(" ");
        builder.append(this.payloads(formats));
        builder.append("\n");
        formats.rewind();
        while (formats.hasMore()) {
            RTPFormat f = formats.next();
            String rtpmap = null;
            AudioFormat fmt = (AudioFormat)f.getFormat();
            rtpmap = fmt.getChannels() == 1 ? String.format("a=rtpmap:%d %s/%d\n", f.getID(), fmt.getName(), f.getClockRate()) : String.format("a=rtpmap:%d %s/%d/%d\n", f.getID(), fmt.getName(), f.getClockRate(), fmt.getChannels());
            builder.append(rtpmap);
            if (f.getFormat().getOptions() != null) {
                builder.append(String.format("a=fmtp:%d %s\n", f.getID(), f.getFormat().getOptions()));
            }
            if (!f.getFormat().shouldSendPTime()) continue;
            builder.append("a=ptime:20\n");
        }
        builder.append(this.getSdpSessionSetupAttribute());
        builder.append(this.getExtendedAudioAttributes()).append("\n");
    }

    private String writeAudioDescriptor() {
        if (this.offeredAudioFormats == null) {
            throw new NullPointerException("Supported audio formats is null. Cannot write audio descriptor.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("m=audio %s ").append(this.getMediaProfile()).append(" ");
        if (this.isAudioSupported()) {
            builder.append(this.payloads(this.negotiatedAudioFormats)).append("\n");
            builder.append("a=rtcp:%d\n");
            this.negotiatedAudioFormats.rewind();
            while (this.negotiatedAudioFormats.hasMore()) {
                RTPFormat f = this.negotiatedAudioFormats.next();
                String rtpmap = null;
                AudioFormat fmt = (AudioFormat)f.getFormat();
                rtpmap = fmt.getChannels() == 1 ? String.format("a=rtpmap:%d %s/%d\n", f.getID(), fmt.getName(), f.getClockRate()) : String.format("a=rtpmap:%d %s/%d/%d\n", f.getID(), fmt.getName(), f.getClockRate(), fmt.getChannels());
                builder.append(rtpmap);
                if (f.getFormat().getOptions() != null) {
                    builder.append(String.format("a=fmtp:%d %s\n", f.getID(), f.getFormat().getOptions()));
                }
                if (!f.getFormat().shouldSendPTime()) continue;
                builder.append("a=ptime:20\n");
            }
            builder.append(String.format("a=%s\n", this.connectionMode));
            builder.append(this.getSdpSessionSetupAttribute());
            builder.append(this.getExtendedAudioAttributes()).append("\n");
        } else {
            builder.append(this.payloads(this.offeredAudioFormats)).append("\n");
        }
        return builder.toString();
    }

    @Deprecated
    private void writeVideoDescriptor(StringBuilder builder, RTPFormats formats) {
        builder.append("m=video %s ").append(this.getMediaProfile()).append(" ");
        builder.append(this.payloads(formats)).append("\n");
        formats.rewind();
        while (formats.hasMore()) {
            RTPFormat f = formats.next();
            builder.append(String.format("a=rtpmap:%d %s/%d\n", f.getID(), f.getFormat().getName(), f.getClockRate()));
            if (f.getFormat().getOptions() == null) continue;
            builder.append(String.format("a=fmtp: %d %s\n", f.getID(), f.getFormat().getOptions().toString()));
        }
    }

    private String writeVideoDescriptor() {
        if (this.offeredVideoFormats == null) {
            throw new NullPointerException("Supported video formats is null. Cannot write video descriptor.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("m=video %s ").append(this.getMediaProfile()).append(" ");
        if (this.isVideoSupported()) {
            builder.append(this.payloads(this.negotiatedVideoFormats)).append("\n");
            this.negotiatedVideoFormats.rewind();
            while (this.negotiatedVideoFormats.hasMore()) {
                RTPFormat f = this.negotiatedVideoFormats.next();
                builder.append(String.format("a=rtpmap:%d %s/%d\n", f.getID(), f.getFormat().getName(), f.getClockRate()));
                if (f.getFormat().getOptions() == null) continue;
                builder.append(String.format("a=fmtp: %d %s\n", f.getID(), f.getFormat().getOptions().toString()));
            }
            builder.append(this.getExtendedVideoAttributes()).append("\n");
        } else {
            builder.append(this.payloads(this.offeredVideoFormats)).append("\n");
        }
        return builder.toString();
    }

    private String writeApplicationDescriptor() {
        if (this.offeredApplicationFormats == null) {
            throw new NullPointerException("Supported application formats is null. Cannot write application descriptor.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("m=application %s ").append(this.getApplicationProfile()).append(" 0");
        return builder.toString();
    }

    @Deprecated
    public String getSDP(String bindAddress, String netwType, String addressType, String address, int audioPort, int videoPort) {
        if (this.isAudioSupported && !this.isVideoSupported) {
            return String.format(this.template, System.currentTimeMillis(), bindAddress, netwType, addressType, address, audioPort);
        }
        if (!this.isAudioSupported && this.isVideoSupported) {
            return String.format(this.template, System.currentTimeMillis(), bindAddress, netwType, addressType, address, videoPort);
        }
        if (this.isAudioSupported && this.isVideoSupported) {
            return String.format(this.template, System.currentTimeMillis(), bindAddress, netwType, addressType, address, audioPort, videoPort);
        }
        return String.format(this.template, System.currentTimeMillis(), bindAddress, netwType, addressType, address);
    }
}

