---
name: Bug report
about: Create a report to help us improve FreeRTOS. This should only be used for confirmed
  bugs. If you suspect something it is best to first discuss it on the FreeRTOS community
  support forums linked below.
title: "[BUG]"
labels: bug
assignees: ''

---

**Describe the bug**
A concise description of what the bug is.

**Target**
- Development board: [e.g. HiFive11 RevB]
- Instruction Set Architecture: [e.g. RV32IMAC]
- IDE and version: [e.g. Freedom Studio 4.12.0.2019-08-2]
- Toolchain and version: [e.g. riscv64-unknown-elf-gcc-8.3.0-2019.08.0]

**Host**
- Host OS: [e.g. MacOS]
- Version: [e.g. Mojave 10.14.6]

**To Reproduce**
- Use project ... and configure with ...
- Run on ... and could observe ...

**Expected behavior**
A concise description of what you expected to happen.

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Additional context**
Add any other context about the problem here.
e.g. code snippet to reproduce the issue.
e.g. stack trace, memory dump, debugger log, and many etc.

<!-- For general inquiries, please post in [FreeRTOS forum](https://forums.FreeRTOS.org) for community support. -->
