/*
 * Decompiled with CFR 0.152.
 */
package vmm.internal;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import vmm.VmmException;
import vmm.internal.IVmmNativeEx;

public class VmmImplPanama
implements IVmmNativeEx {
    private final int PRE_ALLOCATED_SEGMENT_SIZE = 262144;
    private final AtomicBoolean lock = new AtomicBoolean();
    private final Arena arena = Arena.ofShared();
    private final Linker linker = Linker.nativeLinker();
    private SymbolLookup lookup;
    private MemorySegment vmmHandle;
    private MemorySegment dataBufferSegment;
    private MemorySegment refSegment;
    private VmmMethodHandles methodHandles;

    private VmmImplPanama() {
    }

    public VmmImplPanama(Long hVMM, String vmmPath) {
        if (Boolean.getBoolean("vmm.disable-java-lang-foreign")) {
            throw new VmmException();
        }
        vmmPath = System.getProperty("os.name").toLowerCase().contains("win") ? String.valueOf(vmmPath) + "\\vmm.dll" : String.valueOf(vmmPath) + "/vmm.so";
        this.vmmHandle = MemorySegment.ofAddress(hVMM);
        this.lookup = SymbolLookup.libraryLookup(Paths.get(vmmPath, new String[0]), this.arena);
        this.dataBufferSegment = this.arena.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, 262144L);
        this.refSegment = this.arena.allocate(ValueLayout.ADDRESS);
        this.methodHandles = new VmmMethodHandles();
        this.methodHandles.initialize();
    }

    @Override
    public byte[] memRead(int pid, long va, int size, int flags) {
        if (size > 262144 || !this.lock.compareAndSet(false, true)) {
            Arena dynamicArena = Arena.ofShared();
            MemorySegment dataBufferSegment = dynamicArena.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)size);
            byte[] bytes = this.memRead(pid, va, size, flags, dataBufferSegment);
            dynamicArena.close();
            return bytes;
        }
        try {
            byte[] byArray = this.memRead(pid, va, size, flags, this.dataBufferSegment);
            return byArray;
        }
        finally {
            this.lock.set(false);
        }
    }

    private byte[] memRead(int pid, long va, int size, int flags, MemorySegment dataBufferSegment) {
        boolean successful = (Boolean)this.invokeUnchecked(this.methodHandles.memRead, this.vmmHandle, pid, va, dataBufferSegment, size, this.refSegment, flags);
        if (!successful) {
            throw new VmmException();
        }
        return this.getBytes(size, dataBufferSegment);
    }

    @Override
    public void memWrite(int pid, long va, byte[] data) {
        int size = data.length;
        if (size > 262144 || !this.lock.compareAndSet(false, true)) {
            Arena dynamicArena = Arena.ofShared();
            MemorySegment dataBufferSegment = dynamicArena.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)size);
            this.memWrite(pid, va, data, dataBufferSegment);
            dynamicArena.close();
        } else {
            try {
                this.memWrite(pid, va, data, this.dataBufferSegment);
            }
            finally {
                this.lock.set(false);
            }
        }
    }

    private void memWrite(int pid, long va, byte[] data, MemorySegment dataBufferSegment) {
        this.putBytes(data, dataBufferSegment);
        boolean successful = (Boolean)this.invokeUnchecked(this.methodHandles.memWrite, this.vmmHandle, pid, va, dataBufferSegment, data.length);
        if (!successful) {
            throw new VmmException();
        }
    }

    @Override
    public Object scatterInitialize(int pid, int flags) {
        MemorySegment result = (MemorySegment)this.invokeUnchecked(this.methodHandles.scatterInitialize, this.vmmHandle, pid, flags);
        if (result == null) {
            throw new VmmException();
        }
        return result;
    }

    @Override
    public void scatterPrepare(Object scatterHandle, long va, int size) {
        boolean successful = (Boolean)this.invokeUnchecked(this.methodHandles.scatterPrepare, scatterHandle, va, size);
        if (!successful) {
            throw new VmmException();
        }
    }

    @Override
    public void scatterPrepareWrite(Object scatterHandle, long va, byte[] data) {
        int length = data.length;
        if (length > 262144 || !this.lock.compareAndSet(false, true)) {
            Arena dynamicArena = Arena.ofShared();
            MemorySegment dataBufferSegment = dynamicArena.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)length);
            this.scatterPrepareWrite((MemorySegment)scatterHandle, va, data, dataBufferSegment);
            dynamicArena.close();
        } else {
            try {
                this.scatterPrepareWrite((MemorySegment)scatterHandle, va, data, this.dataBufferSegment);
            }
            finally {
                this.lock.set(false);
            }
        }
    }

    private void scatterPrepareWrite(MemorySegment scatterHandle, long va, byte[] data, MemorySegment dataBufferSegment) {
        this.putBytes(data, dataBufferSegment);
        boolean successful = (Boolean)this.invokeUnchecked(this.methodHandles.scatterPrepareWrite, scatterHandle, va, dataBufferSegment, data.length);
        if (!successful) {
            throw new VmmException();
        }
    }

    @Override
    public void scatterExecute(Object scatterHandle) {
        boolean successful = (Boolean)this.invokeUnchecked(this.methodHandles.scatterExecute, scatterHandle);
        if (!successful) {
            throw new VmmException();
        }
    }

    @Override
    public void scatterClear(Object scatterHandle, int pid, int flags) {
        boolean successful = (Boolean)this.invokeUnchecked(this.methodHandles.scatterClear, scatterHandle, pid, flags);
        if (!successful) {
            throw new VmmException();
        }
    }

    @Override
    public void scatterClose(Object scatterHandle) {
        try {
            this.invokeUnchecked(this.methodHandles.scatterClose, scatterHandle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public byte[] scatterRead(Object scatterHandle, long va, int size) {
        if (size > 262144 || !this.lock.compareAndSet(false, true)) {
            Arena dynamicArena = Arena.ofShared();
            MemorySegment dataBufferSegment = dynamicArena.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)size);
            byte[] bytes = this.scatterRead((MemorySegment)scatterHandle, va, size, dataBufferSegment);
            dynamicArena.close();
            return bytes;
        }
        try {
            byte[] byArray = this.scatterRead((MemorySegment)scatterHandle, va, size, this.dataBufferSegment);
            return byArray;
        }
        finally {
            this.lock.set(false);
        }
    }

    private byte[] scatterRead(MemorySegment scatterHandle, long va, int size, MemorySegment dataBufferSegment) {
        boolean successful = (Boolean)this.invokeUnchecked(this.methodHandles.scatterRead, scatterHandle, va, size, dataBufferSegment, this.refSegment);
        if (!successful) {
            throw new VmmException();
        }
        return this.getBytes(size, dataBufferSegment);
    }

    private void putBytes(byte[] data, MemorySegment dest) {
        dest.asByteBuffer().put(data);
    }

    private byte[] getBytes(int size, MemorySegment src) {
        byte[] bytes = new byte[size];
        src.asByteBuffer().get(bytes);
        return bytes;
    }

    private Object invokeUnchecked(MethodHandle methodHandle, Object ... args) {
        try {
            return methodHandle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new VmmException("Native call failed.", e);
        }
    }

    private class VmmMethodHandles {
        private MethodHandle memRead;
        private MethodHandle memWrite;
        private MethodHandle scatterInitialize;
        private MethodHandle scatterPrepare;
        private MethodHandle scatterPrepareWrite;
        private MethodHandle scatterExecute;
        private MethodHandle scatterRead;
        private MethodHandle scatterClear;
        private MethodHandle scatterClose;

        private VmmMethodHandles() {
        }

        private void initialize() {
            this.initializeMemReadHandle();
            this.initializeMemWriteHandle();
            this.initializeScatterInitializeHandle();
            this.initializeScatterPrepareHandle();
            this.initializeScatterPrepareWriteHandle();
            this.initializeScatterExecuteHandle();
            this.initializeScatterClearHandle();
            this.initializeScatterReadHandle();
            this.initializeScatterCloseHandle();
        }

        private void initializeMemReadHandle() {
            FunctionDescriptor memReadDescriptor = FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT);
            this.memRead = this.constructMethodHandle("VMMDLL_MemReadEx", memReadDescriptor);
        }

        private void initializeMemWriteHandle() {
            FunctionDescriptor memWriteDescriptor = FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT);
            this.memWrite = this.constructMethodHandle("VMMDLL_MemWrite", memWriteDescriptor);
        }

        private void initializeScatterInitializeHandle() {
            FunctionDescriptor scatterInitializeDescriptor = FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT);
            this.scatterInitialize = this.constructMethodHandle("VMMDLL_Scatter_Initialize", scatterInitializeDescriptor);
        }

        private void initializeScatterPrepareHandle() {
            FunctionDescriptor scatterPrepareDescriptor = FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT);
            this.scatterPrepare = this.constructMethodHandle("VMMDLL_Scatter_Prepare", scatterPrepareDescriptor);
        }

        private void initializeScatterPrepareWriteHandle() {
            FunctionDescriptor scatterPrepareWriteDescriptor = FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT);
            this.scatterPrepareWrite = this.constructMethodHandle("VMMDLL_Scatter_PrepareWrite", scatterPrepareWriteDescriptor);
        }

        private void initializeScatterExecuteHandle() {
            FunctionDescriptor scatterExecuteDescriptor = FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS);
            this.scatterExecute = this.constructMethodHandle("VMMDLL_Scatter_Execute", scatterExecuteDescriptor);
        }

        private void initializeScatterClearHandle() {
            FunctionDescriptor scatterClearDescriptor = FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT);
            this.scatterClear = this.constructMethodHandle("VMMDLL_Scatter_Clear", scatterClearDescriptor);
        }

        private void initializeScatterReadHandle() {
            FunctionDescriptor scatterReadDescriptor = FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS);
            this.scatterRead = this.constructMethodHandle("VMMDLL_Scatter_Read", scatterReadDescriptor);
        }

        private void initializeScatterCloseHandle() {
            FunctionDescriptor scatterCloseDescriptor = FunctionDescriptor.ofVoid(ValueLayout.ADDRESS);
            this.scatterClose = this.constructMethodHandle("VMMDLL_Scatter_CloseHandle", scatterCloseDescriptor);
        }

        private MethodHandle constructMethodHandle(String methodName, FunctionDescriptor descriptor) {
            MemorySegment memReadEx = VmmImplPanama.this.lookup.find(methodName).orElseThrow();
            return VmmImplPanama.this.linker.downcallHandle(memReadEx, descriptor, new Linker.Option[0]);
        }
    }
}

