/*
 * Decompiled with CFR 0.152.
 */
package vmm.internal;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import vmm.IVmm;
import vmm.IVmmMemScatterMemory;
import vmm.IVmmModule;
import vmm.IVmmPdb;
import vmm.IVmmProcess;
import vmm.IVmmRegHive;
import vmm.IVmmRegKey;
import vmm.IVmmRegValue;
import vmm.VmmException;
import vmm.entry.VmmMap_HandleEntry;
import vmm.entry.VmmMap_HeapAllocEntry;
import vmm.entry.VmmMap_HeapEntry;
import vmm.entry.VmmMap_HeapMap;
import vmm.entry.VmmMap_HeapSegmentEntry;
import vmm.entry.VmmMap_MemMapEntry;
import vmm.entry.VmmMap_ModuleDataDirectory;
import vmm.entry.VmmMap_ModuleExport;
import vmm.entry.VmmMap_ModuleImport;
import vmm.entry.VmmMap_ModuleSection;
import vmm.entry.VmmMap_NetEntry;
import vmm.entry.VmmMap_PoolEntry;
import vmm.entry.VmmMap_PoolMap;
import vmm.entry.VmmMap_PteEntry;
import vmm.entry.VmmMap_ServiceEntry;
import vmm.entry.VmmMap_ThreadEntry;
import vmm.entry.VmmMap_UnloadedModuleEntry;
import vmm.entry.VmmMap_UserEntry;
import vmm.entry.VmmMap_VadEntry;
import vmm.entry.VmmMap_VadExEntry;
import vmm.entry.Vmm_ModuleExDebugInfo;
import vmm.entry.Vmm_ModuleExVersionInfo;
import vmm.entry.Vmm_VfsListEntry;
import vmm.internal.IVmmNativeEx;
import vmm.internal.VmmNative;

public class VmmImpl
implements IVmm {
    private boolean isVerbose;
    private Pointer hVMM;
    private String vmmNativeLibraryPath;
    private IVmmNativeEx jnative;

    private VmmImpl() {
        this.isVerbose = false;
        this.hVMM = null;
        this.vmmNativeLibraryPath = null;
        this.jnative = null;
    }

    private VmmImpl(String vmmNativeLibraryPath, String[] argv) {
        block8: {
            this.isVerbose = false;
            this.hVMM = null;
            this.vmmNativeLibraryPath = null;
            this.jnative = null;
            String[] argv_new = null;
            if (argv.length < 2) {
                throw new VmmException("Vmm Init: failed - too few arguments.");
            }
            if (argv[0].equals("") || argv[0].equals("-printf")) {
                argv_new = argv;
            } else {
                argv_new = new String[argv.length + 1];
                argv_new[0] = "";
                System.arraycopy(argv, 0, argv_new, 1, argv.length);
            }
            System.setProperty("jna.library.path", vmmNativeLibraryPath);
            this.hVMM = VmmNative.INSTANCE.VMMDLL_Initialize(argv_new.length, argv_new);
            if (this.hVMM == null) {
                throw new VmmException("Vmm Init: failed in native code.");
            }
            VmmNative.INSTANCE.VMMDLL_InitializePlugins(this.hVMM);
            this.vmmNativeLibraryPath = vmmNativeLibraryPath;
            this.isVerbose = this.getConfig(0x4000000200000000L) == 1L;
            try {
                if (this.isVerbose) {
                    System.out.println("vmm: java.lang.foreign implementation = try enable.");
                }
                this.jnative = (IVmmNativeEx)Class.forName("vmm.internal.VmmImplPanama").getDeclaredConstructor(Long.class, String.class).newInstance(Pointer.nativeValue((Pointer)this.hVMM), vmmNativeLibraryPath);
                if (this.isVerbose) {
                    System.out.println("vmm: java.lang.foreign implementation = enabled.");
                }
            }
            catch (Throwable t) {
                if (!this.isVerbose) break block8;
                System.out.println("vmm: java.lang.foreign implementation = failed to enable (JDK21+ required).");
            }
        }
    }

    public static IVmm Initialize(String vmmNativeLibraryPath, String[] argv) {
        return new VmmImpl(vmmNativeLibraryPath, argv);
    }

    @Override
    public boolean isValid() {
        return this.hVMM != null;
    }

    @Override
    public String getNativeLibraryPath() {
        return this.vmmNativeLibraryPath;
    }

    @Override
    public void close() {
        VmmNative.INSTANCE.VMMDLL_Close(this.hVMM);
        this.hVMM = null;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.hVMM != null ? "Vmm" : "VmmNotValid";
    }

    @Override
    public long getConfig(long fOption) {
        LongByReference pqw = new LongByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_ConfigGet(this.hVMM, fOption, pqw);
        if (!f) {
            throw new VmmException();
        }
        return pqw.getValue();
    }

    @Override
    public void setConfig(long fOption, long qw) {
        boolean f = VmmNative.INSTANCE.VMMDLL_ConfigSet(this.hVMM, fOption, qw);
        if (!f) {
            throw new VmmException();
        }
    }

    private static byte[] _utilStringToCString(String s) {
        byte[] bjava = s.getBytes(StandardCharsets.UTF_8);
        byte[] bc = new byte[bjava.length + 1];
        System.arraycopy(bjava, 0, bc, 0, bjava.length);
        return bc;
    }

    @Override
    public List<Vmm_VfsListEntry> vfsList(String path) {
        final ArrayList<Vmm_VfsListEntry> result = new ArrayList<Vmm_VfsListEntry>();
        VmmNative.VMMDLL_VFS_FILELIST2 vfs = new VmmNative.VMMDLL_VFS_FILELIST2();
        vfs.dwVersion = 2;
        vfs.h = 0L;
        vfs.pfnAddFile = new VmmNative.VMMDLL_VFS_FILELIST2.CB_FILE(){

            @Override
            public void invoke(long h, String uszName, long cb, Pointer pExInfo) {
                Vmm_VfsListEntry e = new Vmm_VfsListEntry();
                e.name = uszName;
                e.isFile = true;
                e.size = cb;
                result.add(e);
            }
        };
        vfs.pfnAddDirectory = new VmmNative.VMMDLL_VFS_FILELIST2.CB_DIRECTORY(){

            @Override
            public void invoke(long h, String uszName, Pointer pExInfo) {
                Vmm_VfsListEntry e = new Vmm_VfsListEntry();
                e.name = uszName;
                e.isFile = false;
                e.size = 0L;
                result.add(e);
            }
        };
        boolean f = VmmNative.INSTANCE.VMMDLL_VfsListU(this.hVMM, VmmImpl._utilStringToCString(path), vfs);
        if (!f) {
            throw new VmmException();
        }
        return result;
    }

    @Override
    public byte[] vfsRead(String file, long offset, int size) {
        IntByReference pcbRead = new IntByReference();
        Memory pb = new Memory((long)size);
        VmmNative.INSTANCE.VMMDLL_VfsReadU(this.hVMM, VmmImpl._utilStringToCString(file), (Pointer)pb, size, pcbRead, offset);
        if (pcbRead.getValue() == 0) {
            throw new VmmException();
        }
        size = Math.min(size, pcbRead.getValue());
        byte[] result = new byte[size];
        pb.read(0L, result, 0, size);
        return result;
    }

    @Override
    public String vfsReadString(String file, long offset, int size) {
        byte[] data = this.vfsRead(file, offset, size);
        return new String(data, StandardCharsets.UTF_8);
    }

    @Override
    public void vfsWrite(String file, byte[] data, long offset) {
        IntByReference pcbWrite = new IntByReference();
        Memory pb = new Memory((long)data.length);
        pb.write(0L, data, 0, data.length);
        VmmNative.INSTANCE.VMMDLL_VfsWriteU(this.hVMM, VmmImpl._utilStringToCString(file), (Pointer)pb, data.length, pcbWrite, offset);
        if (pcbWrite.getValue() == 0) {
            throw new VmmException();
        }
    }

    public byte[] _memRead(int pid, long va, int size) {
        return this._memRead(pid, va, size, 0);
    }

    public byte[] _memRead(int pid, long va, int size, int flags) {
        if (this.jnative == null) {
            byte[] pbResult = new byte[size];
            IntByReference pcbRead = new IntByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_MemReadEx(this.hVMM, pid, va, pbResult, size, pcbRead, flags);
            if (!f) {
                throw new VmmException();
            }
            return pbResult;
        }
        return this.jnative.memRead(pid, va, size, flags);
    }

    public void _memWrite(int pid, long va, byte[] data) {
        if (this.jnative == null) {
            boolean f = VmmNative.INSTANCE.VMMDLL_MemWrite(this.hVMM, pid, va, data, data.length);
            if (!f) {
                throw new VmmException();
            }
        } else {
            this.jnative.memWrite(pid, va, data);
        }
    }

    public void _memPrefetchPages(int pid, long[] vas) {
        boolean f = VmmNative.INSTANCE.VMMDLL_MemPrefetchPages(this.hVMM, pid, vas, vas.length);
        if (!f) {
            throw new VmmException();
        }
    }

    public long _memVirtualToPhysical(int pid, long va) {
        LongByReference pa = new LongByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_MemVirt2Phys(this.hVMM, pid, va, pa);
        if (!f) {
            throw new VmmException();
        }
        return pa.getValue();
    }

    public IVmmMemScatterMemory _memScatterInitialize(int pid, int flags) {
        if (this.jnative == null) {
            Pointer hS = VmmNative.INSTANCE.VMMDLL_Scatter_Initialize(this.hVMM, pid, flags);
            if (hS == null) {
                throw new VmmException();
            }
            return new VmmMemScatterMemoryImpl(hS, null, pid, flags);
        }
        Object nhS = this.jnative.scatterInitialize(pid, flags);
        return new VmmMemScatterMemoryImpl(null, nhS, pid, flags);
    }

    @Override
    public byte[] memRead(long pa, int size) {
        return this._memRead(-1, pa, size);
    }

    @Override
    public byte[] memRead(long pa, int size, int flags) {
        return this._memRead(-1, pa, size, flags);
    }

    @Override
    public void memWrite(long pa, byte[] data) {
        this._memWrite(-1, pa, data);
    }

    @Override
    public void memPrefetchPages(long[] pas) {
        this._memPrefetchPages(-1, pas);
    }

    @Override
    public IVmmMemScatterMemory memScatterInitialize(int flags) {
        return this._memScatterInitialize(-1, flags);
    }

    @Override
    public IVmmProcess kernelProcess() {
        return new VmmProcessImpl(4);
    }

    @Override
    public IVmmPdb kernelPdb() {
        return new VmmPdbImpl("nt");
    }

    @Override
    public int kernelBuildNumber() {
        return (int)this.getConfig(2305844121610223616L);
    }

    @Override
    public List<VmmMap_MemMapEntry> mapPhysicalMemory() {
        PointerByReference pptr = new PointerByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetPhysMem(this.hVMM, pptr);
        if (!f) {
            throw new VmmException();
        }
        VmmNative.VMMDLL_MAP_PHYSMEM pMap = new VmmNative.VMMDLL_MAP_PHYSMEM(pptr.getValue());
        ArrayList<VmmMap_MemMapEntry> result = new ArrayList<VmmMap_MemMapEntry>();
        VmmNative.VMMDLL_MAP_PHYSMEM_ENTRY[] vMMDLL_MAP_PHYSMEM_ENTRYArray = pMap.pMap;
        int n = pMap.pMap.length;
        int n2 = 0;
        while (n2 < n) {
            VmmNative.VMMDLL_MAP_PHYSMEM_ENTRY n3 = vMMDLL_MAP_PHYSMEM_ENTRYArray[n2];
            VmmMap_MemMapEntry e = new VmmMap_MemMapEntry();
            e.pa = n3.pa;
            e.cb = n3.cb;
            result.add(e);
            ++n2;
        }
        VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
        return result;
    }

    @Override
    public List<VmmMap_NetEntry> mapNet() {
        PointerByReference pptr = new PointerByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetNetU(this.hVMM, pptr);
        if (!f) {
            throw new VmmException();
        }
        VmmNative.VMMDLL_MAP_NET pMap = new VmmNative.VMMDLL_MAP_NET(pptr.getValue());
        ArrayList<VmmMap_NetEntry> result = new ArrayList<VmmMap_NetEntry>();
        VmmNative.VMMDLL_MAP_NETENTRY[] vMMDLL_MAP_NETENTRYArray = pMap.pMap;
        int n = pMap.pMap.length;
        int n2 = 0;
        while (n2 < n) {
            VmmNative.VMMDLL_MAP_NETENTRY n3 = vMMDLL_MAP_NETENTRYArray[n2];
            VmmMap_NetEntry e = new VmmMap_NetEntry();
            e.str = n3.uszText;
            e.dwPid = n3.dwPID;
            e.dwState = n3.dwState;
            e.AF = n3.AF;
            e.vaObj = n3.vaObj;
            e.ftTime = n3.ftTime;
            e.dwPoolTag = n3.dwPoolTag;
            e.srcValid = n3.Src.fValid;
            e.dstValid = n3.Dst.fValid;
            e.srcPort = n3.Src.port;
            e.dstPort = n3.Dst.port;
            e.srcStr = n3.Src.uszText;
            e.dstStr = n3.Dst.uszText;
            result.add(e);
            ++n2;
        }
        VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
        return result;
    }

    @Override
    public List<VmmMap_UserEntry> mapUser() {
        PointerByReference pptr = new PointerByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetUsersU(this.hVMM, pptr);
        if (!f) {
            throw new VmmException();
        }
        VmmNative.VMMDLL_MAP_USER pMap = new VmmNative.VMMDLL_MAP_USER(pptr.getValue());
        ArrayList<VmmMap_UserEntry> result = new ArrayList<VmmMap_UserEntry>();
        VmmNative.VMMDLL_MAP_USERENTRY[] vMMDLL_MAP_USERENTRYArray = pMap.pMap;
        int n = pMap.pMap.length;
        int n2 = 0;
        while (n2 < n) {
            VmmNative.VMMDLL_MAP_USERENTRY n3 = vMMDLL_MAP_USERENTRYArray[n2];
            VmmMap_UserEntry e = new VmmMap_UserEntry();
            e.user = n3.uszText;
            e.SID = n3.uszSID;
            e.vaRegHive = n3.vaRegHive;
            result.add(e);
            ++n2;
        }
        VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
        return result;
    }

    @Override
    public List<VmmMap_ServiceEntry> mapService() {
        PointerByReference pptr = new PointerByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetServicesU(this.hVMM, pptr);
        if (!f) {
            throw new VmmException();
        }
        VmmNative.VMMDLL_MAP_SERVICE pMap = new VmmNative.VMMDLL_MAP_SERVICE(pptr.getValue());
        ArrayList<VmmMap_ServiceEntry> result = new ArrayList<VmmMap_ServiceEntry>();
        VmmNative.VMMDLL_MAP_SERVICEENTRY[] vMMDLL_MAP_SERVICEENTRYArray = pMap.pMap;
        int n = pMap.pMap.length;
        int n2 = 0;
        while (n2 < n) {
            VmmNative.VMMDLL_MAP_SERVICEENTRY n3 = vMMDLL_MAP_SERVICEENTRYArray[n2];
            VmmMap_ServiceEntry e = new VmmMap_ServiceEntry();
            e.vaObj = n3.vaObj;
            e.dwOrdinal = n3.dwOrdinal;
            e.dwStartType = n3.dwStartType;
            e.uszServiceName = n3.uszServiceName;
            e.uszDisplayName = n3.uszDisplayName;
            e.uszPath = n3.uszPath;
            e.uszUserTp = n3.uszUserTp;
            e.uszUserAcct = n3.uszUserAcct;
            e.uszImagePath = n3.uszImagePath;
            e.dwPID = n3.dwPID;
            e.dwServiceType = n3.ServiceStatus.dwServiceType;
            e.dwCurrentState = n3.ServiceStatus.dwCurrentState;
            e.dwControlsAccepted = n3.ServiceStatus.dwControlsAccepted;
            e.dwWin32ExitCode = n3.ServiceStatus.dwWin32ExitCode;
            e.dwServiceSpecificExitCode = n3.ServiceStatus.dwServiceSpecificExitCode;
            e.dwCheckPoint = n3.ServiceStatus.dwCheckPoint;
            e.dwWaitHint = n3.ServiceStatus.dwWaitHint;
            result.add(e);
            ++n2;
        }
        VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
        return result;
    }

    @Override
    public VmmMap_PoolMap mapPool(boolean isBigPoolOnly) {
        PointerByReference pptr = new PointerByReference();
        int flags = isBigPoolOnly ? 1 : 0;
        boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetPool(this.hVMM, pptr, flags);
        if (!f) {
            throw new VmmException();
        }
        VmmNative.VMMDLL_MAP_POOL pMap = new VmmNative.VMMDLL_MAP_POOL(pptr.getValue());
        VmmMap_PoolMap result = new VmmMap_PoolMap();
        result.tag = new HashMap<String, Map<Long, VmmMap_PoolEntry>>();
        result.va = new HashMap<Long, VmmMap_PoolEntry>();
        VmmNative.VMMDLL_MAP_POOLENTRY[] vMMDLL_MAP_POOLENTRYArray = pMap.pMap;
        int n = pMap.pMap.length;
        int n2 = 0;
        while (n2 < n) {
            VmmNative.VMMDLL_MAP_POOLENTRY n3 = vMMDLL_MAP_POOLENTRYArray[n2];
            VmmMap_PoolEntry e = new VmmMap_PoolEntry();
            e.va = n3.va;
            e.cb = n3.cb;
            e.fAlloc = n3.fAlloc != 0;
            e.tpPool = n3.tpPool;
            e.tpSS = n3.tpSS;
            e.tag = Native.toString((byte[])n3.tag);
            result.va.put(e.va, e);
            Map<Long, VmmMap_PoolEntry> tagMap = result.tag.get(e.tag);
            if (tagMap == null) {
                tagMap = new HashMap<Long, VmmMap_PoolEntry>();
                result.tag.put(e.tag, tagMap);
            }
            tagMap.put(e.va, e);
            ++n2;
        }
        VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
        return result;
    }

    @Override
    public IVmmProcess processGet(int pid) {
        VmmProcessImpl p = new VmmProcessImpl(pid);
        p.ensure();
        return p;
    }

    @Override
    public IVmmProcess processGet(String name) {
        IntByReference pdwPID = new IntByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_PidGetFromName(this.hVMM, VmmImpl._utilStringToCString(name), pdwPID);
        if (!f) {
            throw new VmmException();
        }
        return new VmmProcessImpl(pdwPID.getValue());
    }

    @Override
    public List<IVmmProcess> processGetAll() {
        LongByReference pcPIDs = new LongByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_PidList(this.hVMM, null, pcPIDs);
        if (!f) {
            throw new VmmException();
        }
        int[] pids = new int[(int)pcPIDs.getValue()];
        f = VmmNative.INSTANCE.VMMDLL_PidList(this.hVMM, pids, pcPIDs);
        if (!f) {
            throw new VmmException();
        }
        ArrayList<IVmmProcess> result = new ArrayList<IVmmProcess>();
        int[] nArray = pids;
        int n = pids.length;
        int n2 = 0;
        while (n2 < n) {
            int pid = nArray[n2];
            if (pid != 0) {
                result.add(new VmmProcessImpl(pid));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<IVmmRegHive> regHive() {
        IntByReference pcHives = new IntByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_WinReg_HiveList(this.hVMM, null, 0, pcHives);
        if (!f) {
            throw new VmmException();
        }
        int cHives = pcHives.getValue();
        VmmNative.VMMDLL_REGISTRY_HIVE_INFORMATION[] pHives = new VmmNative.VMMDLL_REGISTRY_HIVE_INFORMATION[cHives];
        f = VmmNative.INSTANCE.VMMDLL_WinReg_HiveList(this.hVMM, pHives, cHives, pcHives);
        if (!f) {
            throw new VmmException();
        }
        cHives = pcHives.getValue();
        ArrayList<IVmmRegHive> result = new ArrayList<IVmmRegHive>();
        VmmNative.VMMDLL_REGISTRY_HIVE_INFORMATION[] vMMDLL_REGISTRY_HIVE_INFORMATIONArray = pHives;
        int n = pHives.length;
        int n2 = 0;
        while (n2 < n) {
            VmmNative.VMMDLL_REGISTRY_HIVE_INFORMATION pHive = vMMDLL_REGISTRY_HIVE_INFORMATIONArray[n2];
            result.add(new VmmRegHiveImpl(pHive));
            ++n2;
        }
        return result;
    }

    @Override
    public IVmmRegKey regKey(String strFullPath) {
        IntByReference lpcchName = new IntByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_WinReg_EnumKeyExU(this.hVMM, strFullPath, -1, null, lpcchName, null);
        if (!f) {
            return null;
        }
        return new VmmRegKeyImpl(strFullPath);
    }

    @Override
    public IVmmRegValue regValue(String strFullPath) {
        IntByReference lpType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        boolean f = VmmNative.INSTANCE.VMMDLL_WinReg_QueryValueExU(this.hVMM, strFullPath, lpType, null, lpcbData);
        if (!f) {
            return null;
        }
        return new VmmRegValueImpl(strFullPath, lpType.getValue());
    }

    private class VmmMemScatterMemoryImpl
    implements IVmmMemScatterMemory {
        private final Object objLock = new Object();
        private Object nhS;
        private Pointer hS;
        private int pid;
        private int flags;

        private VmmMemScatterMemoryImpl(Pointer hS, Object nhS, int pid, int flags) {
            this.hS = hS;
            this.nhS = nhS;
            this.pid = pid;
            this.flags = flags;
        }

        public String toString() {
            if (this.pid == -1) {
                return "VmmScatterMemory:Physical";
            }
            return "VmmScatterMemory:Virtual:" + String.valueOf(this.pid);
        }

        @Override
        public boolean isValid() {
            return this.hS != null;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void prepare(long va, int size) {
            if (VmmImpl.this.jnative == null) {
                if (this.hS == null) {
                    throw new VmmException();
                }
                boolean f = VmmNative.INSTANCE.VMMDLL_Scatter_Prepare(this.hS, va, size);
                if (!f) {
                    throw new VmmException();
                }
            } else {
                if (this.nhS == null) {
                    throw new VmmException();
                }
                VmmImpl.this.jnative.scatterPrepare(this.nhS, va, size);
            }
        }

        @Override
        public void prepareWrite(long va, byte[] data) {
            if (VmmImpl.this.jnative == null) {
                if (this.hS == null) {
                    throw new VmmException();
                }
                boolean f = VmmNative.INSTANCE.VMMDLL_Scatter_PrepareWrite(this.hS, va, data, data.length);
                if (!f) {
                    throw new VmmException();
                }
            } else {
                if (this.nhS == null) {
                    throw new VmmException();
                }
                VmmImpl.this.jnative.scatterPrepareWrite(this.nhS, va, data);
            }
        }

        @Override
        public void execute() {
            if (VmmImpl.this.jnative == null) {
                if (this.hS == null) {
                    throw new VmmException();
                }
                boolean f = VmmNative.INSTANCE.VMMDLL_Scatter_Execute(this.hS);
                if (!f) {
                    throw new VmmException();
                }
            } else {
                if (this.nhS == null) {
                    throw new VmmException();
                }
                VmmImpl.this.jnative.scatterExecute(this.nhS);
            }
        }

        @Override
        public void clear() {
            if (VmmImpl.this.jnative == null) {
                if (this.hS == null) {
                    throw new VmmException();
                }
                boolean f = VmmNative.INSTANCE.VMMDLL_Scatter_Clear(this.hS, this.pid, this.flags);
                if (!f) {
                    throw new VmmException();
                }
            } else {
                if (this.nhS == null) {
                    throw new VmmException();
                }
                VmmImpl.this.jnative.scatterClear(this.nhS, this.pid, this.flags);
            }
        }

        @Override
        public byte[] read(long va, int size) {
            if (VmmImpl.this.jnative == null) {
                if (this.hS == null) {
                    throw new VmmException();
                }
                byte[] pbResult = new byte[size];
                IntByReference pcbRead = new IntByReference();
                boolean f = VmmNative.INSTANCE.VMMDLL_Scatter_Read(this.hS, va, size, pbResult, pcbRead);
                if (!f) {
                    throw new VmmException();
                }
                return pbResult;
            }
            if (this.nhS == null) {
                throw new VmmException();
            }
            return VmmImpl.this.jnative.scatterRead(this.nhS, va, size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.objLock;
            synchronized (object) {
                if (this.hS != null) {
                    VmmNative.INSTANCE.VMMDLL_Scatter_CloseHandle(this.hS);
                }
                if (this.nhS != null) {
                    VmmImpl.this.jnative.scatterClose(this.nhS);
                }
                this.hS = null;
                this.nhS = null;
                this.pid = 0;
                this.flags = 0;
            }
        }

        public void finalize() {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class VmmModuleImpl
    implements IVmmModule {
        private IVmmProcess process;
        private int pid;
        private VmmNative.VMMDLL_MAP_MODULEENTRY module;
        private VmmNative.VMMDLL_MAP_MODULEENTRY_DEBUGINFO debug;
        private VmmNative.VMMDLL_MAP_MODULEENTRY_VERSIONINFO version;

        private VmmModuleImpl(IVmmProcess process, VmmNative.VMMDLL_MAP_MODULEENTRY module, VmmNative.VMMDLL_MAP_MODULEENTRY_DEBUGINFO debug, VmmNative.VMMDLL_MAP_MODULEENTRY_VERSIONINFO version) {
            this.module = module;
            this.debug = debug;
            this.version = version;
            this.process = process;
            this.pid = process.getPID();
        }

        public String toString() {
            return "VmmModule:" + String.valueOf(this.pid) + ":" + this.module.uszText;
        }

        @Override
        public IVmmProcess getProcess() {
            return this.process;
        }

        @Override
        public String getName() {
            return this.module.uszText;
        }

        @Override
        public String getNameFull() {
            return this.module.uszFullName;
        }

        @Override
        public long getVaBase() {
            return this.module.vaBase;
        }

        @Override
        public long getVaEntry() {
            return this.module.vaEntry;
        }

        @Override
        public int getSize() {
            return this.module.cbImageSize;
        }

        @Override
        public int getSizeFile() {
            return this.module.cbFileSizeRaw;
        }

        @Override
        public boolean isWow64() {
            return this.module.fWoW64;
        }

        @Override
        public int getCountSection() {
            return this.module.cSection;
        }

        @Override
        public int getCountEAT() {
            return this.module.cEAT;
        }

        @Override
        public int getCountIAT() {
            return this.module.cIAT;
        }

        @Override
        public Vmm_ModuleExDebugInfo getExDebugInfo() {
            if (this.debug == null) {
                return null;
            }
            Vmm_ModuleExDebugInfo n = new Vmm_ModuleExDebugInfo();
            n.dwAge = this.debug.dwAge;
            n.Guid = this.debug.uszGuid;
            n.GuidBytes = this.debug.Guid;
            n.PdbFilename = this.debug.uszPdbFilename;
            return n;
        }

        @Override
        public Vmm_ModuleExVersionInfo getExVersionInfo() {
            if (this.version == null) {
                return null;
            }
            Vmm_ModuleExVersionInfo n = new Vmm_ModuleExVersionInfo();
            n.CompanyName = this.version.uszCompanyName;
            n.FileDescription = this.version.uszFileDescription;
            n.FileVersion = this.version.uszFileVersion;
            n.InternalName = this.version.uszInternalName;
            n.LegalCopyright = this.version.uszLegalCopyright;
            n.OriginalFilename = this.version.uszOriginalFilename;
            n.ProductName = this.version.uszProductName;
            n.ProductVersion = this.version.uszProductVersion;
            return n;
        }

        @Override
        public long getProcAddress(String szFunctionName) {
            return VmmNative.INSTANCE.VMMDLL_ProcessGetProcAddressU(VmmImpl.this.hVMM, this.pid, this.module.uszText, szFunctionName);
        }

        @Override
        public List<VmmMap_ModuleDataDirectory> mapDataDirectory() {
            String[] DIRECTORIES = new String[]{"EXPORT", "IMPORT", "RESOURCE", "EXCEPTION", "SECURITY", "BASERELOC", "DEBUG", "ARCHITECTURE", "GLOBALPTR", "TLS", "LOAD_CONFIG", "BOUND_IMPORT", "IAT", "DELAY_IMPORT", "COM_DESCRIPTOR", "RESERVED"};
            VmmNative.IMAGE_DATA_DIRECTORY[] aData = new VmmNative.IMAGE_DATA_DIRECTORY[16];
            boolean f = VmmNative.INSTANCE.VMMDLL_ProcessGetDirectoriesU(VmmImpl.this.hVMM, this.pid, this.module.uszText, aData);
            if (!f) {
                throw new VmmException();
            }
            ArrayList<VmmMap_ModuleDataDirectory> result = new ArrayList<VmmMap_ModuleDataDirectory>();
            int i = 0;
            while (i < 16) {
                VmmNative.IMAGE_DATA_DIRECTORY n = aData[i];
                VmmMap_ModuleDataDirectory e = new VmmMap_ModuleDataDirectory();
                e.RealVirtualAddress = (long)n.VirtualAddress + this.module.vaBase;
                e.VirtualAddress = n.VirtualAddress;
                e.Size = n.Size;
                e.name = DIRECTORIES[i];
                result.add(e);
                ++i;
            }
            return result;
        }

        @Override
        public List<VmmMap_ModuleSection> mapSection() {
            IntByReference pcData = new IntByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_ProcessGetSectionsU(VmmImpl.this.hVMM, this.pid, this.module.uszText, null, 0, pcData);
            if (!f) {
                throw new VmmException();
            }
            int cData = pcData.getValue();
            VmmNative.IMAGE_SECTION_HEADER[] aData = new VmmNative.IMAGE_SECTION_HEADER[cData];
            f = VmmNative.INSTANCE.VMMDLL_ProcessGetSectionsU(VmmImpl.this.hVMM, this.pid, this.module.uszText, aData, cData, pcData);
            if (!f) {
                throw new VmmException();
            }
            ArrayList<VmmMap_ModuleSection> result = new ArrayList<VmmMap_ModuleSection>();
            VmmNative.IMAGE_SECTION_HEADER[] iMAGE_SECTION_HEADERArray = aData;
            int n = aData.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.IMAGE_SECTION_HEADER n3 = iMAGE_SECTION_HEADERArray[n2];
                VmmMap_ModuleSection e = new VmmMap_ModuleSection();
                e.name = Native.toString((byte[])n3.name);
                e.MiscVirtualSize = n3.MiscVirtualSize;
                e.VirtualAddress = n3.VirtualAddress;
                e.SizeOfRawData = n3.SizeOfRawData;
                e.PointerToRawData = n3.PointerToRawData;
                e.PointerToRelocations = n3.PointerToRelocations;
                e.PointerToLinenumbers = n3.PointerToLinenumbers;
                e.NumberOfRelocations = n3.NumberOfRelocations;
                e.NumberOfLinenumbers = n3.NumberOfLinenumbers;
                e.Characteristics = n3.Characteristics;
                result.add(e);
                ++n2;
            }
            return result;
        }

        @Override
        public List<VmmMap_ModuleExport> mapExport() {
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetEATU(VmmImpl.this.hVMM, this.pid, this.module.uszText, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_EAT pMap = new VmmNative.VMMDLL_MAP_EAT(pptr.getValue());
            ArrayList<VmmMap_ModuleExport> result = new ArrayList<VmmMap_ModuleExport>();
            VmmNative.VMMDLL_MAP_EATENTRY[] vMMDLL_MAP_EATENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_EATENTRY n3 = vMMDLL_MAP_EATENTRYArray[n2];
                VmmMap_ModuleExport e = new VmmMap_ModuleExport();
                e.vaFunction = n3.vaFunction;
                e.dwOrdinal = n3.dwOrdinal;
                e.oFunctionsArray = n3.oFunctionsArray;
                e.oNamesArray = n3.oNamesArray;
                e.uszFunction = n3.uszFunction;
                e.uszForwardedFunction = n3.uszForwardedFunction;
                e.uszModule = this.module.uszText;
                result.add(e);
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public List<VmmMap_ModuleImport> mapImport() {
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetIATU(VmmImpl.this.hVMM, this.pid, this.module.uszText, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_IAT pMap = new VmmNative.VMMDLL_MAP_IAT(pptr.getValue());
            ArrayList<VmmMap_ModuleImport> result = new ArrayList<VmmMap_ModuleImport>();
            VmmNative.VMMDLL_MAP_IATENTRY[] vMMDLL_MAP_IATENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_IATENTRY n3 = vMMDLL_MAP_IATENTRYArray[n2];
                VmmMap_ModuleImport e = new VmmMap_ModuleImport();
                e.vaFunction = n3.vaFunction;
                e.uszFunction = n3.uszFunction;
                e.uszModule = n3.uszModule;
                e.f32 = n3.f32;
                e.wHint = n3.wHint;
                e.rvaFirstThunk = n3.rvaFirstThunk;
                e.rvaOriginalFirstThunk = n3.rvaOriginalFirstThunk;
                e.rvaNameModule = n3.rvaNameModule;
                e.rvaNameFunction = n3.rvaNameFunction;
                result.add(e);
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public IVmmPdb getPdb() {
            return new VmmPdbImpl(this.pid, this.module.vaBase);
        }
    }

    private class VmmPdbImpl
    implements IVmmPdb {
        private String pdbName;

        private VmmPdbImpl(int dwPID, long vaModuleBase) {
            byte[] szModuleName = new byte[260];
            boolean f = VmmNative.INSTANCE.VMMDLL_PdbLoad(VmmImpl.this.hVMM, dwPID, vaModuleBase, szModuleName);
            if (!f) {
                throw new VmmException();
            }
            this.pdbName = Native.toString((byte[])szModuleName);
        }

        private VmmPdbImpl(String pdbName) {
            this.pdbName = pdbName;
        }

        public String toString() {
            return "VmmPdb:" + this.pdbName;
        }

        @Override
        public String getModuleName() {
            return this.pdbName;
        }

        @Override
        public long getSymbolAddress(String strSymbol) {
            LongByReference pvaSymbolAddress = new LongByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_PdbSymbolAddress(VmmImpl.this.hVMM, this.pdbName, strSymbol, pvaSymbolAddress);
            if (!f) {
                throw new VmmException();
            }
            return pvaSymbolAddress.getValue();
        }

        @Override
        public String getSymbolName(long vaSymbolOrOffset) {
            IntByReference pdwSymbolDisplacement = new IntByReference();
            byte[] szSymbolName = new byte[260];
            boolean f = VmmNative.INSTANCE.VMMDLL_PdbSymbolName(VmmImpl.this.hVMM, this.pdbName, vaSymbolOrOffset, szSymbolName, pdwSymbolDisplacement);
            if (!f) {
                throw new VmmException();
            }
            return Native.toString((byte[])szSymbolName);
        }

        @Override
        public int getTypeChildOffset(String strTypeName, String strChild) {
            IntByReference pcbTypeChildOffset = new IntByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_PdbTypeChildOffset(VmmImpl.this.hVMM, this.pdbName, strTypeName, strChild, pcbTypeChildOffset);
            if (!f) {
                throw new VmmException();
            }
            return pcbTypeChildOffset.getValue();
        }

        @Override
        public int getTypeSize(String strTypeName) {
            IntByReference pcbTypeSize = new IntByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_PdbTypeSize(VmmImpl.this.hVMM, this.pdbName, strTypeName, pcbTypeSize);
            if (!f) {
                throw new VmmException();
            }
            return pcbTypeSize.getValue();
        }
    }

    private class VmmProcessImpl
    implements IVmmProcess {
        private int pid;
        private VmmNative.VMMDLL_PROCESS_INFORMATION info;

        private VmmProcessImpl(int pid) {
            this.pid = pid;
            this.info = null;
        }

        private void ensure() {
            if (this.info == null) {
                LongByReference pcbInfo = new LongByReference();
                VmmNative.VMMDLL_PROCESS_INFORMATION pInfo = new VmmNative.VMMDLL_PROCESS_INFORMATION();
                pcbInfo.setValue((long)Native.getNativeSize(VmmNative.VMMDLL_PROCESS_INFORMATION.class, (Object)((Object)pInfo)));
                pInfo.magic = -4539647776472354786L;
                pInfo.wVersion = (short)7;
                boolean f = VmmNative.INSTANCE.VMMDLL_ProcessGetInformation(VmmImpl.this.hVMM, this.pid, pInfo, pcbInfo);
                if (!f) {
                    throw new VmmException();
                }
                if (pInfo.wVersion != 7) {
                    throw new VmmException("Bad Version");
                }
                this.info = pInfo;
            }
        }

        public String toString() {
            return "VmmProcess:" + String.valueOf(this.pid);
        }

        @Override
        public int getPID() {
            return this.pid;
        }

        @Override
        public byte[] memRead(long va, int size) {
            return VmmImpl.this._memRead(this.pid, va, size);
        }

        @Override
        public byte[] memRead(long va, int size, int flags) {
            return VmmImpl.this._memRead(this.pid, va, size, flags);
        }

        @Override
        public void memWrite(long va, byte[] data) {
            VmmImpl.this._memWrite(this.pid, va, data);
        }

        @Override
        public void memPrefetchPages(long[] vas) {
            VmmImpl.this._memPrefetchPages(this.pid, vas);
        }

        @Override
        public IVmmMemScatterMemory memScatterInitialize(int flags) {
            return VmmImpl.this._memScatterInitialize(this.pid, flags);
        }

        @Override
        public long memVirtualToPhysical(long va) {
            return VmmImpl.this._memVirtualToPhysical(this.pid, va);
        }

        @Override
        public List<VmmMap_HandleEntry> mapHandle() {
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetHandleU(VmmImpl.this.hVMM, this.pid, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_HANDLE pMap = new VmmNative.VMMDLL_MAP_HANDLE(pptr.getValue());
            ArrayList<VmmMap_HandleEntry> result = new ArrayList<VmmMap_HandleEntry>();
            VmmNative.VMMDLL_MAP_HANDLEENTRY[] vMMDLL_MAP_HANDLEENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_HANDLEENTRY n3 = vMMDLL_MAP_HANDLEENTRYArray[n2];
                VmmMap_HandleEntry e = new VmmMap_HandleEntry();
                e.vaObject = n3.vaObject;
                e.dwHandle = n3.dwHandle;
                e._dwGrantedAccess_iType = n3._dwGrantedAccess_iType;
                e.qwHandleCount = n3.qwHandleCount;
                e.qwPointerCount = n3.qwPointerCount;
                e.vaObjectCreateInfo = n3.vaObjectCreateInfo;
                e.vaSecurityDescriptor = n3.vaSecurityDescriptor;
                e.name = n3.uszText;
                e.dwPID = n3.dwPID;
                e.tag = Native.toString((byte[])n3.dwPoolTag);
                e.type = n3.uszType;
                result.add(e);
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public List<VmmMap_HeapAllocEntry> mapHeapAlloc(long qwHeapNumOrAddress) {
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetHeapAlloc(VmmImpl.this.hVMM, this.pid, qwHeapNumOrAddress, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_HEAPALLOC pMap = new VmmNative.VMMDLL_MAP_HEAPALLOC(pptr.getValue());
            ArrayList<VmmMap_HeapAllocEntry> result = new ArrayList<VmmMap_HeapAllocEntry>();
            VmmNative.VMMDLL_MAP_HEAPALLOCENTRY[] vMMDLL_MAP_HEAPALLOCENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_HEAPALLOCENTRY n3 = vMMDLL_MAP_HEAPALLOCENTRYArray[n2];
                VmmMap_HeapAllocEntry e = new VmmMap_HeapAllocEntry();
                e.va = n3.va;
                e.cb = n3.cb;
                e.tp = n3.tp;
                result.add(e);
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public VmmMap_HeapMap mapHeap() {
            Serializable e;
            VmmNative.VMMDLL_MAP_HEAPENTRY n;
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetHeap(VmmImpl.this.hVMM, this.pid, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_HEAP pMap = new VmmNative.VMMDLL_MAP_HEAP(pptr.getValue());
            VmmMap_HeapMap result = new VmmMap_HeapMap();
            result.heaps = new ArrayList<VmmMap_HeapEntry>();
            result.segments = new ArrayList<VmmMap_HeapSegmentEntry>();
            Structure[] structureArray = pMap.pMap;
            int n2 = pMap.pMap.length;
            int n3 = 0;
            while (n3 < n2) {
                n = structureArray[n3];
                e = new VmmMap_HeapEntry();
                e.va = n.va;
                e.tp = n.tp;
                e.f32 = n.f32;
                e.iHeap = n.iHeap;
                e.dwHeapNum = n.dwHeapNum;
                result.heaps.add((VmmMap_HeapEntry)e);
                ++n3;
            }
            structureArray = pMap.pSegments;
            n2 = pMap.pSegments.length;
            n3 = 0;
            while (n3 < n2) {
                n = structureArray[n3];
                e = new VmmMap_HeapSegmentEntry();
                ((VmmMap_HeapSegmentEntry)e).va = ((VmmNative.VMMDLL_MAP_HEAP_SEGMENTENTRY)((Object)n)).va;
                ((VmmMap_HeapSegmentEntry)e).cb = ((VmmNative.VMMDLL_MAP_HEAP_SEGMENTENTRY)((Object)n)).cb;
                ((VmmMap_HeapSegmentEntry)e).tp = ((VmmNative.VMMDLL_MAP_HEAP_SEGMENTENTRY)((Object)n)).tp;
                ((VmmMap_HeapSegmentEntry)e).iHeap = ((VmmNative.VMMDLL_MAP_HEAP_SEGMENTENTRY)((Object)n)).iHeap;
                result.segments.add((VmmMap_HeapSegmentEntry)e);
                ++n3;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public List<VmmMap_PteEntry> mapPte() {
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetPteU(VmmImpl.this.hVMM, this.pid, true, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_PTE pMap = new VmmNative.VMMDLL_MAP_PTE(pptr.getValue());
            ArrayList<VmmMap_PteEntry> result = new ArrayList<VmmMap_PteEntry>();
            VmmNative.VMMDLL_MAP_PTEENTRY[] vMMDLL_MAP_PTEENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_PTEENTRY n3 = vMMDLL_MAP_PTEENTRYArray[n2];
                VmmMap_PteEntry e = new VmmMap_PteEntry();
                e.vaBase = n3.vaBase;
                e.cPages = n3.cPages;
                e.fPage = n3.fPage;
                e.fWow64 = n3.fWow64;
                e.strDescription = n3.uszText;
                e.cSoftware = n3.cSoftware;
                result.add(e);
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public List<VmmMap_ThreadEntry> mapThread() {
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetThread(VmmImpl.this.hVMM, this.pid, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_THREAD pMap = new VmmNative.VMMDLL_MAP_THREAD(pptr.getValue());
            ArrayList<VmmMap_ThreadEntry> result = new ArrayList<VmmMap_ThreadEntry>();
            VmmNative.VMMDLL_MAP_THREADENTRY[] vMMDLL_MAP_THREADENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_THREADENTRY n3 = vMMDLL_MAP_THREADENTRYArray[n2];
                VmmMap_ThreadEntry e = new VmmMap_ThreadEntry();
                e.dwTID = n3.dwTID;
                e.dwPID = n3.dwPID;
                e.dwExitStatus = n3.dwExitStatus;
                e.bState = n3.bState;
                e.bRunning = n3.bRunning;
                e.bPriority = n3.bPriority;
                e.bBasePriority = n3.bBasePriority;
                e.vaETHREAD = n3.vaETHREAD;
                e.vaTeb = n3.vaTeb;
                e.ftCreateTime = n3.ftCreateTime;
                e.ftExitTime = n3.ftExitTime;
                e.vaStartAddress = n3.vaStartAddress;
                e.vaWin32StartAddress = n3.vaWin32StartAddress;
                e.vaStackBaseUser = n3.vaStackBaseUser;
                e.vaStackLimitUser = n3.vaStackLimitUser;
                e.vaStackBaseKernel = n3.vaStackBaseKernel;
                e.vaStackLimitKernel = n3.vaStackLimitKernel;
                e.vaTrapFrame = n3.vaTrapFrame;
                e.vaImpersonationToken = n3.vaImpersonationToken;
                e.vaRIP = n3.vaRIP;
                e.vaRSP = n3.vaRSP;
                e.qwAffinity = n3.qwAffinity;
                e.dwUserTime = n3.dwUserTime;
                e.dwKernelTime = n3.dwKernelTime;
                e.bSuspendCount = n3.bSuspendCount;
                e.bWaitReason = n3.bWaitReason;
                result.add(e);
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public List<VmmMap_UnloadedModuleEntry> mapUnloadedModule() {
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetUnloadedModuleU(VmmImpl.this.hVMM, this.pid, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_UNLOADEDMODULE pMap = new VmmNative.VMMDLL_MAP_UNLOADEDMODULE(pptr.getValue());
            ArrayList<VmmMap_UnloadedModuleEntry> result = new ArrayList<VmmMap_UnloadedModuleEntry>();
            VmmNative.VMMDLL_MAP_UNLOADEDMODULEENTRY[] vMMDLL_MAP_UNLOADEDMODULEENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_UNLOADEDMODULEENTRY n3 = vMMDLL_MAP_UNLOADEDMODULEENTRYArray[n2];
                VmmMap_UnloadedModuleEntry e = new VmmMap_UnloadedModuleEntry();
                e.vaBase = n3.vaBase;
                e.cbImageSize = n3.cbImageSize;
                e.fWow64 = n3.fWow64;
                e.strModuleName = n3.uszText;
                e.dwCheckSum = n3.dwCheckSum;
                e.dwTimeDateStamp = n3.dwTimeDateStamp;
                e.ftUnload = n3.ftUnload;
                result.add(e);
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public List<VmmMap_VadEntry> mapVad() {
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetVadU(VmmImpl.this.hVMM, this.pid, true, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_VAD pMap = new VmmNative.VMMDLL_MAP_VAD(pptr.getValue());
            ArrayList<VmmMap_VadEntry> result = new ArrayList<VmmMap_VadEntry>();
            VmmNative.VMMDLL_MAP_VADENTRY[] vMMDLL_MAP_VADENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_VADENTRY n3 = vMMDLL_MAP_VADENTRYArray[n2];
                VmmMap_VadEntry e = new VmmMap_VadEntry();
                e.vaStart = n3.vaStart;
                e.vaEnd = n3.vaEnd;
                e.vaVad = n3.vaVad;
                e.dw0 = n3.dw0;
                e.dw1 = n3.dw1;
                e.dwu2 = n3.dwu2;
                e.cbPrototypePte = n3.cbPrototypePte;
                e.vaPrototypePte = n3.vaPrototypePte;
                e.vaSubsection = n3.vaSubsection;
                e.uszText = n3.uszText;
                e.vaFileObject = n3.vaFileObject;
                e.cVadExPages = n3.cVadExPages;
                e.cVadExPagesBase = n3.cVadExPagesBase;
                result.add(e);
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public List<VmmMap_VadExEntry> mapVadEx(int oPage, int cPage) {
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetVadEx(VmmImpl.this.hVMM, this.pid, oPage, cPage, pptr);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_VADEX pMap = new VmmNative.VMMDLL_MAP_VADEX(pptr.getValue());
            ArrayList<VmmMap_VadExEntry> result = new ArrayList<VmmMap_VadExEntry>();
            VmmNative.VMMDLL_MAP_VADEXENTRY[] vMMDLL_MAP_VADEXENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_VADEXENTRY n3 = vMMDLL_MAP_VADEXENTRYArray[n2];
                VmmMap_VadExEntry e = new VmmMap_VadExEntry();
                e.tp = n3.tp;
                e.iPML = Byte.toUnsignedInt(n3.iPML);
                e.pteFlags = Byte.toUnsignedInt(n3.pteFlags);
                e.va = n3.va;
                e.pa = n3.pa;
                e.pte = n3.pte;
                e.proto_tp = n3.proto_tp;
                e.proto_pa = n3.proto_pa;
                e.proto_pte = n3.proto_pte;
                e.vaVadBase = n3.vaVadBase;
                result.add(e);
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }

        @Override
        public int getPPID() {
            this.ensure();
            return this.info.dwPPID;
        }

        @Override
        public long getEPROCESS() {
            this.ensure();
            return this.info.vaEPROCESS;
        }

        @Override
        public long getDTB() {
            this.ensure();
            return this.info.paDTB;
        }

        @Override
        public long getDTBUser() {
            this.ensure();
            return this.info.paDTB_UserOpt;
        }

        @Override
        public int getState() {
            this.ensure();
            return this.info.dwState;
        }

        @Override
        public long getPEB() {
            this.ensure();
            return this.info.vaPEB;
        }

        @Override
        public int getPEB32() {
            this.ensure();
            return this.info.vaPEB32;
        }

        @Override
        public boolean isWow64() {
            this.ensure();
            return this.info.fWow64;
        }

        @Override
        public boolean isUserMode() {
            this.ensure();
            return this.info.fUserOnly;
        }

        @Override
        public String getName() {
            this.ensure();
            return Native.toString((byte[])this.info.szName);
        }

        @Override
        public String getNameFull() {
            this.ensure();
            return Native.toString((byte[])this.info.szNameLong);
        }

        @Override
        public String getPathUser() {
            Pointer p = VmmNative.INSTANCE.VMMDLL_ProcessGetInformationString(VmmImpl.this.hVMM, this.pid, 2);
            String s = p.getString(0L);
            VmmNative.INSTANCE.VMMDLL_MemFree(p);
            return s;
        }

        @Override
        public String getCmdLine() {
            Pointer p = VmmNative.INSTANCE.VMMDLL_ProcessGetInformationString(VmmImpl.this.hVMM, this.pid, 3);
            String s = p.getString(0L);
            VmmNative.INSTANCE.VMMDLL_MemFree(p);
            return s;
        }

        @Override
        public String getPathKernel() {
            Pointer p = VmmNative.INSTANCE.VMMDLL_ProcessGetInformationString(VmmImpl.this.hVMM, this.pid, 1);
            String s = p.getString(0L);
            VmmNative.INSTANCE.VMMDLL_MemFree(p);
            return s;
        }

        @Override
        public int getTpMemoryModel() {
            this.ensure();
            return this.info.tpMemoryModel;
        }

        @Override
        public int getTpSystem() {
            this.ensure();
            return this.info.tpSystem;
        }

        @Override
        public long GetLUID() {
            this.ensure();
            return this.info.qwLUID;
        }

        @Override
        public int GetSessionID() {
            this.ensure();
            return this.info.dwSessionId;
        }

        @Override
        public String getSID() {
            return Native.toString((byte[])this.info.szSID);
        }

        @Override
        public IVmmModule moduleGet(long va, boolean isExtendedInfo) {
            for (IVmmModule m : this.moduleGetAll(isExtendedInfo)) {
                if (va < m.getVaBase() || va > m.getVaBase() + (long)m.getSize()) continue;
                return m;
            }
            return null;
        }

        @Override
        public IVmmModule moduleGet(String name, boolean isExtendedInfo) {
            int flags = 0;
            if (isExtendedInfo) {
                flags = 3;
            }
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetModuleFromNameU(VmmImpl.this.hVMM, this.pid, name, pptr, flags);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_MODULEENTRY pEntry = new VmmNative.VMMDLL_MAP_MODULEENTRY(pptr.getValue());
            VmmNative.VMMDLL_MAP_MODULEENTRY_DEBUGINFO pDebugEntry = null;
            if (pEntry.pExDebugInfo != 0L) {
                pDebugEntry = new VmmNative.VMMDLL_MAP_MODULEENTRY_DEBUGINFO(new PointerByReference(new Pointer(pEntry.pExDebugInfo)).getValue());
            }
            VmmNative.VMMDLL_MAP_MODULEENTRY_VERSIONINFO pVersionEntry = null;
            if (pEntry.pExVersionInfo != 0L) {
                pVersionEntry = new VmmNative.VMMDLL_MAP_MODULEENTRY_VERSIONINFO(new PointerByReference(new Pointer(pEntry.pExVersionInfo)).getValue());
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return new VmmModuleImpl(this, pEntry, pDebugEntry, pVersionEntry);
        }

        @Override
        public List<IVmmModule> moduleGetAll(boolean isExtendedInfo) {
            int flags = 0;
            if (isExtendedInfo) {
                flags = 3;
            }
            PointerByReference pptr = new PointerByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_Map_GetModuleU(VmmImpl.this.hVMM, this.pid, pptr, flags);
            if (!f) {
                throw new VmmException();
            }
            VmmNative.VMMDLL_MAP_MODULE pMap = new VmmNative.VMMDLL_MAP_MODULE(pptr.getValue());
            ArrayList<IVmmModule> result = new ArrayList<IVmmModule>();
            VmmNative.VMMDLL_MAP_MODULEENTRY[] vMMDLL_MAP_MODULEENTRYArray = pMap.pMap;
            int n = pMap.pMap.length;
            int n2 = 0;
            while (n2 < n) {
                VmmNative.VMMDLL_MAP_MODULEENTRY n3 = vMMDLL_MAP_MODULEENTRYArray[n2];
                VmmNative.VMMDLL_MAP_MODULEENTRY_DEBUGINFO pDebugEntry = null;
                if (n3.pExDebugInfo != 0L) {
                    pDebugEntry = new VmmNative.VMMDLL_MAP_MODULEENTRY_DEBUGINFO(new PointerByReference(new Pointer(n3.pExDebugInfo)).getValue());
                }
                VmmNative.VMMDLL_MAP_MODULEENTRY_VERSIONINFO pVersionEntry = null;
                if (n3.pExVersionInfo != 0L) {
                    pVersionEntry = new VmmNative.VMMDLL_MAP_MODULEENTRY_VERSIONINFO(new PointerByReference(new Pointer(n3.pExVersionInfo)).getValue());
                }
                result.add(new VmmModuleImpl(this, n3, pDebugEntry, pVersionEntry));
                ++n2;
            }
            VmmNative.INSTANCE.VMMDLL_MemFree(pptr.getValue());
            return result;
        }
    }

    private class VmmRegHiveImpl
    implements IVmmRegHive {
        private VmmNative.VMMDLL_REGISTRY_HIVE_INFORMATION hive;

        VmmRegHiveImpl(VmmNative.VMMDLL_REGISTRY_HIVE_INFORMATION hive) {
            this.hive = hive;
        }

        public String toString() {
            return String.format("VmmRegHive:0x%016x", this.hive.vaCMHIVE);
        }

        @Override
        public String getName() {
            return Native.toString((byte[])this.hive.uszName);
        }

        @Override
        public String getNameShort() {
            return Native.toString((byte[])this.hive.uszNameShort);
        }

        @Override
        public String getPath() {
            return Native.toString((byte[])this.hive.uszHiveRootPath);
        }

        @Override
        public int getSize() {
            return this.hive.cbLength;
        }

        @Override
        public long getVaHive() {
            return this.hive.vaCMHIVE;
        }

        @Override
        public long getVaBaseBlock() {
            return this.hive.vaHBASE_BLOCK;
        }

        @Override
        public byte[] memRead(int ra, int size) {
            return this.memRead(ra, size, 0);
        }

        @Override
        public byte[] memRead(int ra, int size, int flags) {
            IntByReference pcbRead = new IntByReference();
            Memory pb = new Memory((long)size);
            boolean f = VmmNative.INSTANCE.VMMDLL_WinReg_HiveReadEx(VmmImpl.this.hVMM, this.hive.vaCMHIVE, ra, (Pointer)pb, size, pcbRead, flags);
            if (!f) {
                throw new VmmException();
            }
            size = Math.min(size, pcbRead.getValue());
            byte[] result = new byte[size];
            pb.read(0L, result, 0, size);
            return result;
        }

        @Override
        public void memWrite(int ra, byte[] data) {
            boolean f = VmmNative.INSTANCE.VMMDLL_WinReg_HiveWrite(VmmImpl.this.hVMM, this.hive.vaCMHIVE, ra, data, data.length);
            if (!f) {
                throw new VmmException();
            }
        }

        @Override
        public IVmmRegKey getKeyRoot() {
            String strKeyPath = String.format("0x%016x\\ROOT", this.hive.vaCMHIVE);
            return new VmmRegKeyImpl(strKeyPath);
        }

        @Override
        public IVmmRegKey getKeyOrphan() {
            String strKeyPath = String.format("0x%016llx\\ORPHAN", this.hive.vaCMHIVE);
            return new VmmRegKeyImpl(strKeyPath);
        }
    }

    private class VmmRegKeyImpl
    implements IVmmRegKey {
        private String strPath;
        private String strName;

        private VmmRegKeyImpl(String strPath) {
            this.strName = strPath.substring(strPath.lastIndexOf(92) + 1);
            this.strPath = strPath;
        }

        public String toString() {
            return "VmmRegKey:" + this.strName;
        }

        @Override
        public String getName() {
            return this.strName;
        }

        @Override
        public String getPath() {
            return this.strPath;
        }

        @Override
        public IVmmRegKey getKeyParent() {
            int i = this.strPath.lastIndexOf(92);
            String strParent = this.strPath.substring(0, i);
            if (-1 == strParent.indexOf(92)) {
                return null;
            }
            return new VmmRegKeyImpl(strParent);
        }

        @Override
        public Map<String, IVmmRegKey> getKeyChild() {
            int i = 0;
            byte[] lpName = new byte[260];
            IntByReference lpcchName = new IntByReference(260);
            HashMap<String, IVmmRegKey> result = new HashMap<String, IVmmRegKey>();
            while (VmmNative.INSTANCE.VMMDLL_WinReg_EnumKeyExU(VmmImpl.this.hVMM, this.strPath, i, lpName, lpcchName, null)) {
                String strName = Native.toString((byte[])lpName);
                result.put(strName, new VmmRegKeyImpl(String.valueOf(this.strPath) + "\\" + strName));
                ++i;
            }
            return result;
        }

        @Override
        public Map<String, IVmmRegValue> getValues() {
            int i = 0;
            byte[] lpValueName = new byte[260];
            IntByReference lpcchValueName = new IntByReference(260);
            IntByReference lpType = new IntByReference();
            HashMap<String, IVmmRegValue> result = new HashMap<String, IVmmRegValue>();
            while (VmmNative.INSTANCE.VMMDLL_WinReg_EnumValueU(VmmImpl.this.hVMM, this.strPath, i, lpValueName, lpcchValueName, lpType, null, null)) {
                String strName = Native.toString((byte[])lpValueName);
                result.put(strName, new VmmRegValueImpl(String.valueOf(this.strPath) + "\\" + strName, lpType.getValue()));
                ++i;
            }
            return result;
        }

        @Override
        public long getTime() {
            IntByReference cch = new IntByReference();
            LongByReference lpftLastWriteTime = new LongByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_WinReg_EnumKeyExU(VmmImpl.this.hVMM, this.strPath, -1, null, cch, lpftLastWriteTime);
            if (!f) {
                throw new VmmException();
            }
            return lpftLastWriteTime.getValue();
        }
    }

    private class VmmRegValueImpl
    implements IVmmRegValue {
        private String strPath;
        private String strName;
        private int dwType;

        private VmmRegValueImpl(String strPath, int dwType) {
            this.strName = strPath.substring(strPath.lastIndexOf(92) + 1);
            this.strPath = strPath;
            this.dwType = dwType;
        }

        public String toString() {
            return "VmmRegValue:" + this.strName;
        }

        @Override
        public String getName() {
            return this.strName;
        }

        @Override
        public byte[] getValue() {
            IntByReference lpType = new IntByReference();
            IntByReference lpcbData = new IntByReference();
            boolean f = VmmNative.INSTANCE.VMMDLL_WinReg_QueryValueExU(VmmImpl.this.hVMM, this.strPath, lpType, null, lpcbData);
            if (!f) {
                throw new VmmException();
            }
            byte[] data = new byte[lpcbData.getValue()];
            f = VmmNative.INSTANCE.VMMDLL_WinReg_QueryValueExU(VmmImpl.this.hVMM, this.strPath, lpType, data, lpcbData);
            if (!f) {
                throw new VmmException();
            }
            return data;
        }

        @Override
        public String getValueAsString() {
            return Native.toString((byte[])this.getValue(), (String)"UTF-16LE");
        }

        @Override
        public String getPath() {
            return this.strPath;
        }

        @Override
        public IVmmRegKey getKeyParent() {
            int i = this.strPath.lastIndexOf(92);
            String strParent = this.strPath.substring(0, i);
            if (-1 == strParent.indexOf(92)) {
                return null;
            }
            return new VmmRegKeyImpl(strParent);
        }

        @Override
        public int getValueAsDword() {
            byte[] v = this.getValue();
            if (v.length != 4) {
                throw new VmmException("VmmRegValue not DWORD-sized (4)");
            }
            return ByteBuffer.wrap(v).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }

        @Override
        public int getType() {
            return this.dwType;
        }
    }
}

