/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.comp.base.IntegratedTextAreaComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.SingletonSessionStoreProvider;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.ShellScript;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.app.util.StoreStateFormat;
import io.xpipe.ext.base.service.CustomServiceGroupStore;
import io.xpipe.ext.base.service.ServiceControlStore;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class ServiceControlStoreProvider
implements SingletonSessionStoreProvider,
DataStoreProvider {
    public String displayName(DataStoreEntry entry) {
        ServiceControlStore s = (ServiceControlStore)entry.getStore();
        String n = entry.getName();
        return n + " (" + DataStorage.get().getStoreEntryDisplayName(s.getHost().get()) + ")";
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.SERVICE;
    }

    public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.TUNNEL;
    }

    public DataStoreEntry getSyntheticParent(DataStoreEntry store) {
        ServiceControlStore s = (ServiceControlStore)store.getStore().asNeeded();
        return DataStorage.get().getOrCreateNewSyntheticEntry(s.getHost().get(), "Services", (DataStore)((CustomServiceGroupStore.CustomServiceGroupStoreBuilder)CustomServiceGroupStore.builder().parent(s.getHost())).build());
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        ServiceControlStore st = (ServiceControlStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty host = new SimpleObjectProperty(st.getHost());
        SimpleObjectProperty start = new SimpleObjectProperty((Object)st.getStartScript());
        SimpleObjectProperty stop = new SimpleObjectProperty((Object)st.getStopScript());
        SimpleObjectProperty status = new SimpleObjectProperty((Object)st.getStatusScript());
        SimpleBooleanProperty elevated = new SimpleBooleanProperty(st.isElevated());
        return new OptionsBuilder().nameAndDescription("serviceHost").addComp((Comp)new StoreChoiceComp(StoreChoiceComp.Mode.OTHER, entry, (Property)host, ShellStore.class, null, StoreViewState.get().getAllConnectionsCategory()), (Property)host).nonNull().nameAndDescription("serviceStartScript").addComp((Comp)IntegratedTextAreaComp.script((ObservableValue)host, (Property)start), (Property)start).nonNull().nameAndDescription("serviceStopScript").addComp((Comp)IntegratedTextAreaComp.script((ObservableValue)host, (Property)stop), (Property)stop).nonNull().nameAndDescription("serviceStatusScript").addComp((Comp)IntegratedTextAreaComp.script((ObservableValue)host, (Property)status), (Property)status).nonNull().nameAndDescription("serviceElevated").addToggle((Property)elevated).bind(() -> ((ServiceControlStore.ServiceControlStoreBuilder)((ServiceControlStore.ServiceControlStoreBuilder)((ServiceControlStore.ServiceControlStoreBuilder)((ServiceControlStore.ServiceControlStoreBuilder)((ServiceControlStore.ServiceControlStoreBuilder)ServiceControlStore.builder().host((DataStoreEntryRef<ShellStore>)((DataStoreEntryRef)host.get()))).startScript((ShellScript)start.get())).stopScript((ShellScript)stop.get())).statusScript((ShellScript)status.get())).elevated(elevated.get())).build(), new Property[]{store}).buildDialog();
    }

    public ObservableValue<String> informationString(StoreSection section) {
        ServiceControlStore s = (ServiceControlStore)section.getWrapper().getEntry().getStore().asNeeded();
        return Bindings.createStringBinding(() -> {
            String state = s.isSessionRunning() ? AppI18n.get((String)"active", (Object[])new Object[0]) : (s.isSessionEnabled() ? AppI18n.get((String)"starting", (Object[])new Object[0]) : AppI18n.get((String)"inactive", (Object[])new Object[0]));
            return new StoreStateFormat(null, state, new String[0]).format();
        }, (Observable[])new Observable[]{section.getWrapper().getCache(), AppPrefs.get().language()});
    }

    public String getDisplayIconFileName(DataStore store) {
        return "base:service_icon.svg";
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return ServiceControlStore.builder().build();
    }

    public String getId() {
        return "serviceControl";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(ServiceControlStore.class);
    }
}

