/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.process.ShellScript;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.service.ServiceControlSession;
import lombok.Generated;

@JsonTypeName(value="serviceControl")
@JsonDeserialize(builder=ServiceControlStoreBuilderImpl.class)
public final class ServiceControlStore
implements SingletonSessionStore<ServiceControlSession>,
DataStore {
    private final DataStoreEntryRef<ShellStore> host;
    private final ShellScript startScript;
    private final ShellScript stopScript;
    private final ShellScript statusScript;
    private final boolean elevated;

    public void checkComplete() throws Throwable {
        Validators.nonNull(this.getHost());
        Validators.nonNull((Object)this.getStartScript());
        Validators.nonNull((Object)this.getStopScript());
        Validators.nonNull((Object)this.getStatusScript());
    }

    public ServiceControlSession newSession() {
        return new ServiceControlSession(this);
    }

    public Class<?> getSessionClass() {
        return ServiceControlSession.class;
    }

    @Generated
    protected ServiceControlStore(ServiceControlStoreBuilder<?, ?> b) {
        this.host = b.host;
        this.startScript = b.startScript;
        this.stopScript = b.stopScript;
        this.statusScript = b.statusScript;
        this.elevated = b.elevated;
    }

    @Generated
    public static ServiceControlStoreBuilder<?, ?> builder() {
        return new ServiceControlStoreBuilderImpl();
    }

    @Generated
    public DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public ShellScript getStartScript() {
        return this.startScript;
    }

    @Generated
    public ShellScript getStopScript() {
        return this.stopScript;
    }

    @Generated
    public ShellScript getStatusScript() {
        return this.statusScript;
    }

    @Generated
    public boolean isElevated() {
        return this.elevated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceControlStore)) {
            return false;
        }
        ServiceControlStore other = (ServiceControlStore)o;
        if (this.isElevated() != other.isElevated()) {
            return false;
        }
        DataStoreEntryRef<ShellStore> this$host = this.getHost();
        DataStoreEntryRef<ShellStore> other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        ShellScript this$startScript = this.getStartScript();
        ShellScript other$startScript = other.getStartScript();
        if (this$startScript == null ? other$startScript != null : !this$startScript.equals(other$startScript)) {
            return false;
        }
        ShellScript this$stopScript = this.getStopScript();
        ShellScript other$stopScript = other.getStopScript();
        if (this$stopScript == null ? other$stopScript != null : !this$stopScript.equals(other$stopScript)) {
            return false;
        }
        ShellScript this$statusScript = this.getStatusScript();
        ShellScript other$statusScript = other.getStatusScript();
        return !(this$statusScript == null ? other$statusScript != null : !this$statusScript.equals(other$statusScript));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isElevated() ? 79 : 97);
        DataStoreEntryRef<ShellStore> $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        ShellScript $startScript = this.getStartScript();
        result = result * 59 + ($startScript == null ? 43 : $startScript.hashCode());
        ShellScript $stopScript = this.getStopScript();
        result = result * 59 + ($stopScript == null ? 43 : $stopScript.hashCode());
        ShellScript $statusScript = this.getStatusScript();
        result = result * 59 + ($statusScript == null ? 43 : $statusScript.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServiceControlStore(host=" + String.valueOf(this.getHost()) + ", startScript=" + String.valueOf(this.getStartScript()) + ", stopScript=" + String.valueOf(this.getStopScript()) + ", statusScript=" + String.valueOf(this.getStatusScript()) + ", elevated=" + this.isElevated() + ")";
    }

    @Generated
    public static abstract class ServiceControlStoreBuilder<C extends ServiceControlStore, B extends ServiceControlStoreBuilder<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> host;
        @Generated
        private ShellScript startScript;
        @Generated
        private ShellScript stopScript;
        @Generated
        private ShellScript statusScript;
        @Generated
        private boolean elevated;

        @Generated
        public B host(DataStoreEntryRef<ShellStore> host) {
            this.host = host;
            return this.self();
        }

        @Generated
        public B startScript(ShellScript startScript) {
            this.startScript = startScript;
            return this.self();
        }

        @Generated
        public B stopScript(ShellScript stopScript) {
            this.stopScript = stopScript;
            return this.self();
        }

        @Generated
        public B statusScript(ShellScript statusScript) {
            this.statusScript = statusScript;
            return this.self();
        }

        @Generated
        public B elevated(boolean elevated) {
            this.elevated = elevated;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ServiceControlStore.ServiceControlStoreBuilder(host=" + String.valueOf(this.host) + ", startScript=" + String.valueOf(this.startScript) + ", stopScript=" + String.valueOf(this.stopScript) + ", statusScript=" + String.valueOf(this.statusScript) + ", elevated=" + this.elevated + ")";
        }
    }

    @JsonTypeName(value="serviceControl")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ServiceControlStoreBuilderImpl
    extends ServiceControlStoreBuilder<ServiceControlStore, ServiceControlStoreBuilderImpl> {
        @Generated
        private ServiceControlStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected ServiceControlStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ServiceControlStore build() {
            return new ServiceControlStore(this);
        }
    }
}

