/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.ext.Session;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ShellControl;
import io.xpipe.ext.base.service.ServiceControlStore;
import lombok.Generated;

public class ServiceControlSession
extends Session {
    private final ServiceControlStore store;

    protected ServiceControlSession(ServiceControlStore store) {
        this.store = store;
    }

    private ElevationFunction elevationFunction() {
        return this.store.isElevated() ? ElevationFunction.elevated((String)"service") : ElevationFunction.none();
    }

    public boolean isRunning() {
        return true;
    }

    public void start() throws Exception {
        if (this.isRunning()) {
            this.listener.onStateChange(true);
            return;
        }
        ShellControl session = ((ShellStore)this.store.getHost().getStore()).getOrStartSession();
        CommandBuilder builder = session.getShellDialect().launchAsnyc(CommandBuilder.of().add(new String[]{this.store.getStartScript().getValue()}));
        session.command(builder).elevated(this.elevationFunction()).execute();
        this.listener.onStateChange(true);
    }

    public void stop() throws Exception {
        if (!this.isRunning()) {
            this.listener.onStateChange(false);
            return;
        }
        ShellControl session = ((ShellStore)this.store.getHost().getStore()).getOrStartSession();
        session.command(this.store.getStopScript()).elevated(this.elevationFunction()).execute();
        this.listener.onStateChange(false);
    }

    public boolean checkAlive() {
        return true;
    }

    @Generated
    public ServiceControlStore getStore() {
        return this.store;
    }
}

