/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.hub.comp.StoreCategoryWrapper;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.ext.base.service.AbstractServiceStore;
import io.xpipe.ext.base.service.FixedServiceStoreProvider;
import io.xpipe.ext.base.service.MappedServiceStore;
import io.xpipe.ext.base.service.ServiceProtocolType;
import io.xpipe.ext.base.service.ServiceProtocolTypeHelper;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;

public class MappedServiceStoreProvider
extends FixedServiceStoreProvider {
    @Override
    public String displayName(DataStoreEntry entry) {
        MappedServiceStore s = (MappedServiceStore)entry.getStore().asNeeded();
        return DataStorage.get().getStoreEntryDisplayName(s.getHost().get()) + " - Port " + s.getContainerPort();
    }

    @Override
    protected String formatService(AbstractServiceStore s) {
        MappedServiceStore m = (MappedServiceStore)s;
        String desc = s.getLocalPort() != null ? "localhost:" + s.getLocalPort() + " <- :" + m.getRemotePort() + " <- :" + m.getContainerPort() : (s.isSessionRunning() ? "localhost:" + ((NetworkTunnelSession)s.getSession()).getLocalPort() + " <- :" + m.getRemotePort() + " <- :" + m.getContainerPort() : ":" + m.getRemotePort() + " <- :" + m.getContainerPort());
        return desc;
    }

    @Override
    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        MappedServiceStore st = (MappedServiceStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty host = new SimpleObjectProperty(st.getHost());
        SimpleObjectProperty localPort = new SimpleObjectProperty((Object)st.getLocalPort());
        SimpleObjectProperty serviceProtocolType = new SimpleObjectProperty((Object)st.getServiceProtocolType());
        OptionsBuilder q = new OptionsBuilder().nameAndDescription("serviceHost").addComp((Comp)StoreChoiceComp.other((Property)host, NetworkTunnelStore.class, n -> ((NetworkTunnelStore)n.getStore()).isLocallyTunnelable(), (StoreCategoryWrapper)StoreViewState.get().getAllConnectionsCategory()), (Property)host).nonNull().sub(ServiceProtocolTypeHelper.choice((Property<ServiceProtocolType>)serviceProtocolType), (Property)serviceProtocolType).nonNull().nameAndDescription("serviceRemotePort").addStaticString((Object)(st.getRemotePort() + " <- " + st.getContainerPort())).nameAndDescription("serviceLocalPort").addInteger((Property)localPort).bind(() -> ((MappedServiceStore.MappedServiceStoreBuilder)((MappedServiceStore.MappedServiceStoreBuilder)((MappedServiceStore.MappedServiceStoreBuilder)((MappedServiceStore.MappedServiceStoreBuilder)((MappedServiceStore.MappedServiceStoreBuilder)((MappedServiceStore.MappedServiceStoreBuilder)MappedServiceStore.builder().host((DataStoreEntryRef<NetworkTunnelStore>)((DataStoreEntryRef)host.get()))).displayParent(st.getDisplayParent())).localPort((Integer)localPort.get())).remotePort(st.getRemotePort())).serviceProtocolType((ServiceProtocolType)serviceProtocolType.get())).containerPort(st.getContainerPort())).build(), new Property[]{store});
        return q.buildDialog();
    }

    @Override
    public String getId() {
        return "mappedService";
    }

    @Override
    public List<Class<?>> getStoreClasses() {
        return List.of(MappedServiceStore.class);
    }
}

