/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.ScriptHelper;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.ext.base.script.ScriptStore;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonTypeName(value="script")
@JsonDeserialize(builder=SimpleScriptStoreBuilderImpl.class)
public final class SimpleScriptStore
extends ScriptStore
implements SelfReferentialStore {
    private final ShellDialect minimumDialect;
    private final String commands;
    private final boolean initScript;
    private final boolean shellScript;
    private final boolean fileScript;
    private final boolean runnableScript;

    public String getCommands() {
        return this.commands != null ? this.commands : "";
    }

    public boolean isCompatible(ShellControl shellControl) {
        ShellDialect targetType = shellControl.getOriginalShellDialect();
        return this.minimumDialect == null || this.minimumDialect.isCompatibleTo(targetType);
    }

    public boolean isCompatible(ShellDialect dialect) {
        return this.minimumDialect == null || this.minimumDialect.isCompatibleTo(dialect);
    }

    private String assembleScript(ShellControl shellControl) {
        if (this.isCompatible(shellControl)) {
            boolean shebang = this.getCommands().startsWith("#");
            String fixedCommands = this.getCommands().lines().skip(shebang ? 1L : 0L).collect(Collectors.joining(shellControl.getShellDialect().getNewLine().getNewLineString()));
            ShellDialect targetType = shellControl.getOriginalShellDialect();
            FilePath script = ScriptHelper.createExecScript((ShellDialect)targetType, (ShellControl)shellControl, (String)fixedCommands);
            return targetType.sourceScriptCommand(shellControl, script.toString()) + " " + targetType.getCatchAllVariable();
        }
        return null;
    }

    public String assembleScriptChain(ShellControl shellControl) {
        String nl = shellControl.getShellDialect().getNewLine().getNewLineString();
        SequencedCollection<DataStoreEntryRef<SimpleScriptStore>> all = this.queryFlattenedScripts();
        List<String> r = all.stream().map(ref -> ((SimpleScriptStore)ref.getStore()).assembleScript(shellControl)).filter(s -> s != null).toList();
        if (r.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)nl, r);
    }

    @Override
    public void checkComplete() throws Throwable {
        Validators.nonNull((Object)this.group);
        super.checkComplete();
        if (!(this.initScript || this.shellScript || this.fileScript || this.runnableScript)) {
            throw new ValidationException(AppI18n.get((String)"app.valueMustNotBeEmpty", (Object[])new Object[0]));
        }
    }

    @Override
    public void queryFlattenedScripts(LinkedHashSet<DataStoreEntryRef<SimpleScriptStore>> all) {
        DataStoreEntryRef ref = this.getSelfEntry().ref();
        boolean added = all.add((DataStoreEntryRef<SimpleScriptStore>)ref);
        if (added) {
            this.getEffectiveScripts().stream().filter(scriptStoreDataStoreEntryRef -> !all.contains(scriptStoreDataStoreEntryRef)).forEach(scriptStoreDataStoreEntryRef -> ((ScriptStore)scriptStoreDataStoreEntryRef.getStore()).queryFlattenedScripts(all));
            all.remove(ref);
            all.add((DataStoreEntryRef<SimpleScriptStore>)ref);
        }
    }

    @Override
    public List<DataStoreEntryRef<ScriptStore>> getEffectiveScripts() {
        return this.scripts != null ? this.scripts.stream().filter(Objects::nonNull).filter(ref -> ref.get().getValidity().isUsable()).toList() : List.of();
    }

    @Generated
    protected SimpleScriptStore(SimpleScriptStoreBuilder<?, ?> b) {
        super(b);
        this.minimumDialect = b.minimumDialect;
        this.commands = b.commands;
        this.initScript = b.initScript;
        this.shellScript = b.shellScript;
        this.fileScript = b.fileScript;
        this.runnableScript = b.runnableScript;
    }

    @Generated
    public static SimpleScriptStoreBuilder<?, ?> builder() {
        return new SimpleScriptStoreBuilderImpl();
    }

    @Generated
    public SimpleScriptStoreBuilder<?, ?> toBuilder() {
        return new SimpleScriptStoreBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public ShellDialect getMinimumDialect() {
        return this.minimumDialect;
    }

    @Generated
    public boolean isInitScript() {
        return this.initScript;
    }

    @Generated
    public boolean isShellScript() {
        return this.shellScript;
    }

    @Generated
    public boolean isFileScript() {
        return this.fileScript;
    }

    @Generated
    public boolean isRunnableScript() {
        return this.runnableScript;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleScriptStore)) {
            return false;
        }
        SimpleScriptStore other = (SimpleScriptStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isInitScript() != other.isInitScript()) {
            return false;
        }
        if (this.isShellScript() != other.isShellScript()) {
            return false;
        }
        if (this.isFileScript() != other.isFileScript()) {
            return false;
        }
        if (this.isRunnableScript() != other.isRunnableScript()) {
            return false;
        }
        ShellDialect this$minimumDialect = this.getMinimumDialect();
        ShellDialect other$minimumDialect = other.getMinimumDialect();
        if (this$minimumDialect == null ? other$minimumDialect != null : !this$minimumDialect.equals(other$minimumDialect)) {
            return false;
        }
        String this$commands = this.getCommands();
        String other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !this$commands.equals(other$commands));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleScriptStore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isInitScript() ? 79 : 97);
        result = result * 59 + (this.isShellScript() ? 79 : 97);
        result = result * 59 + (this.isFileScript() ? 79 : 97);
        result = result * 59 + (this.isRunnableScript() ? 79 : 97);
        ShellDialect $minimumDialect = this.getMinimumDialect();
        result = result * 59 + ($minimumDialect == null ? 43 : $minimumDialect.hashCode());
        String $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : $commands.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SimpleScriptStore(super=" + super.toString() + ", minimumDialect=" + String.valueOf(this.getMinimumDialect()) + ", commands=" + this.getCommands() + ", initScript=" + this.isInitScript() + ", shellScript=" + this.isShellScript() + ", fileScript=" + this.isFileScript() + ", runnableScript=" + this.isRunnableScript() + ")";
    }

    @Generated
    public static abstract class SimpleScriptStoreBuilder<C extends SimpleScriptStore, B extends SimpleScriptStoreBuilder<C, B>>
    extends ScriptStore.ScriptStoreBuilder<C, B> {
        @Generated
        private ShellDialect minimumDialect;
        @Generated
        private String commands;
        @Generated
        private boolean initScript;
        @Generated
        private boolean shellScript;
        @Generated
        private boolean fileScript;
        @Generated
        private boolean runnableScript;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SimpleScriptStoreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SimpleScriptStore instance, SimpleScriptStoreBuilder<?, ?> b) {
            b.minimumDialect(instance.minimumDialect);
            b.commands(instance.commands);
            b.initScript(instance.initScript);
            b.shellScript(instance.shellScript);
            b.fileScript(instance.fileScript);
            b.runnableScript(instance.runnableScript);
        }

        @Generated
        public B minimumDialect(ShellDialect minimumDialect) {
            this.minimumDialect = minimumDialect;
            return (B)this.self();
        }

        @Generated
        public B commands(String commands) {
            this.commands = commands;
            return (B)this.self();
        }

        @Generated
        public B initScript(boolean initScript) {
            this.initScript = initScript;
            return (B)this.self();
        }

        @Generated
        public B shellScript(boolean shellScript) {
            this.shellScript = shellScript;
            return (B)this.self();
        }

        @Generated
        public B fileScript(boolean fileScript) {
            this.fileScript = fileScript;
            return (B)this.self();
        }

        @Generated
        public B runnableScript(boolean runnableScript) {
            this.runnableScript = runnableScript;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SimpleScriptStore.SimpleScriptStoreBuilder(super=" + super.toString() + ", minimumDialect=" + String.valueOf(this.minimumDialect) + ", commands=" + this.commands + ", initScript=" + this.initScript + ", shellScript=" + this.shellScript + ", fileScript=" + this.fileScript + ", runnableScript=" + this.runnableScript + ")";
        }
    }

    @JsonTypeName(value="script")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SimpleScriptStoreBuilderImpl
    extends SimpleScriptStoreBuilder<SimpleScriptStore, SimpleScriptStoreBuilderImpl> {
        @Generated
        private SimpleScriptStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected SimpleScriptStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SimpleScriptStore build() {
            return new SimpleScriptStore(this);
        }
    }
}

