/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.EnabledStoreState;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.script.ScriptGroupStore;
import io.xpipe.ext.base.script.SimpleScriptStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import lombok.Generated;

public abstract class ScriptStore
implements DataStore,
StatefulDataStore<EnabledStoreState> {
    protected final DataStoreEntryRef<ScriptGroupStore> group;
    protected final List<DataStoreEntryRef<ScriptStore>> scripts;
    protected final String description;

    public Class<EnabledStoreState> getStateClass() {
        return EnabledStoreState.class;
    }

    public void checkComplete() throws Throwable {
        if (this.group != null) {
            Validators.isType(this.group, ScriptGroupStore.class);
        }
        if (this.scripts != null) {
            Validators.contentNonNull(this.scripts);
        }
    }

    SequencedCollection<DataStoreEntryRef<SimpleScriptStore>> queryFlattenedScripts() {
        LinkedHashSet<DataStoreEntryRef<SimpleScriptStore>> seen = new LinkedHashSet<DataStoreEntryRef<SimpleScriptStore>>();
        this.queryFlattenedScripts(seen);
        return seen;
    }

    protected abstract void queryFlattenedScripts(LinkedHashSet<DataStoreEntryRef<SimpleScriptStore>> var1);

    public abstract List<DataStoreEntryRef<ScriptStore>> getEffectiveScripts();

    @Generated
    protected ScriptStore(ScriptStoreBuilder<?, ?> b) {
        this.group = b.group;
        this.scripts = switch (b.scripts == null ? 0 : b.scripts.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.scripts.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DataStoreEntryRef<ScriptStore>>(b.scripts));
        };
        this.description = b.description;
    }

    @Generated
    public DataStoreEntryRef<ScriptGroupStore> getGroup() {
        return this.group;
    }

    @Generated
    public List<DataStoreEntryRef<ScriptStore>> getScripts() {
        return this.scripts;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ScriptStore(DataStoreEntryRef<ScriptGroupStore> group, List<DataStoreEntryRef<ScriptStore>> scripts, String description) {
        this.group = group;
        this.scripts = scripts;
        this.description = description;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptStore)) {
            return false;
        }
        ScriptStore other = (ScriptStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataStoreEntryRef<ScriptGroupStore> this$group = this.getGroup();
        DataStoreEntryRef<ScriptGroupStore> other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        List<DataStoreEntryRef<ScriptStore>> this$scripts = this.getScripts();
        List<DataStoreEntryRef<ScriptStore>> other$scripts = other.getScripts();
        if (this$scripts == null ? other$scripts != null : !((Object)this$scripts).equals(other$scripts)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScriptStore;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataStoreEntryRef<ScriptGroupStore> $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        List<DataStoreEntryRef<ScriptStore>> $scripts = this.getScripts();
        result = result * 59 + ($scripts == null ? 43 : ((Object)$scripts).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScriptStore(group=" + String.valueOf(this.getGroup()) + ", scripts=" + String.valueOf(this.getScripts()) + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public static abstract class ScriptStoreBuilder<C extends ScriptStore, B extends ScriptStoreBuilder<C, B>> {
        @Generated
        private DataStoreEntryRef<ScriptGroupStore> group;
        @Generated
        private ArrayList<DataStoreEntryRef<ScriptStore>> scripts;
        @Generated
        private String description;

        @Generated
        protected B $fillValuesFrom(C instance) {
            ScriptStoreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ScriptStore instance, ScriptStoreBuilder<?, ?> b) {
            b.group(instance.group);
            b.scripts(instance.scripts == null ? Collections.emptyList() : instance.scripts);
            b.description(instance.description);
        }

        @Generated
        public B group(DataStoreEntryRef<ScriptGroupStore> group) {
            this.group = group;
            return this.self();
        }

        @Generated
        public B script(DataStoreEntryRef<ScriptStore> script) {
            if (this.scripts == null) {
                this.scripts = new ArrayList();
            }
            this.scripts.add(script);
            return this.self();
        }

        @Generated
        public B scripts(Collection<? extends DataStoreEntryRef<ScriptStore>> scripts) {
            if (scripts == null) {
                throw new NullPointerException("scripts cannot be null");
            }
            if (this.scripts == null) {
                this.scripts = new ArrayList();
            }
            this.scripts.addAll(scripts);
            return this.self();
        }

        @Generated
        public B clearScripts() {
            if (this.scripts != null) {
                this.scripts.clear();
            }
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ScriptStore.ScriptStoreBuilder(group=" + String.valueOf(this.group) + ", scripts=" + String.valueOf(this.scripts) + ", description=" + this.description + ")";
        }
    }
}

