/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.action.AbstractAction;
import io.xpipe.app.action.ActionProvider;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.hub.action.BatchHubProvider;
import io.xpipe.app.hub.action.HubBranchProvider;
import io.xpipe.app.hub.action.HubLeafProvider;
import io.xpipe.app.hub.action.HubMenuItemProvider;
import io.xpipe.app.hub.action.StoreAction;
import io.xpipe.app.hub.action.StoreActionCategory;
import io.xpipe.app.hub.action.impl.RefreshActionProvider;
import io.xpipe.app.hub.comp.StoreCategoryConfigComp;
import io.xpipe.app.hub.comp.StoreCategoryWrapper;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.ShellTtyState;
import io.xpipe.app.process.SystemState;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.terminal.ExternalTerminalType;
import io.xpipe.app.util.LabelGraphic;
import io.xpipe.ext.base.script.RunBackgroundScriptActionProvider;
import io.xpipe.ext.base.script.RunHubBatchScriptActionProvider;
import io.xpipe.ext.base.script.RunHubScriptActionProvider;
import io.xpipe.ext.base.script.RunTerminalScriptActionProvider;
import io.xpipe.ext.base.script.ScriptHierarchy;
import io.xpipe.ext.base.script.SimpleScriptStore;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public class RunScriptActionProviderMenu
implements HubBranchProvider<ShellStore>,
BatchHubProvider<ShellStore> {
    public StoreActionCategory getCategory() {
        return StoreActionCategory.CUSTOM;
    }

    public boolean isMajor(DataStoreEntryRef<ShellStore> o) {
        return true;
    }

    public boolean isApplicable(DataStoreEntryRef<ShellStore> o) {
        DataStoreState state = o.get().getStorePersistentState();
        if (state instanceof SystemState) {
            SystemState systemState = (SystemState)state;
            return !(systemState.getShellDialect() != null && !systemState.getShellDialect().getDumbMode().supportsAnyPossibleInteraction() || systemState.getTtyState() != null && systemState.getTtyState() != ShellTtyState.NONE);
        }
        return false;
    }

    public ObservableValue<String> getName(DataStoreEntryRef<ShellStore> store) {
        return AppI18n.observable((String)"runScript", (Object[])new Object[0]);
    }

    public LabelGraphic getIcon(DataStoreEntryRef<ShellStore> store) {
        return new LabelGraphic.IconGraphic("mdi2p-play-box-multiple-outline");
    }

    public Class<ShellStore> getApplicableClass() {
        return ShellStore.class;
    }

    public List<HubMenuItemProvider<?>> getChildren(DataStoreEntryRef<ShellStore> store) {
        SystemState systemState;
        if (Boolean.TRUE.equals(DataStorage.get().getEffectiveCategoryConfig(store.get()).getDontAllowScripts())) {
            return List.of(new ScriptsDisabledActionProvider());
        }
        DataStoreEntryRef replacement = ProcessControlProvider.get().replace(store);
        DataStoreState state = replacement.get().getStorePersistentState();
        if (!(state instanceof SystemState) || (systemState = (SystemState)state).getShellDialect() == null) {
            return List.of(new NoStateActionProvider());
        }
        ScriptHierarchy hierarchy = ScriptHierarchy.buildEnabledHierarchy(ref -> {
            if (!((SimpleScriptStore)ref.getStore()).isRunnableScript()) {
                return false;
            }
            return ((SimpleScriptStore)ref.getStore()).isCompatible(systemState.getShellDialect());
        });
        List<HubMenuItemProvider<?>> list = hierarchy.getChildren().stream().map(c -> new ScriptActionProvider((ScriptHierarchy)c)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return List.of(new NoScriptsActionProvider());
        }
        return list;
    }

    public ObservableValue<String> getName() {
        return AppI18n.observable((String)"runScript", (Object[])new Object[0]);
    }

    public LabelGraphic getIcon() {
        return new LabelGraphic.IconGraphic("mdi2p-play-box-multiple-outline");
    }

    public List<ActionProvider> getChildren(List<DataStoreEntryRef<ShellStore>> batch) {
        if (batch.stream().anyMatch(store -> Boolean.TRUE.equals(DataStorage.get().getEffectiveCategoryConfig(store.get()).getDontAllowScripts()))) {
            return List.of(new ScriptsDisabledActionProvider());
        }
        boolean stateMissing = batch.stream().anyMatch(ref -> {
            DataStoreState state = ref.get().getStorePersistentState();
            if (state instanceof SystemState) {
                SystemState systemState = (SystemState)state;
                if (systemState.getShellDialect() == null) {
                    return true;
                }
                if (systemState.getTtyState() == null || systemState.getTtyState() != ShellTtyState.NONE) {
                    return true;
                }
            }
            return false;
        });
        if (stateMissing) {
            return List.of(new NoStateActionProvider());
        }
        ScriptHierarchy hierarchy = ScriptHierarchy.buildEnabledHierarchy(scriptRef -> {
            boolean compatible = batch.stream().allMatch(ref -> {
                DataStoreState state = ref.get().getStorePersistentState();
                if (state instanceof SystemState) {
                    SystemState systemState = (SystemState)state;
                    return ((SimpleScriptStore)scriptRef.getStore()).isCompatible(systemState.getShellDialect());
                }
                return false;
            });
            if (!compatible) {
                return false;
            }
            return ((SimpleScriptStore)scriptRef.getStore()).isRunnableScript();
        });
        List<ActionProvider> list = hierarchy.getChildren().stream().map(c -> new ScriptActionProvider((ScriptHierarchy)c)).toList();
        if (list.isEmpty()) {
            return List.of(new NoScriptsActionProvider());
        }
        return list;
    }

    private static class ScriptsDisabledActionProvider
    implements HubLeafProvider<ShellStore>,
    BatchHubProvider<ShellStore> {
        private ScriptsDisabledActionProvider() {
        }

        public void execute(DataStoreEntryRef<ShellStore> ref) {
            StoreCategoryWrapper cat = StoreViewState.get().getCategoryWrapper(DataStorage.get().getStoreCategory(ref.get()));
            StoreCategoryConfigComp.show((StoreCategoryWrapper)cat);
        }

        public boolean isApplicable(DataStoreEntryRef<ShellStore> o) {
            return true;
        }

        public ObservableValue<String> getName(DataStoreEntryRef<ShellStore> store) {
            return AppI18n.observable((String)"scriptsDisabled", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon(DataStoreEntryRef<ShellStore> store) {
            return new LabelGraphic.IconGraphic("mdi2b-block-helper");
        }

        public Class<?> getApplicableClass() {
            return ShellStore.class;
        }

        public ObservableValue<String> getName() {
            return AppI18n.observable((String)"scriptsDisabled", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon() {
            return new LabelGraphic.IconGraphic("mdi2b-block-helper");
        }

        public void execute(List<DataStoreEntryRef<ShellStore>> dataStoreEntryRefs) {
            StoreCategoryWrapper cat = StoreViewState.get().getCategoryWrapper(DataStorage.get().getStoreCategory(dataStoreEntryRefs.getFirst().get()));
            StoreCategoryConfigComp.show((StoreCategoryWrapper)cat);
        }
    }

    private static class NoStateActionProvider
    implements HubLeafProvider<ShellStore>,
    BatchHubProvider<ShellStore> {
        private NoStateActionProvider() {
        }

        public boolean isApplicable(DataStoreEntryRef<ShellStore> o) {
            return true;
        }

        public ObservableValue<String> getName(DataStoreEntryRef<ShellStore> store) {
            return AppI18n.observable((String)"noScriptStateAvailable", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon(DataStoreEntryRef<ShellStore> store) {
            return new LabelGraphic.IconGraphic("mdi2i-image-filter-none");
        }

        public Class<?> getApplicableClass() {
            return ShellStore.class;
        }

        public ObservableValue<String> getName() {
            return AppI18n.observable((String)"noScriptStateAvailable", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon() {
            return new LabelGraphic.IconGraphic("mdi2i-image-filter-none");
        }

        public StoreAction<ShellStore> createBatchAction(DataStoreEntryRef<ShellStore> ref) {
            return ((RefreshActionProvider.Action.ActionBuilder)RefreshActionProvider.Action.builder().ref(ref.asNeeded())).build().asNeeded();
        }

        public StoreAction<ShellStore> createAction(DataStoreEntryRef<ShellStore> ref) {
            return ((RefreshActionProvider.Action.ActionBuilder)RefreshActionProvider.Action.builder().ref(ref.asNeeded())).build().asNeeded();
        }
    }

    private static class NoScriptsActionProvider
    implements HubLeafProvider<ShellStore>,
    BatchHubProvider<ShellStore> {
        private NoScriptsActionProvider() {
        }

        public void execute(DataStoreEntryRef<ShellStore> ref) {
            StoreCategoryWrapper cat = StoreViewState.get().getAllScriptsCategory();
            cat.select();
        }

        public boolean isApplicable(DataStoreEntryRef<ShellStore> o) {
            return true;
        }

        public ObservableValue<String> getName(DataStoreEntryRef<ShellStore> store) {
            return AppI18n.observable((String)"noScriptsAvailable", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon(DataStoreEntryRef<ShellStore> store) {
            return new LabelGraphic.IconGraphic("mdi2i-image-filter-none");
        }

        public Class<?> getApplicableClass() {
            return ShellStore.class;
        }

        public ObservableValue<String> getName() {
            return AppI18n.observable((String)"noScriptsAvailable", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon() {
            return new LabelGraphic.IconGraphic("mdi2i-image-filter-none");
        }

        public void execute(List<DataStoreEntryRef<ShellStore>> dataStoreEntryRefs) {
            StoreCategoryWrapper cat = StoreViewState.get().getAllScriptsCategory();
            cat.select();
        }
    }

    private static final class ScriptActionProvider
    implements HubBranchProvider<ShellStore>,
    BatchHubProvider<ShellStore> {
        private final ScriptHierarchy hierarchy;

        public ObservableValue<String> getName() {
            return new SimpleStringProperty(this.hierarchy.getBase().get().getName());
        }

        public LabelGraphic getIcon() {
            if (this.hierarchy.isLeaf()) {
                return new LabelGraphic.ImageGraphic(this.hierarchy.getBase().get().getEffectiveIconFile(), 16);
            }
            return new LabelGraphic.IconGraphic("mdi2p-play-box-multiple-outline");
        }

        public List<? extends ActionProvider> getChildren(List<DataStoreEntryRef<ShellStore>> batch) {
            return this.getChildren();
        }

        public boolean isApplicable(DataStoreEntryRef<ShellStore> o) {
            return true;
        }

        public ObservableValue<String> getName(DataStoreEntryRef<ShellStore> store) {
            return this.getName();
        }

        public LabelGraphic getIcon(DataStoreEntryRef<ShellStore> store) {
            return this.getIcon();
        }

        public Class<ShellStore> getApplicableClass() {
            return ShellStore.class;
        }

        public List<HubMenuItemProvider<?>> getChildren(DataStoreEntryRef<ShellStore> store) {
            return this.getChildren();
        }

        private List<HubMenuItemProvider<?>> getChildren() {
            if (this.hierarchy.isLeaf()) {
                return List.of(new TerminalRunActionProvider(this.hierarchy), new HubRunActionProvider(this.hierarchy), new BackgroundRunActionProvider(this.hierarchy));
            }
            return this.hierarchy.getChildren().stream().map(c -> new ScriptActionProvider((ScriptHierarchy)c)).collect(Collectors.toList());
        }

        @Generated
        public ScriptActionProvider(ScriptHierarchy hierarchy) {
            this.hierarchy = hierarchy;
        }

        @Generated
        public ScriptHierarchy getHierarchy() {
            return this.hierarchy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScriptActionProvider)) {
                return false;
            }
            ScriptActionProvider other = (ScriptActionProvider)o;
            ScriptHierarchy this$hierarchy = this.getHierarchy();
            ScriptHierarchy other$hierarchy = other.getHierarchy();
            return !(this$hierarchy == null ? other$hierarchy != null : !((Object)this$hierarchy).equals(other$hierarchy));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScriptHierarchy $hierarchy = this.getHierarchy();
            result = result * 59 + ($hierarchy == null ? 43 : ((Object)$hierarchy).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RunScriptActionProviderMenu.ScriptActionProvider(hierarchy=" + String.valueOf(this.getHierarchy()) + ")";
        }
    }

    private static final class BackgroundRunActionProvider
    implements HubLeafProvider<ShellStore>,
    BatchHubProvider<ShellStore> {
        private final ScriptHierarchy hierarchy;

        public AbstractAction createAction(DataStoreEntryRef<ShellStore> ref) {
            return ((RunBackgroundScriptActionProvider.Action.ActionBuilder)((Object)((RunBackgroundScriptActionProvider.Action.ActionBuilder)RunBackgroundScriptActionProvider.Action.builder().ref(ref)).scriptStore(this.hierarchy.getLeafBase()))).build();
        }

        public boolean isApplicable(DataStoreEntryRef<ShellStore> o) {
            return true;
        }

        public ObservableValue<String> getName(DataStoreEntryRef<ShellStore> store) {
            return AppI18n.observable((String)"executeInBackground", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon(DataStoreEntryRef<ShellStore> store) {
            return new LabelGraphic.IconGraphic("mdi2f-flip-to-back");
        }

        public Class<?> getApplicableClass() {
            return ShellStore.class;
        }

        public ObservableValue<String> getName() {
            return AppI18n.observable((String)"executeInBackground", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon() {
            return new LabelGraphic.IconGraphic("mdi2f-flip-to-back");
        }

        public RunBackgroundScriptActionProvider.Action createBatchAction(DataStoreEntryRef<ShellStore> ref) {
            return ((RunBackgroundScriptActionProvider.Action.ActionBuilder)((Object)((RunBackgroundScriptActionProvider.Action.ActionBuilder)RunBackgroundScriptActionProvider.Action.builder().ref(ref)).scriptStore(this.hierarchy.getLeafBase()))).build();
        }

        public List<ActionProvider> getChildren(List<DataStoreEntryRef<ShellStore>> batch) {
            return List.of();
        }

        @Generated
        public BackgroundRunActionProvider(ScriptHierarchy hierarchy) {
            this.hierarchy = hierarchy;
        }

        @Generated
        public ScriptHierarchy getHierarchy() {
            return this.hierarchy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BackgroundRunActionProvider)) {
                return false;
            }
            BackgroundRunActionProvider other = (BackgroundRunActionProvider)o;
            ScriptHierarchy this$hierarchy = this.getHierarchy();
            ScriptHierarchy other$hierarchy = other.getHierarchy();
            return !(this$hierarchy == null ? other$hierarchy != null : !((Object)this$hierarchy).equals(other$hierarchy));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScriptHierarchy $hierarchy = this.getHierarchy();
            result = result * 59 + ($hierarchy == null ? 43 : ((Object)$hierarchy).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RunScriptActionProviderMenu.BackgroundRunActionProvider(hierarchy=" + String.valueOf(this.getHierarchy()) + ")";
        }
    }

    private static final class HubRunActionProvider
    implements HubLeafProvider<ShellStore>,
    BatchHubProvider<ShellStore> {
        private final ScriptHierarchy hierarchy;

        public AbstractAction createAction(DataStoreEntryRef<ShellStore> ref) {
            return ((RunHubScriptActionProvider.Action.ActionBuilder)((Object)((RunHubScriptActionProvider.Action.ActionBuilder)RunHubScriptActionProvider.Action.builder().ref(ref)).scriptStore(this.hierarchy.getLeafBase()))).build();
        }

        public boolean isApplicable(DataStoreEntryRef<ShellStore> o) {
            return true;
        }

        public ObservableValue<String> getName(DataStoreEntryRef<ShellStore> store) {
            return AppI18n.observable((String)"runInConnectionHub", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon(DataStoreEntryRef<ShellStore> store) {
            return new LabelGraphic.IconGraphic("mdal-desktop_mac");
        }

        public Class<?> getApplicableClass() {
            return ShellStore.class;
        }

        public ObservableValue<String> getName() {
            return AppI18n.observable((String)"runInConnectionHub", (Object[])new Object[0]);
        }

        public LabelGraphic getIcon() {
            return new LabelGraphic.IconGraphic("mdal-desktop_mac");
        }

        public AbstractAction createBatchAction(List<DataStoreEntryRef<ShellStore>> stores) {
            return ((RunHubBatchScriptActionProvider.Action.ActionBuilder)((Object)((RunHubBatchScriptActionProvider.Action.ActionBuilder)RunHubBatchScriptActionProvider.Action.builder().refs(stores)).scriptStore(this.hierarchy.getLeafBase()))).build();
        }

        public RunHubScriptActionProvider.Action createBatchAction(DataStoreEntryRef<ShellStore> ref) {
            return ((RunHubScriptActionProvider.Action.ActionBuilder)((Object)((RunHubScriptActionProvider.Action.ActionBuilder)RunHubScriptActionProvider.Action.builder().ref(ref)).scriptStore(this.hierarchy.getLeafBase()))).build();
        }

        @Generated
        public HubRunActionProvider(ScriptHierarchy hierarchy) {
            this.hierarchy = hierarchy;
        }

        @Generated
        public ScriptHierarchy getHierarchy() {
            return this.hierarchy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HubRunActionProvider)) {
                return false;
            }
            HubRunActionProvider other = (HubRunActionProvider)o;
            ScriptHierarchy this$hierarchy = this.getHierarchy();
            ScriptHierarchy other$hierarchy = other.getHierarchy();
            return !(this$hierarchy == null ? other$hierarchy != null : !((Object)this$hierarchy).equals(other$hierarchy));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScriptHierarchy $hierarchy = this.getHierarchy();
            result = result * 59 + ($hierarchy == null ? 43 : ((Object)$hierarchy).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RunScriptActionProviderMenu.HubRunActionProvider(hierarchy=" + String.valueOf(this.getHierarchy()) + ")";
        }
    }

    private static final class TerminalRunActionProvider
    implements HubLeafProvider<ShellStore>,
    BatchHubProvider<ShellStore> {
        private final ScriptHierarchy hierarchy;

        public AbstractAction createAction(DataStoreEntryRef<ShellStore> ref) {
            return ((RunTerminalScriptActionProvider.Action.ActionBuilder)((Object)((RunTerminalScriptActionProvider.Action.ActionBuilder)RunTerminalScriptActionProvider.Action.builder().ref(ref)).scriptStore(this.hierarchy.getLeafBase()))).build();
        }

        public boolean isApplicable(DataStoreEntryRef<ShellStore> o) {
            return true;
        }

        public ObservableValue<String> getName(DataStoreEntryRef<ShellStore> store) {
            ExternalTerminalType t = (ExternalTerminalType)AppPrefs.get().terminalType().getValue();
            return AppI18n.observable((String)"executeInTerminal", (Object[])new Object[]{t != null ? t.toTranslatedString().getValue() : "?"});
        }

        public LabelGraphic getIcon(DataStoreEntryRef<ShellStore> store) {
            return new LabelGraphic.IconGraphic("mdi2c-code-greater-than");
        }

        public Class<?> getApplicableClass() {
            return ShellStore.class;
        }

        public ObservableValue<String> getName() {
            ExternalTerminalType t = (ExternalTerminalType)AppPrefs.get().terminalType().getValue();
            return AppI18n.observable((String)"executeInTerminal", (Object[])new Object[]{t != null ? t.toTranslatedString().getValue() : "?"});
        }

        public LabelGraphic getIcon() {
            return new LabelGraphic.IconGraphic("mdi2c-code-greater-than");
        }

        public RunTerminalScriptActionProvider.Action createBatchAction(DataStoreEntryRef<ShellStore> ref) {
            return ((RunTerminalScriptActionProvider.Action.ActionBuilder)((Object)((RunTerminalScriptActionProvider.Action.ActionBuilder)RunTerminalScriptActionProvider.Action.builder().ref(ref)).scriptStore(this.hierarchy.getLeafBase()))).build();
        }

        @Generated
        public TerminalRunActionProvider(ScriptHierarchy hierarchy) {
            this.hierarchy = hierarchy;
        }

        @Generated
        public ScriptHierarchy getHierarchy() {
            return this.hierarchy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TerminalRunActionProvider)) {
                return false;
            }
            TerminalRunActionProvider other = (TerminalRunActionProvider)o;
            ScriptHierarchy this$hierarchy = this.getHierarchy();
            ScriptHierarchy other$hierarchy = other.getHierarchy();
            return !(this$hierarchy == null ? other$hierarchy != null : !((Object)this$hierarchy).equals(other$hierarchy));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScriptHierarchy $hierarchy = this.getHierarchy();
            result = result * 59 + ($hierarchy == null ? 43 : ((Object)$hierarchy).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RunScriptActionProviderMenu.TerminalRunActionProvider(hierarchy=" + String.valueOf(this.getHierarchy()) + ")";
        }
    }
}

