/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.base.TextFieldComp;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.util.LocalShell;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.control.TextField;
import lombok.Generated;

@JsonTypeName(value="pageant")
@JsonDeserialize(builder=PageantStrategyBuilder.class)
public final class PageantStrategy
implements SshIdentityStrategy {
    private static Boolean supported;
    private final boolean forwardAgent;
    private final String publicKey;

    public static OptionsBuilder createOptions(Property<PageantStrategy> p, SshIdentityStrategyChoiceConfig config) {
        SimpleBooleanProperty forward = new SimpleBooleanProperty(p.getValue() != null && ((PageantStrategy)p.getValue()).isForwardAgent());
        SimpleStringProperty publicKey = new SimpleStringProperty(p.getValue() != null ? ((PageantStrategy)p.getValue()).getPublicKey() : null);
        return new OptionsBuilder().nameAndDescription("forwardAgent").addToggle((Property)forward).nonNull().hide(!config.isAllowAgentForward()).nameAndDescription("publicKey").addComp(new TextFieldComp((Property)publicKey).apply(struc -> ((TextField)struc.get()).setPromptText("ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAIBmhLUTJiP...== Your Comment")), (Property)publicKey).bind(() -> new PageantStrategy(forward.get(), publicKey.get()), new Property[]{p});
    }

    public static boolean isSupported() {
        if (supported != null) {
            return supported;
        }
        if (OsType.getLocal() == OsType.WINDOWS) {
            return true;
        }
        try {
            boolean found = LocalShell.getShell().view().findProgram("pageant").isPresent();
            supported = found;
            return supported;
        }
        catch (Exception ex) {
            supported = false;
            return supported;
        }
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        if (parent.getOsType() != OsType.WINDOWS) {
            String out = parent.executeSimpleStringCommand("pageant -l");
            if (out.isBlank()) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Pageant is not running or has no identities"));
            }
            FilePath socket = (FilePath)AppPrefs.get().defaultSshAgentSocket().getValue();
            if (socket == null || !socket.toString().contains("pageant")) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Pageant is not running as the primary agent via the $SSH_AUTH_SOCK variable."));
            }
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
        builder.environment("SSH_AUTH_SOCK", parent -> {
            if (parent.getOsType() == OsType.WINDOWS) {
                return this.getPageantWindowsPipe(parent);
            }
            return null;
        });
    }

    @Override
    public List<KeyValue> configOptions() {
        Optional<FilePath> file = SshIdentityStrategy.getPublicKeyPath(this.publicKey);
        return List.of(new KeyValue("IdentitiesOnly", file.isPresent() ? "yes" : "no"), new KeyValue("ForwardAgent", this.forwardAgent ? "yes" : "no"), new KeyValue("IdentityFile", file.isPresent() ? file.get().toString() : "none"), new KeyValue("PKCS11Provider", "none"));
    }

    private String getPageantWindowsPipe(ShellControl parent) throws Exception {
        String name = (String)parent.enforceDialect(ShellDialects.POWERSHELL, powershell -> {
            String pipe = powershell.executeSimpleStringCommand("Get-ChildItem \"\\\\.\\pipe\\\" -recurse | Where-Object {$_.Name -match \"pageant\"} | foreach {echo $_.Name}");
            List<String> lines = pipe.lines().toList();
            if (lines.isEmpty()) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Pageant is not running"));
            }
            if (lines.size() > 1) {
                String uname = powershell.getShellDialect().printUsernameCommand(powershell).readStdoutOrThrow();
                return lines.stream().filter(s -> s.contains(uname)).findFirst().orElse(lines.getFirst());
            }
            return lines.getFirst();
        });
        String file = "\\\\.\\pipe\\" + name;
        return file;
    }

    @Generated
    PageantStrategy(boolean forwardAgent, String publicKey) {
        this.forwardAgent = forwardAgent;
        this.publicKey = publicKey;
    }

    @Generated
    public static PageantStrategyBuilder builder() {
        return new PageantStrategyBuilder();
    }

    @Generated
    public boolean isForwardAgent() {
        return this.forwardAgent;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageantStrategy)) {
            return false;
        }
        PageantStrategy other = (PageantStrategy)o;
        if (this.isForwardAgent() != other.isForwardAgent()) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForwardAgent() ? 79 : 97);
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageantStrategy(forwardAgent=" + this.isForwardAgent() + ", publicKey=" + this.getPublicKey() + ")";
    }

    @JsonTypeName(value="pageant")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class PageantStrategyBuilder {
        @Generated
        private boolean forwardAgent;
        @Generated
        private String publicKey;

        @Generated
        PageantStrategyBuilder() {
        }

        @Generated
        public PageantStrategyBuilder forwardAgent(boolean forwardAgent) {
            this.forwardAgent = forwardAgent;
            return this;
        }

        @Generated
        public PageantStrategyBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public PageantStrategy build() {
            return new PageantStrategy(this.forwardAgent, this.publicKey);
        }

        @Generated
        public String toString() {
            return "PageantStrategy.PageantStrategyBuilder(forwardAgent=" + this.forwardAgent + ", publicKey=" + this.publicKey + ")";
        }
    }
}

