/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStorageSyncHandler;
import io.xpipe.app.storage.DataStorageUserHandler;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.EncryptedValue;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.app.util.OptionsChoiceBuilder;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.SecretRetrievalStrategyHelper;
import io.xpipe.app.util.Validator;
import io.xpipe.ext.base.identity.IdentityStoreProvider;
import io.xpipe.ext.base.identity.SyncedIdentityStore;
import io.xpipe.ext.base.identity.ssh.KeyFileStrategy;
import io.xpipe.ext.base.identity.ssh.NoneStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;

public class SyncedIdentityStoreProvider
extends IdentityStoreProvider {
    @Override
    public DataStoreCreationCategory getCreationCategory() {
        return DataStorage.get().supportsSync() ? DataStoreCreationCategory.IDENTITY : null;
    }

    public UUID getTargetCategory(DataStore store, UUID target) {
        DataStoreCategory cat = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(target).orElseThrow();
        boolean inSynced = DataStorage.get().getCategoryParentHierarchy(cat).stream().anyMatch(dataStoreCategory -> dataStoreCategory.getUuid() == DataStorage.SYNCED_IDENTITIES_CATEGORY_UUID);
        return inSynced ? target : DataStorage.SYNCED_IDENTITIES_CATEGORY_UUID;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        SyncedIdentityStore st = (SyncedIdentityStore)store.getValue();
        SimpleStringProperty user = new SimpleStringProperty(st.getUsername().get());
        SimpleObjectProperty pass = new SimpleObjectProperty((Object)st.getPassword());
        SimpleObjectProperty identity = new SimpleObjectProperty((Object)st.getSshIdentity());
        SimpleBooleanProperty perUser = new SimpleBooleanProperty(st.isPerUser());
        perUser.addListener((observable, oldValue, newValue) -> {
            KeyFileStrategy f;
            Object patt0$temp = identity.getValue();
            if (!(patt0$temp instanceof KeyFileStrategy) || (f = (KeyFileStrategy)patt0$temp).getFile() == null || !f.getFile().isInDataDirectory()) {
                return;
            }
            Path source = Path.of(f.getFile().toAbsoluteFilePath(null).toString(), new String[0]);
            Path target = Path.of("keys", f.getFile().toAbsoluteFilePath(null).getFileName());
            DataStorageSyncHandler.getInstance().addDataFile(source, target, newValue.booleanValue());
            Path pub = Path.of(String.valueOf(source) + ".pub", new String[0]);
            Path pubTarget = Path.of("keys", f.getFile().toAbsoluteFilePath(null).getFileName() + ".pub");
            if (Files.exists(pub, new LinkOption[0])) {
                DataStorageSyncHandler.getInstance().addDataFile(pub, pubTarget, newValue.booleanValue());
            }
        });
        SshIdentityStrategyChoiceConfig sshIdentityChoiceConfig = SshIdentityStrategyChoiceConfig.builder().allowAgentForward(true).proxy((Property<DataStoreEntryRef<ShellStore>>)new ReadOnlyObjectWrapper((Object)DataStorage.get().local().ref())).allowKeyFileSync(true).perUserKeyFileCheck(() -> perUser.get()).build();
        return new OptionsBuilder().nameAndDescription("username").addString((Property)user).name("passwordAuthentication").description("passwordAuthenticationDescription").sub(SecretRetrievalStrategyHelper.comp((Property)pass, (boolean)true), (Property)pass).name("keyAuthentication").description("keyAuthenticationDescription").longDescription(DocumentationLink.SSH_KEYS).sub(OptionsChoiceBuilder.builder().allowNull(false).property((Property)identity).customConfiguration((Object)sshIdentityChoiceConfig).available(SshIdentityStrategy.getSubclasses()).build().build(), (Property)identity).check(val -> Validator.create((Validator)val, (ObservableValue)AppI18n.observable((String)"keyNotSynced", (Object[])new Object[0]), (ObservableValue)identity, i -> {
            KeyFileStrategy f;
            boolean wrong = i instanceof KeyFileStrategy && (f = (KeyFileStrategy)i).getFile() != null && !f.getFile().isInDataDirectory();
            return !wrong;
        })).nameAndDescription(DataStorageUserHandler.getInstance().getActiveUser() != null ? "identityPerUser" : "identityPerUserDisabled").addToggle((Property)perUser).disable(DataStorageUserHandler.getInstance().getActiveUser() == null).bind(() -> ((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)SyncedIdentityStore.builder().username(user.get())).password((EncryptedValue.VaultKey<SecretRetrievalStrategy>)(st.getEncryptedPassword() != null ? st.getEncryptedPassword().withValue((Object)((SecretRetrievalStrategy)pass.get())) : EncryptedValue.VaultKey.of((Object)((SecretRetrievalStrategy)pass.get()))))).sshIdentity((EncryptedValue.VaultKey<SshIdentityStrategy>)(st.getEncryptedSshIdentity() != null ? st.getEncryptedSshIdentity().withValue((Object)((SshIdentityStrategy)identity.get())) : EncryptedValue.VaultKey.of((Object)((SshIdentityStrategy)identity.get()))))).password((EncryptedValue.VaultKey<SecretRetrievalStrategy>)EncryptedValue.VaultKey.of((Object)((SecretRetrievalStrategy)pass.get())))).sshIdentity((EncryptedValue.VaultKey<SshIdentityStrategy>)EncryptedValue.VaultKey.of((Object)((SshIdentityStrategy)identity.get())))).perUser(perUser.get())).build(), new Property[]{store}).buildDialog();
    }

    public String summaryString(StoreEntryWrapper wrapper) {
        return wrapper.getEntry().isPerUserStore() ? AppI18n.get((String)"userIdentity", (Object[])new Object[0]) : AppI18n.get((String)"globalIdentity", (Object[])new Object[0]);
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return ((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)SyncedIdentityStore.builder().password((EncryptedValue.VaultKey<SecretRetrievalStrategy>)EncryptedValue.VaultKey.of((Object)new SecretRetrievalStrategy.None()))).sshIdentity((EncryptedValue.VaultKey<SshIdentityStrategy>)EncryptedValue.VaultKey.of((Object)new NoneStrategy()))).perUser(false)).build();
    }

    public String getId() {
        return "syncedIdentity";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(SyncedIdentityStore.class);
    }
}

