/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;

public class IdentityMigrationDeserializer
extends DelegatingDeserializer {
    public IdentityMigrationDeserializer(JsonDeserializer<?> d) {
        super(d);
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new IdentityMigrationDeserializer(newDelegatee);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return super.deserialize(this.restructure(p), ctxt);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object intoValue) throws IOException {
        return super.deserialize(this.restructure(p), ctxt, intoValue);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return super.deserializeWithType(this.restructure(jp), ctxt, typeDeserializer);
    }

    public JsonParser restructure(JsonParser p) throws IOException {
        TreeNode node = p.readValueAsTree();
        if (node == null) {
            return p;
        }
        if (!node.isObject()) {
            TreeTraversingParser newJsonParser = new TreeTraversingParser((JsonNode)((ObjectNode)node), p.getCodec());
            newJsonParser.nextToken();
            return newJsonParser;
        }
        this.migrate((ObjectNode)node);
        TreeTraversingParser newJsonParser = new TreeTraversingParser((JsonNode)((ObjectNode)node), p.getCodec());
        newJsonParser.nextToken();
        return newJsonParser;
    }

    private void migrate(ObjectNode containerNode) {
        JsonNode additional;
        JsonNode vmIdentity;
        JsonNode user = containerNode.get("user");
        JsonNode password = containerNode.get("password");
        JsonNode identity = containerNode.get("identityStrategy");
        if (identity == null && (vmIdentity = containerNode.get("identity")) != null && !vmIdentity.has("username")) {
            identity = vmIdentity;
        }
        if (identity == null && (additional = containerNode.get("additionalIdentity")) != null) {
            identity = additional;
        }
        if (user == null) {
            user = containerNode.get("username");
        }
        if (password != null && password.isObject() && identity != null && identity.isObject()) {
            identityStore = JsonNodeFactory.instance.objectNode();
            identityStore.put("type", "localIdentity");
            if (user != null && user.isTextual()) {
                identityStore.set("username", user);
            }
            identityStore.set("password", password);
            identityStore.set("sshIdentity", identity);
            ObjectNode inPlace = JsonNodeFactory.instance.objectNode();
            inPlace.put("type", "inPlace");
            inPlace.set("identityStore", (JsonNode)identityStore);
            containerNode.set("identity", (JsonNode)inPlace);
        } else if (password != null) {
            identityStore = JsonNodeFactory.instance.objectNode();
            identityStore.put("type", "localIdentity");
            if (user != null && user.isTextual()) {
                identityStore.set("username", user);
            }
            identityStore.set("password", password);
            ObjectNode inPlace = JsonNodeFactory.instance.objectNode();
            inPlace.put("type", "inPlace");
            inPlace.set("identityStore", (JsonNode)identityStore);
            containerNode.set("identity", (JsonNode)inPlace);
        }
    }
}

