/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.wsl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ParentSystemAccess;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.BaseElevationHandler;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.ext.base.identity.IdentityValue;
import java.util.Objects;
import java.util.OptionalInt;
import lombok.Generated;
import lombok.NonNull;

@JsonTypeName(value="wsl")
@JsonDeserialize(builder=b.class)
public final class e
implements FixedChildStore,
NameableStore,
ShellStore,
StatefulDataStore<ShellStoreState> {
    private final DataStoreEntryRef<io.xpipe.ext.proc.wsl.b> host;
    private final String distribution;
    private final IdentityValue identity;

    public final Class<ShellStoreState> getStateClass() {
        return ShellStoreState.class;
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.distribution));
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (e)fixedChildStore;
        return ((a)this.toBuilder().identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    public final void checkComplete() {
        Validators.nonNull(this.host);
        Validators.isType(this.host, io.xpipe.ext.proc.wsl.b.class);
        this.host.checkComplete();
        Validators.nonNull((Object)this.distribution);
        if (this.identity != null) {
            this.identity.checkComplete();
        }
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(){

            public final ShellControl control(ShellControl shellControl) {
                ShellOpenFunction shellOpenFunction = new ShellOpenFunction(this){
                    private /* synthetic */ 1 hc;
                    {
                        this.hc = var1_1;
                    }

                    public final CommandBuilder prepareWithoutInitCommand() {
                        return this.hc.e.this.createCommand();
                    }

                    public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                        if (string == null) {
                            throw new NullPointerException("command is marked non-null but is null");
                        }
                        CommandBuilder commandBuilder = this.hc.e.this.createCommand();
                        commandBuilder.add(new String[]{string});
                        return commandBuilder;
                    }
                };
                shellControl = shellControl.subShell();
                shellControl.setDumbOpen(shellOpenFunction);
                shellControl.setTerminalOpen(shellOpenFunction);
                if (e.this.identity != null && e.this.identity.unwrap().getPassword() != null) {
                    shellControl.setElevationHandler(new BaseElevationHandler((DataStore)e.this, e.this.identity.unwrap().getPassword()).orElse(shellControl.getElevationHandler()));
                }
                shellControl.withSourceStore((DataStore)e.this);
                shellControl.withShellStateInit((StatefulDataStore)e.this);
                shellControl.withShellStateFail((StatefulDataStore)e.this);
                shellControl.setParentSystemAccess(new ParentSystemAccess(this){
                    private /* synthetic */ 1 hc;
                    {
                        this.hc = var1_1;
                    }

                    public final boolean supportsSameUsers() {
                        return false;
                    }

                    public final boolean supportsFileSystemAccess() {
                        return true;
                    }

                    public final boolean supportsExecutables() {
                        Object object = this.hc.e.this.getOrStartSession();
                        try {
                            object = object.view().readTextFile(FilePath.of((String)"/proc/sys/fs/binfmt_misc/WSLInterop"));
                            return !object.startsWith("disabled");
                        }
                        catch (Exception exception) {
                            object = exception;
                            ErrorEventFactory.fromThrowable((Throwable)exception).omit().handle();
                            return true;
                        }
                    }

                    public final boolean supportsExecutableEnvironment() {
                        return false;
                    }

                    public final FilePath translateFromLocalSystemPath(FilePath filePath) {
                        ShellControl shellControl = this.hc.e.this.getOrStartSession();
                        return FilePath.of((String)shellControl.command(CommandBuilder.of().add(new String[]{"wslpath", "-u"}).addFile(filePath)).readStdoutOrThrow());
                    }

                    public final FilePath translateToLocalSystemPath(FilePath filePath) {
                        ShellControl shellControl = this.hc.e.this.getOrStartSession();
                        return FilePath.of((String)shellControl.command(CommandBuilder.of().add(new String[]{"wslpath", "-w"}).addFile(filePath)).readStdoutOrThrow());
                    }

                    public final boolean isIdentity() {
                        return false;
                    }
                });
                return shellControl;
            }

            public final ShellStore getParentStore() {
                return (ShellStore)((io.xpipe.ext.proc.wsl.b)e.this.getHost().getStore()).getHost().getStore();
            }
        };
    }

    public final CommandBuilder createCommand() {
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"wsl"});
        if (this.identity != null && this.identity.unwrap().getUsername().hasUser()) {
            commandBuilder.add(new String[]{"-u"});
            commandBuilder.add(new String[]{this.identity.unwrap().getUsername().retrieveUsername()});
        }
        if (this.distribution != null) {
            commandBuilder.add(new String[]{"--distribution"});
            commandBuilder.add(new String[]{this.distribution});
        }
        return commandBuilder;
    }

    public final String getName() {
        return this.distribution;
    }

    @Generated
    protected e(a<?, ?> a2) {
        this.host = a2.host;
        this.distribution = a2.distribution;
        this.identity = a2.identity;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<io.xpipe.ext.proc.wsl.b> getHost() {
        return this.host;
    }

    @Generated
    public final String getDistribution() {
        return this.distribution;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof e)) {
            return false;
        }
        object = (e)object;
        Object object2 = this.getHost();
        Object object3 = ((e)object).getHost();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getDistribution();
        object3 = ((e)object).getDistribution();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getIdentity();
        object = ((e)object).getIdentity();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<io.xpipe.ext.proc.wsl.b> dataStoreEntryRef = this.getHost();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        String string = this.getDistribution();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        string = this.getIdentity();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "WslInstanceStore(host=" + String.valueOf(this.getHost()) + ", distribution=" + this.getDistribution() + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public static abstract class a<C extends e, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<io.xpipe.ext.proc.wsl.b> host;
        @Generated
        private String distribution;
        @Generated
        private IdentityValue identity;

        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(e e2, a<?, ?> a2) {
            a2.host(e2.host);
            a2.distribution(e2.distribution);
            a2.identity(e2.identity);
        }

        @Generated
        public B host(DataStoreEntryRef<io.xpipe.ext.proc.wsl.b> dataStoreEntryRef) {
            this.host = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B distribution(String string) {
            this.distribution = string;
            return this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "WslInstanceStore.WslInstanceStoreBuilder(host=" + String.valueOf(this.host) + ", distribution=" + this.distribution + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="wsl")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<e, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final e build() {
            return new e(this);
        }
    }
}

