/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.vnc;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.browser.BrowserFullSessionModel;
import io.xpipe.app.browser.BrowserStoreSessionTab;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.ext.UserScopeStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.HostHelper;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.Validators;
import io.xpipe.app.vnc.VncBaseStore;
import io.xpipe.ext.base.desktop.DesktopApplicationStore;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.IdentityValue;
import java.util.List;
import lombok.Generated;

@JsonTypeName(value="vnc")
@JsonDeserialize(builder=b.class)
public final class i
implements DataStore,
SelfReferentialStore,
SingletonSessionStore<NetworkTunnelSession>,
UserScopeStore,
VncBaseStore,
DesktopBaseStore {
    private final DataStoreEntryRef<NetworkTunnelStore> tunnelHost;
    private final DataStoreEntryRef<ShellStore> system;
    private final Integer port;
    private final IdentityValue identity;

    public final void checkComplete() {
        Validators.nonNull(this.tunnelHost);
        Validators.isType(this.tunnelHost, NetworkTunnelStore.class);
        this.tunnelHost.checkComplete();
        Validators.nonNull(this.system);
        Validators.isType(this.system, ShellStore.class);
        Validators.nonNull((Object)this.port);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompletePassword();
    }

    public final NetworkTunnelSession newSession() {
        int n2 = HostHelper.findRandomOpenPortOnAllLocalInterfaces();
        return ((NetworkTunnelStore)this.tunnelHost.getStore()).createTunnelSession(n2, this.port.intValue(), "localhost");
    }

    public final Class<?> getSessionClass() {
        return NetworkTunnelSession.class;
    }

    public final void stopSessionIfNeeded() {
        BrowserFullSessionModel browserFullSessionModel = BrowserFullSessionModel.DEFAULT;
        List list = browserFullSessionModel.getSessionEntriesSnapshot();
        list.stream().filter(browserSessionTab -> browserSessionTab instanceof BrowserStoreSessionTab && (browserSessionTab = (BrowserStoreSessionTab)browserSessionTab).getEntry().get() == this.getSelfEntry()).forEach(browserSessionTab -> browserFullSessionModel.closeSync(browserSessionTab));
        super.stopSessionIfNeeded();
    }

    public final boolean supportsDesktopAccess() {
        return true;
    }

    public final void runDesktopApplication(String string, DesktopApplicationStore desktopApplicationStore) {
        this.startSessionIfNeeded();
        string = desktopApplicationStore.getFullCommand();
        string.fixedEnvironment("DISPLAY", ":" + this.getDisplay()).fixedEnvironment("WAYLAND_DISPLAY", "wayland-" + this.getDisplay());
        desktopApplicationStore = ((NetworkTunnelSession)this.getSession()).getShellControl();
        desktopApplicationStore.command((CommandBuilder)string).execute();
    }

    public final ShellDialect getUsedDesktopDialect() {
        return ShellDialects.BASH;
    }

    public final int getDisplay() {
        if (this.port < 5900 || this.port >= 6000) {
            return 0;
        }
        return this.port - 5900;
    }

    public final String getEffectiveHost() {
        return "localhost";
    }

    public final int getEffectivePort() {
        NetworkTunnelSession networkTunnelSession = (NetworkTunnelSession)this.getSession();
        if (networkTunnelSession != null) {
            return networkTunnelSession.getLocalPort();
        }
        return -1;
    }

    public final String retrieveUser() {
        if (this.identity == null) {
            return null;
        }
        IdentityStore identityStore = this.identity.unwrap();
        boolean bl = identityStore.getUsername().hasUser();
        if (!bl) {
            return null;
        }
        return identityStore.getUsername().retrieveUsername();
    }

    public final SecretRetrievalStrategy getPassword() {
        if (this.identity != null) {
            return this.identity.unwrap().getPassword();
        }
        return null;
    }

    public final boolean isPerUser() {
        return this.identity != null && this.identity.isPerUser();
    }

    @Generated
    protected i(a<?, ?> a2) {
        this.tunnelHost = a2.tunnelHost;
        this.system = a2.system;
        this.port = a2.port;
        this.identity = a2.identity;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<NetworkTunnelStore> getTunnelHost() {
        return this.tunnelHost;
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getSystem() {
        return this.system;
    }

    @Generated
    public final Integer getPort() {
        return this.port;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof i)) {
            return false;
        }
        object = (i)object;
        IdentityValue identityValue = this.getPort();
        DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef = ((i)object).getPort();
        if (identityValue == null ? dataStoreEntryRef != null : !identityValue.equals(dataStoreEntryRef)) {
            return false;
        }
        identityValue = this.getTunnelHost();
        dataStoreEntryRef = ((i)object).getTunnelHost();
        if (identityValue == null ? dataStoreEntryRef != null : !identityValue.equals(dataStoreEntryRef)) {
            return false;
        }
        identityValue = this.getSystem();
        dataStoreEntryRef = ((i)object).getSystem();
        if (identityValue == null ? dataStoreEntryRef != null : !identityValue.equals(dataStoreEntryRef)) {
            return false;
        }
        identityValue = this.getIdentity();
        object = ((i)object).getIdentity();
        return !(identityValue == null ? object != null : !identityValue.equals(object));
    }

    @Generated
    public final int hashCode() {
        Integer n2 = this.getPort();
        int n3 = 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
        IdentityValue identityValue = this.getTunnelHost();
        n3 = n3 * 59 + (identityValue == null ? 43 : identityValue.hashCode());
        identityValue = this.getSystem();
        n3 = n3 * 59 + (identityValue == null ? 43 : identityValue.hashCode());
        identityValue = this.getIdentity();
        n3 = n3 * 59 + (identityValue == null ? 43 : identityValue.hashCode());
        return n3;
    }

    @Generated
    public final String toString() {
        return "VncTunnelStore(tunnelHost=" + String.valueOf(this.getTunnelHost()) + ", system=" + String.valueOf(this.getSystem()) + ", port=" + this.getPort() + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public static abstract class a<C extends i, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<NetworkTunnelStore> tunnelHost;
        @Generated
        private DataStoreEntryRef<ShellStore> system;
        @Generated
        private Integer port;
        @Generated
        private IdentityValue identity;

        @Generated
        public B tunnelHost(DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef) {
            this.tunnelHost = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B system(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.system = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B port(Integer n2) {
            this.port = n2;
            return this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "VncTunnelStore.VncTunnelStoreBuilder(tunnelHost=" + String.valueOf(this.tunnelHost) + ", system=" + String.valueOf(this.system) + ", port=" + this.port + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="vnc")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<i, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final i build() {
            return new i(this);
        }
    }
}

