/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.vmware;

import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.util.WindowsRegistry;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;

public enum d {
    PLAYER{

        @Override
        public final String L(ShellControl shellControl) {
            return "VMware Player";
        }

        @Override
        public final String queryVersion(ShellControl shellControl) {
            return "vmrun v1.17.0";
        }

        @Override
        public final FilePath M(ShellControl shellControl) {
            FilePath filePath = shellControl.view().userHome();
            if (shellControl.getOsType() == OsType.WINDOWS) {
                return filePath.join(new String[]{"Documents", "Virtual Machines"});
            }
            return filePath.join(new String[]{"vmware"});
        }

        @Override
        public final FilePath f(ShellControl shellControl, String string) {
            return FilePath.of((String)string).join(new String[]{"vmrun"});
        }

        @Override
        public final String getName() {
            return "VMware Player";
        }

        @Override
        public final String dZ() {
            return "proc:vmware_player_icon.png";
        }

        @Override
        public final Optional<String> N(ShellControl shellControl) {
            OsType.Any any = shellControl.getOsType();
            Objects.requireNonNull(any);
            OsType.Any any2 = any;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.Bsd.class, OsType.Solaris.class, OsType.Linux.class, OsType.MacOs.class, OsType.Windows.class}, (OsType.Any)any, 0)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    OsType.Bsd cfr_ignored_0 = (OsType.Bsd)any2;
                    return Optional.empty();
                }
                case 1: {
                    OsType.Solaris cfr_ignored_1 = (OsType.Solaris)any2;
                    return Optional.empty();
                }
                case 2: {
                    OsType.Linux cfr_ignored_2 = (OsType.Linux)any2;
                    return Optional.empty();
                }
                case 3: {
                    OsType.MacOs cfr_ignored_3 = (OsType.MacOs)any2;
                    return Optional.empty();
                }
                case 4: 
            }
            OsType.Windows cfr_ignored_4 = (OsType.Windows)any2;
            return WindowsRegistry.ofShell((ShellControl)shellControl).readStringValueIfPresent(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\vmplayer.exe", "Path");
        }
    }
    ,
    WORKSTATION{

        @Override
        public final String L(ShellControl shellControl) {
            return "VMware Workstation";
        }

        @Override
        public final String queryVersion(ShellControl shellControl) {
            return "vmrun v1.17.0";
        }

        @Override
        public final FilePath M(ShellControl shellControl) {
            FilePath filePath = shellControl.view().userHome();
            if (shellControl.getOsType() == OsType.WINDOWS) {
                return filePath.join(new String[]{"Documents", "Virtual Machines"});
            }
            return filePath.join(new String[]{"vmware"});
        }

        @Override
        public final FilePath f(ShellControl shellControl, String string) {
            if (shellControl.getOsType() == OsType.WINDOWS) {
                return FilePath.of((String)string).join(new String[]{"vmrun"});
            }
            return FilePath.of((String)"vmrun");
        }

        @Override
        public final String getName() {
            return "VMware Workstation";
        }

        @Override
        public final String dZ() {
            return "proc:vmware_workstation_icon.svg";
        }

        @Override
        public final Optional<String> N(ShellControl shellControl) {
            OsType.Any any = shellControl.getOsType();
            Objects.requireNonNull(any);
            OsType.Any any2 = any;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.Bsd.class, OsType.Solaris.class, OsType.Linux.class, OsType.MacOs.class, OsType.Windows.class}, (OsType.Any)any, 0)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    OsType.Bsd cfr_ignored_0 = (OsType.Bsd)any2;
                    return Optional.empty();
                }
                case 1: {
                    OsType.Solaris cfr_ignored_1 = (OsType.Solaris)any2;
                    return Optional.empty();
                }
                case 2: {
                    OsType.Linux cfr_ignored_2 = (OsType.Linux)any2;
                    ShellControl shellControl2 = shellControl;
                    boolean bl = shellControl2.command(shellControl2.getShellDialect().getWhichCommand("vmrun")).executeAndCheck();
                    if (bl) {
                        return Optional.of("/usr/lib/vmware");
                    }
                    return Optional.empty();
                }
                case 3: {
                    OsType.MacOs cfr_ignored_3 = (OsType.MacOs)any2;
                    return Optional.empty();
                }
                case 4: 
            }
            OsType.Windows cfr_ignored_4 = (OsType.Windows)any2;
            return WindowsRegistry.ofShell((ShellControl)shellControl).readStringValueIfPresent(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\vmware.exe", "Path");
        }
    }
    ,
    FUSION{

        @Override
        public final String L(ShellControl shellControl) {
            return shellControl.command(CommandBuilder.of().add(new String[]{"defaults", "read"}).addFile("/Applications/VMware Fusion.app/Contents/Info.plist").add(new String[]{"CFBundleName"})).readStdoutOrThrow();
        }

        @Override
        public final String queryVersion(ShellControl shellControl) {
            return "vmrun v" + shellControl.command(CommandBuilder.of().add(new String[]{"defaults", "read"}).addFile("/Applications/VMware Fusion.app/Contents/Info.plist").add(new String[]{"CFBundleShortVersionString"})).readStdoutOrThrow();
        }

        @Override
        public final FilePath M(ShellControl shellControl) {
            return shellControl.view().userHome().join(new String[]{"Virtual Machines.localized"});
        }

        @Override
        public final FilePath f(ShellControl shellControl, String string) {
            return FilePath.of((String)string).join(new String[]{"Contents", "Public", "vmrun"});
        }

        @Override
        public final String getName() {
            return "VMware Fusion";
        }

        @Override
        public final String dZ() {
            return "proc:vmware_fusion_icon.png";
        }

        @Override
        public final Optional<String> N(ShellControl shellControl) {
            OsType.Any any = shellControl.getOsType();
            Objects.requireNonNull(any);
            OsType.Any any2 = any;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.Bsd.class, OsType.Solaris.class, OsType.Linux.class, OsType.MacOs.class, OsType.Windows.class}, (OsType.Any)any, 0)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    OsType.Bsd cfr_ignored_0 = (OsType.Bsd)any2;
                    return Optional.empty();
                }
                case 1: {
                    OsType.Solaris cfr_ignored_1 = (OsType.Solaris)any2;
                    return Optional.empty();
                }
                case 2: {
                    OsType.Linux cfr_ignored_2 = (OsType.Linux)any2;
                    return Optional.empty();
                }
                case 3: {
                    OsType.MacOs cfr_ignored_3 = (OsType.MacOs)any2;
                    if (shellControl.getShellDialect().directoryExists(shellControl, "/Applications/VMware Fusion.app").executeAndCheck()) {
                        return Optional.of("/Applications/VMware Fusion.app");
                    }
                    return Optional.empty();
                }
                case 4: 
            }
            OsType.Windows cfr_ignored_4 = (OsType.Windows)any2;
            return Optional.empty();
        }
    };


    public abstract String L(ShellControl var1);

    public abstract String queryVersion(ShellControl var1);

    public abstract FilePath M(ShellControl var1);

    public abstract FilePath f(ShellControl var1, String var2);

    public abstract String getName();

    public abstract String dZ();

    public abstract Optional<String> N(ShellControl var1);
}

