/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.action.AbstractAction;
import io.xpipe.app.action.SerializableAction;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.hub.action.impl.InitHubLeafProvider;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.CommandSupport;
import io.xpipe.app.util.LabelGraphic;
import io.xpipe.app.util.LocalShell;
import io.xpipe.app.util.WindowsRegistry;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.ssh.b;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalInt;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public final class H
extends InitHubLeafProvider<b<?>, Path> {
    public final AbstractAction createAction(DataStoreEntryRef<b<?>> object) {
        object = DataStorage.get().getStoreEntryDisplayName(object.get());
        return ((a.a)((Object)a.builder().name((String)object))).build();
    }

    protected final Path cQ() {
        if (OsType.getLocal() != OsType.WINDOWS) {
            return null;
        }
        try (ShellControl shellControl = LocalShell.getShell().start();){
            Object object = CommandSupport.findProgram((ShellControl)shellControl, (String)"xshell");
            if (((Optional)object).isPresent()) {
                Path path = ((FilePath)((Optional)object).get()).asLocalPath();
                return path;
            }
            Optional optional = WindowsRegistry.local().readStringValueIfPresent(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\Xshell.exe");
            object = optional.map(string -> Path.of(string, new String[0])).orElse(null);
            return object;
        }
    }

    public final ObservableValue<String> getName(DataStoreEntryRef<b<?>> dataStoreEntryRef) {
        return AppI18n.observable((String)"openXShell", (Object[])new Object[0]);
    }

    public final LabelGraphic getIcon(DataStoreEntryRef<b<?>> dataStoreEntryRef) {
        return new LabelGraphic.IconGraphic("mdi2o-open-in-app");
    }

    public final Class<?> getApplicableClass() {
        return b.class;
    }

    public final String getId() {
        return "openSshXshell";
    }

    protected final /* synthetic */ Object check() {
        return this.cQ();
    }

    @JsonDeserialize(builder=b.class)
    public static class io.xpipe.ext.proc.ssh.H$a
    extends SerializableAction {
        String name;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void executeImpl() {
            Path path = (Path)((H)this.getProvider()).available;
            if (path == null) {
                return;
            }
            io.xpipe.ext.proc.ssh.H$a a2 = this;
            Optional<Path> optional = a2.getSessionFile(a2.name);
            if (optional.isEmpty()) {
                throw (UnsupportedOperationException)ErrorEventFactory.expected((Throwable)new UnsupportedOperationException("No xshell session file with name " + this.name + ".xsh was found"));
            }
            try (ShellControl shellControl = LocalShell.getShell().start();){
                shellControl.executeSimpleCommand(CommandBuilder.of().addFile(path.toString()).addFile(optional.get().toString()));
                if (shellControl == null) return;
            }
        }

        private Optional<Path> getSessionFile(String optional) {
            Object object;
            Optional optional2 = LocalShell.getLocalPowershell();
            if (optional2.isEmpty()) {
                return Optional.empty();
            }
            optional2 = Path.of(((ShellControl)optional2.get()).command("[Environment]::GetFolderPath([Environment+SpecialFolder]::MyDocuments)").readStdoutOrThrow(), new String[0]);
            if (!Files.exists((Path)((Object)(optional2 = optional2.resolve("NetSarang Computer"))), new LinkOption[0])) {
                return Optional.empty();
            }
            try (Object object2 = Files.list((Path)((Object)optional2));){
                object = object2.mapToInt(path -> {
                    try {
                        return Integer.parseInt(path.getFileName().toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return -1;
                    }
                }).max();
                if (((OptionalInt)object).isEmpty() || ((OptionalInt)object).getAsInt() == -1) {
                    optional = Optional.empty();
                    return optional;
                }
                optional2 = optional2.resolve("" + ((OptionalInt)object).getAsInt());
            }
            object2 = optional2.resolve("Xshell").resolve("Sessions");
            if (!Files.exists((Path)object2, new LinkOption[0])) {
                return Optional.empty();
            }
            object = Files.walk((Path)object2, new FileVisitOption[0]);
            try {
                optional2 = optional = object.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(arg_0 -> io.xpipe.ext.proc.ssh.H$a.lambda$getSessionFile$2((String)((Object)optional), arg_0)).findFirst();
                return optional2;
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }

        @Generated
        protected io.xpipe.ext.proc.ssh.H$a(a<?, ?> a2) {
            super(a2);
            this.name = a2.name;
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        private static /* synthetic */ boolean lambda$getSessionFile$2(String string, Path path) {
            return path.getFileName().toString().equalsIgnoreCase(string + ".xsh");
        }

        @Generated
        public static abstract class a<C extends io.xpipe.ext.proc.ssh.H$a, B extends a<C, B>>
        extends SerializableAction.SerializableActionBuilder<C, B> {
            @Generated
            private String name;

            @Generated
            public B name(String string) {
                this.name = string;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "SshXShellOpenActionProvider.Action.ActionBuilder(super=" + super.toString() + ", name=" + this.name + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<io.xpipe.ext.proc.ssh.H$a, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final io.xpipe.ext.proc.ssh.H$a build() {
                return new io.xpipe.ext.proc.ssh.H$a(this);
            }
        }
    }
}

