/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.hub.action.StoreAction;
import io.xpipe.app.hub.action.impl.InitHubLeafProvider;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.CommandSupport;
import io.xpipe.app.util.LabelGraphic;
import io.xpipe.app.util.LocalShell;
import io.xpipe.app.util.SecretQueryResult;
import io.xpipe.app.util.WindowsRegistry;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.KeyFileStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.b;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public final class D
extends InitHubLeafProvider<b<?>, Path> {
    protected final Path cK() {
        if (OsType.getLocal() != OsType.WINDOWS) {
            return null;
        }
        try (ShellControl shellControl = LocalShell.getShell().start();){
            Object object2 = CommandSupport.findProgram((ShellControl)shellControl, (String)"WinSCP.exe");
            if (((Optional)object2).isPresent()) {
                Path path2 = ((FilePath)((Optional)object2).get()).asLocalPath();
                return path2;
            }
            Optional optional = WindowsRegistry.local().readStringValueIfPresent(-2147483647, "Software\\Classes\\WinSCP.Url\\DefaultIcon");
            if (optional.isEmpty()) {
                optional = WindowsRegistry.local().readStringValueIfPresent(-2147483646, "Software\\Classes\\WinSCP.Url\\DefaultIcon");
            }
            object2 = optional.flatMap(object -> {
                object = Pattern.compile("\"(.+)\",\\d+").matcher((CharSequence)object);
                if (((Matcher)object).matches()) {
                    return Optional.of(Paths.get(((Matcher)object).group(1), new String[0]));
                }
                return Optional.empty();
            }).filter(path -> Files.exists(path, new LinkOption[0])).orElse(null);
            return object2;
        }
    }

    public final ObservableValue<String> getName(DataStoreEntryRef<b<?>> dataStoreEntryRef) {
        return AppI18n.observable((String)"openWinScp", (Object[])new Object[0]);
    }

    public final LabelGraphic getIcon(DataStoreEntryRef<b<?>> dataStoreEntryRef) {
        return new LabelGraphic.IconGraphic("mdi2o-open-in-app");
    }

    public final Class<?> getApplicableClass() {
        return b.class;
    }

    public final String getId() {
        return "openSshWinScp";
    }

    protected final /* synthetic */ Object check() {
        return this.cK();
    }

    @JsonDeserialize(builder=b.class)
    public static class io.xpipe.ext.proc.ssh.D$a
    extends StoreAction<io.xpipe.ext.proc.ssh.b<?>> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void executeImpl() {
            Path path = (Path)((D)this.getProvider()).available;
            if (path == null) {
                return;
            }
            try (ShellControl shellControl = LocalShell.getShell().start();){
                String string;
                io.xpipe.ext.proc.ssh.b b2 = (io.xpipe.ext.proc.ssh.b)this.getRef().getStore();
                b2.startGatewayTunnelIfNeeded();
                path = CommandBuilder.of().addFile(path).addLiteral(b2.getEffectiveHostName() + ":" + b2.getEffectivePort());
                SshIdentityStrategy sshIdentityStrategy = b2.getIdentityStrategy();
                if (sshIdentityStrategy instanceof KeyFileStrategy) {
                    SecretQueryResult secretQueryResult;
                    KeyFileStrategy keyFileStrategy = (KeyFileStrategy)sshIdentityStrategy;
                    sshIdentityStrategy = keyFileStrategy.getFile().toAbsoluteFilePath(shellControl);
                    if (!Files.exists((sshIdentityStrategy = FilePath.of((String)(sshIdentityStrategy.getBaseName().toString() + ".ppk"))).asLocalPath(), new LinkOption[0])) {
                        throw (IllegalArgumentException)ErrorEventFactory.expected((Throwable)new IllegalArgumentException("Required PuTTY .ppk key file " + String.valueOf(sshIdentityStrategy) + " not found. Please create a .ppk with the same key name to use this funtionality"));
                    }
                    path.addQuotedKeyValue("/privatekey", sshIdentityStrategy.toString());
                    if (keyFileStrategy.getAskpassStrategy().expectsQuery() && !keyFileStrategy.getAskpassStrategy().query().requiresUserInteraction() && (secretQueryResult = keyFileStrategy.getAskpassStrategy().query().query("Passphrase for key")).getSecret() != null) {
                        path.addQuotedKeyValue("/passphrase", secretQueryResult.getSecret().getSecretValue());
                    }
                }
                if ((string = b2.getUser().hasUser() ? b2.getUser().retrieveUsername() : null) != null) {
                    path.addQuotedKeyValue("/username", string);
                }
                if (b2.getPassword().expectsQuery() && (sshIdentityStrategy = b2.getPassword().query().query("Password for " + (string != null ? string : "?"))).getSecret() != null) {
                    path.addQuotedKeyValue("/password", sshIdentityStrategy.getSecret().getSecretValue());
                }
                sshIdentityStrategy = shellControl.command((CommandBuilder)path);
                sshIdentityStrategy.sensitive();
                sshIdentityStrategy.execute();
                if (shellControl == null) return;
            }
        }

        @Generated
        protected io.xpipe.ext.proc.ssh.D$a(a<?, ?> a2) {
            super(a2);
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<io.xpipe.ext.proc.ssh.D$a, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final io.xpipe.ext.proc.ssh.D$a build() {
                return new io.xpipe.ext.proc.ssh.D$a(this);
            }
        }

        @Generated
        public static abstract class a<C extends io.xpipe.ext.proc.ssh.D$a, B extends a<C, B>>
        extends StoreAction.StoreActionBuilder<io.xpipe.ext.proc.ssh.b<?>, C, B> {
            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "SshWinScpOpenActionProvider.Action.ActionBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

