/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.rdp;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.storage.ContextualFileReference;
import io.xpipe.app.util.LocalShell;
import io.xpipe.app.util.RdpConfig;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.proc.rdp.a;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

@JsonTypeName(value="rdpFile")
@JsonDeserialize(builder=b.class)
public final class d
extends io.xpipe.ext.proc.rdp.a
implements DesktopBaseStore {
    private final ContextualFileReference file;
    private final IdentityValue identity;

    public final void checkComplete() {
        Validators.nonNull((Object)this.file);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompletePassword();
    }

    @Override
    protected final SecretRetrievalStrategy getPassword() {
        if (this.identity != null) {
            return this.identity.unwrap().getPassword();
        }
        return null;
    }

    @Override
    protected final RdpConfig retrieveConfig() {
        Object object = RdpConfig.parseFile((FilePath)this.file.toAbsoluteFilePath(LocalShell.getShell()));
        if (this.identity != null && this.identity.unwrap().getUsername().hasUser()) {
            object = new LinkedHashMap<String, RdpConfig.TypedValue>(object.getContent());
            object.putFirst("username", new RdpConfig.TypedValue("s", this.identity.unwrap().getUsername().retrieveUsername()));
            return new RdpConfig((Map)object);
        }
        return object;
    }

    @Override
    protected final String getDisplayName() {
        return this.getSelfEntry().getName();
    }

    public final boolean supportsDesktopAccess() {
        return true;
    }

    @Generated
    protected d(a<?, ?> a2) {
        super(a2);
        this.file = a2.file;
        this.identity = a2.identity;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final ContextualFileReference getFile() {
        return this.file;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof d)) {
            return false;
        }
        d d2 = (d)object;
        if (!d2.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getFile();
        ContextualFileReference contextualFileReference = d2.getFile();
        if (object == null ? contextualFileReference != null : !object.equals(contextualFileReference)) {
            return false;
        }
        object = this.getIdentity();
        d2 = d2.getIdentity();
        return !(object == null ? d2 != null : !object.equals(d2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof d;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        ContextualFileReference contextualFileReference = this.getFile();
        n2 = n2 * 59 + (contextualFileReference == null ? 43 : contextualFileReference.hashCode());
        contextualFileReference = this.getIdentity();
        n2 = n2 * 59 + (contextualFileReference == null ? 43 : contextualFileReference.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "RdpFileStore(super=" + super.toString() + ", file=" + String.valueOf(this.getFile()) + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public static abstract class a<C extends d, B extends a<C, B>>
    extends a.a<C, B> {
        @Generated
        private ContextualFileReference file;
        @Generated
        private IdentityValue identity;

        @Generated
        public B file(ContextualFileReference contextualFileReference) {
            this.file = contextualFileReference;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RdpFileStore.RdpFileStoreBuilder(super=" + super.toString() + ", file=" + String.valueOf(this.file) + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="rdpFile")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<d, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final d build() {
            return new d(this);
        }
    }
}

