/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.rdp;

import io.xpipe.app.core.AppInstallation;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.rdp.ExternalRdpClient;
import io.xpipe.app.rdp.RdpLaunchConfig;
import io.xpipe.app.util.AsktextAlert;
import io.xpipe.app.util.ClipboardHelper;
import io.xpipe.app.util.RdpConfig;
import io.xpipe.app.util.SecretManager;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.desktop.DesktopApplicationStore;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;

public abstract class a
implements SelfReferentialStore,
DesktopBaseStore {
    protected abstract SecretRetrievalStrategy getPassword();

    protected void launchConfig(RdpConfig rdpConfig, boolean bl, boolean bl2) {
        ExternalRdpClient externalRdpClient = bl ? ExternalRdpClient.getApplicationLauncher() : (ExternalRdpClient)AppPrefs.get().rdpClientType().getValue();
        if (externalRdpClient == null) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("No external RDP client has been configured in the settings."));
        }
        String string = rdpConfig.get("full address").map(typedValue -> typedValue.getValue()).orElse("?");
        Optional optional = rdpConfig.get("username");
        if (optional.isEmpty() && (optional = AsktextAlert.query((String)("Username for " + string), null)).isPresent()) {
            rdpConfig = rdpConfig.overlay(Map.of("username", RdpConfig.TypedValue.string((String)((String)optional.get()))));
        }
        optional = bl2 ? SecretManager.retrieve((SecretRetrievalStrategy)this.getPassword(), (String)("Password for " + string), (UUID)this.getSelfEntry().getUuid(), (int)0, (boolean)true) : null;
        externalRdpClient.launch(new RdpLaunchConfig(this.getDisplayName(), rdpConfig, this.getSelfEntry().getUuid(), (SecretValue)optional));
        if (bl2 && !externalRdpClient.supportsPasswordPassing()) {
            ClipboardHelper.copyPassword((SecretValue)optional);
        }
    }

    public void runDesktopApplication(String string, DesktopApplicationStore desktopApplicationStore) {
        string = this.createLaunchAppConfig(string, desktopApplicationStore.getPath().replaceAll("/", "\\\\"), desktopApplicationStore.getArguments(), this.retrieveConfig());
        this.launchConfig((RdpConfig)string, true, true);
    }

    public ShellDialect getUsedDesktopDialect() {
        return ShellDialects.CMD;
    }

    protected abstract RdpConfig retrieveConfig();

    protected abstract String getDisplayName();

    protected RdpConfig createLaunchConnectionConfig(RdpConfig rdpConfig) {
        rdpConfig = rdpConfig.overlay(Map.of());
        return rdpConfig;
    }

    protected RdpConfig createLaunchAppConfig(String string, String string2, String string3, RdpConfig rdpConfig) {
        rdpConfig = rdpConfig.overlay(Map.of("remoteapplicationmode", new RdpConfig.TypedValue("i", "1"), "remoteapplicationname", new RdpConfig.TypedValue("s", string), "remoteapplicationprogram", new RdpConfig.TypedValue("s", string2), "remoteapplicationicon", new RdpConfig.TypedValue("s", AppInstallation.ofCurrent().getLogoPath().toString())));
        if (string3 != null && !string3.isBlank()) {
            rdpConfig = rdpConfig.overlay(Map.of("remoteapplicationcmdline", new RdpConfig.TypedValue("s", string3)));
        }
        return rdpConfig;
    }

    @Generated
    protected a(a<?, ?> a2) {
    }

    @Generated
    public String toString() {
        return "RdpBaseStore()";
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof a)) {
            return false;
        }
        return ((a)(object = (a)object)).canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof a;
    }

    @Generated
    public int hashCode() {
        return 1;
    }

    @Generated
    public static abstract class a<C extends a, B extends a<C, B>> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RdpBaseStore.RdpBaseStoreBuilder()";
        }
    }
}

