/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.proxmox;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.BaseElevationHandler;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.proc.proxmox.f;
import io.xpipe.ext.proc.proxmox.h;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

@JsonTypeName(value="proxmoxContainer")
@JsonDeserialize(builder=b.class)
public final class d
implements ShellStore,
StatefulDataStore<ContainerStoreState>,
io.xpipe.ext.proc.proxmox.a {
    private final DataStoreEntryRef<h> install;
    private final int vmid;
    private final String name;
    private final IdentityValue identity;

    public final void checkComplete() {
        Validators.nonNull(this.install);
        Validators.isType(this.install, h.class);
        this.install.checkComplete();
        if (this.identity != null) {
            this.identity.checkComplete();
        }
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (d)fixedChildStore;
        return ((a)((a)this.toBuilder().name(fixedChildStore.name)).identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(){

            public final ShellControl control(ShellControl shellControl) {
                Object object = new ShellOpenFunction(this){
                    private /* synthetic */ 1 dL;
                    {
                        this.dL = var1_1;
                    }

                    public final CommandBuilder prepareWithoutInitCommand() {
                        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"pct", "exec", "" + this.dL.d.this.getVmid(), "--", "su", "-l"});
                        if (this.dL.d.this.identity != null && this.dL.d.this.identity.unwrap().getUsername().hasUser()) {
                            commandBuilder.addQuoted(this.dL.d.this.identity.unwrap().getUsername().retrieveUsername());
                        }
                        return commandBuilder;
                    }

                    public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                        if (string == null) {
                            throw new NullPointerException("command is marked non-null but is null");
                        }
                        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"pct", "exec", "" + this.dL.d.this.getVmid(), "--", "su", "-l"});
                        if (this.dL.d.this.identity != null && this.dL.d.this.identity.unwrap().getUsername().hasUser()) {
                            commandBuilder.addQuoted(this.dL.d.this.identity.unwrap().getUsername().retrieveUsername());
                        }
                        return commandBuilder.add(new String[]{"-c"}).addLiteral(string);
                    }
                };
                shellControl = shellControl.subShell();
                shellControl.setDumbOpen((ShellOpenFunction)object);
                shellControl.setTerminalOpen((ShellOpenFunction)object);
                shellControl.elevated(f.bG()).withSourceStore((DataStore)d.this).withShellStateInit((StatefulDataStore)d.this);
                if (d.this.identity != null && d.this.identity.unwrap().getPassword() != null) {
                    shellControl.setElevationHandler(new BaseElevationHandler((DataStore)d.this, d.this.identity.unwrap().getPassword()).orElse(shellControl.getElevationHandler()));
                }
                shellControl.onStartupFail(throwable -> {
                    if (throwable instanceof LicenseRequiredException) {
                        return;
                    }
                    boolean bl = throwable.getMessage() == null || !throwable.getMessage().contains("Failed to exec");
                    if (!bl) {
                        ContainerStoreState.ContainerStoreStateBuilder containerStoreStateBuilder = ((ContainerStoreState)d.this.getState()).toBuilder();
                        containerStoreStateBuilder.shellMissing(Boolean.TRUE);
                        d.this.setState((DataStoreState)((ContainerStoreState)containerStoreStateBuilder.build().asNeeded()));
                    }
                });
                object = ((h)d.this.getInstall().getStore()).checkLicenseRequirement();
                if (((Optional)object).isPresent()) {
                    shellControl.requireLicensedFeature((LicensedFeature)((Optional)object).get());
                }
                return shellControl;
            }

            public final ShellStore getParentStore() {
                return (ShellStore)((h)d.this.getInstall().getStore()).getHost().getStore();
            }
        };
    }

    public final Class<ContainerStoreState> getStateClass() {
        return ContainerStoreState.class;
    }

    public final void start() {
        ((h)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((h)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"pct", "start", "" + this.getVmid()})).elevated(f.bG()).execute();
        shellControl = ((ContainerStoreState.ContainerStoreStateBuilder)((ContainerStoreState)this.getState()).toBuilder().running(Boolean.TRUE)).containerState("running").build();
        this.setState((DataStoreState)shellControl);
    }

    public final void stop() {
        ((h)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((h)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"pct", "stop", "" + this.getVmid()})).elevated(f.bG()).execute();
        shellControl = ((ContainerStoreState.ContainerStoreStateBuilder)((ContainerStoreState)this.getState()).toBuilder().running(Boolean.FALSE)).containerState("stopped").build();
        this.setState((DataStoreState)shellControl);
    }

    public final void pause() {
        ((h)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((h)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"pct", "suspend", "" + this.getVmid()})).elevated(f.bG()).execute();
        shellControl = ((ContainerStoreState.ContainerStoreStateBuilder)((ContainerStoreState)this.getState()).toBuilder().running(Boolean.FALSE)).containerState("suspended").build();
        this.setState((DataStoreState)shellControl);
    }

    @Override
    public final int getVmid() {
        return this.vmid;
    }

    @Generated
    protected d(a<?, ?> a2) {
        this.install = a2.install;
        this.vmid = a2.vmid;
        this.name = a2.name;
        this.identity = a2.identity;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<h> getInstall() {
        return this.install;
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof d)) {
            return false;
        }
        object = (d)object;
        if (this.getVmid() != ((d)object).getVmid()) {
            return false;
        }
        Object object2 = this.getInstall();
        Object object3 = ((d)object).getInstall();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getName();
        object3 = ((d)object).getName();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getIdentity();
        object = ((d)object).getIdentity();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        int n2 = 59 + this.getVmid();
        Object object = this.getInstall();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getName();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "ProxmoxContainerStore(install=" + String.valueOf(this.getInstall()) + ", vmid=" + this.getVmid() + ", name=" + this.getName() + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public static abstract class a<C extends d, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<h> install;
        @Generated
        private int vmid;
        @Generated
        private String name;
        @Generated
        private IdentityValue identity;

        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(d d2, a<?, ?> a2) {
            a2.install(d2.install);
            a2.vmid(d2.vmid);
            a2.name(d2.name);
            a2.identity(d2.identity);
        }

        @Generated
        public B install(DataStoreEntryRef<h> dataStoreEntryRef) {
            this.install = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B vmid(int n2) {
            this.vmid = n2;
            return this.self();
        }

        @Generated
        public B name(String string) {
            this.name = string;
            return this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ProxmoxContainerStore.ProxmoxContainerStoreBuilder(install=" + String.valueOf(this.install) + ", vmid=" + this.vmid + ", name=" + this.name + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="proxmoxContainer")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<d, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final d build() {
            return new d(this);
        }
    }
}

