/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc;

import io.xpipe.app.core.AppProperties;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.TrackEvent;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.ElevationHandler;
import io.xpipe.app.process.ProcessExceptionConverter;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.process.ShellTerminalInitCommand;
import io.xpipe.app.process.ShellTtyState;
import io.xpipe.app.process.ShellView;
import io.xpipe.app.process.SystemState;
import io.xpipe.app.process.TerminalInitFunction;
import io.xpipe.app.process.TerminalInitScriptConfig;
import io.xpipe.app.process.WorkingDirectoryFunction;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.core.FailableConsumer;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.i;
import io.xpipe.ext.proc.m;
import io.xpipe.ext.proc.util.g;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;

public abstract class j
extends i
implements ShellControl {
    protected final List<ShellTerminalInitCommand> aa = new ArrayList<ShellTerminalInitCommand>();
    protected final List<FailableConsumer<ShellControl, Exception>> ab = new ArrayList<FailableConsumer<ShellControl, Exception>>(List.of());
    protected final boolean ac = !AppProperties.get().isFullVersion();
    protected final SequencedSet<LicensedFeature> ad = new LinkedHashSet<LicensedFeature>();
    protected String C;
    protected FilePath ae;
    protected Consumer<ShellControl> af = shellControl -> {};
    protected Runnable ag = () -> {};
    protected Consumer<Throwable> ah = throwable -> {};
    protected String user;
    protected boolean ai;
    protected boolean aj;
    protected ElevationHandler ak;
    protected String osName;
    protected DataStore sourceStore;
    protected ShellDialect al;
    protected OsType.Any osType;
    protected WorkingDirectoryFunction am = WorkingDirectoryFunction.none();
    protected boolean an = true;
    protected ShellTtyState ao;
    protected ShellView ap;
    protected boolean aq;

    public void writeLine(String string) {
        this.writeLine(string, true);
    }

    public void writeLine(String string, boolean bl) {
        if (this.getStdin() == null || this.getStdin().isClosed()) {
            throw new IOException("Input is closed");
        }
        if (bl) {
            TrackEvent.withTrace((String)"Writing line").tag("line", (Object)string).handle();
        }
        bl = this.getShellDialect() != null && this.getShellDialect().getDumbMode().supportsAnyPossibleInteraction();
        String string2 = bl ? this.getShellDialect().getNewLine().getNewLineString() : "\n";
        this.getStdin().write((string + string2).getBytes(this.getCharset()));
        this.getStdin().flush();
    }

    public ShellView view() {
        if (this.ap == null) {
            this.ap = new ShellView((ShellControl)this);
        }
        return this.ap;
    }

    public void setNonInteractive() {
        this.an = false;
    }

    public void setWorkingDirectory(WorkingDirectoryFunction workingDirectoryFunction) {
        this.am = workingDirectoryFunction;
    }

    public Optional<DataStore> getSourceStore() {
        return Optional.ofNullable(this.sourceStore);
    }

    public Optional<UUID> getSourceStoreId() {
        return this.getSourceStore().flatMap(dataStore -> DataStorage.get().getStoreEntryIfPresent(dataStore, true)).map(dataStoreEntry -> dataStoreEntry.getUuid());
    }

    public ShellControl withSourceStore(DataStore dataStore) {
        this.sourceStore = dataStore;
        this.withSecurityPolicy(g.e(dataStore));
        return this;
    }

    public void requireLicensedFeature(LicensedFeature licensedFeature) {
        this.ad.add(licensedFeature);
    }

    public ShellControl onInit(FailableConsumer<ShellControl, Exception> failableConsumer) {
        this.ab.add(failableConsumer);
        return this;
    }

    public ShellControl onExit(Consumer<ShellControl> consumer) {
        this.af = consumer;
        return this;
    }

    public ShellControl onKill(Runnable runnable) {
        this.ag = runnable;
        return this;
    }

    public ShellControl onStartupFail(Consumer<Throwable> consumer) {
        this.ah = consumer;
        return this;
    }

    public FilePath getSystemTemporaryDirectory() {
        return this.ae;
    }

    public ShellControl withInitSnippet(ShellTerminalInitCommand shellTerminalInitCommand) {
        if (!this.aa.contains(shellTerminalInitCommand)) {
            this.aa.add(shellTerminalInitCommand);
        }
        return this;
    }

    public ShellControl subShell() {
        return new m(this);
    }

    public CommandControl command(CommandBuilder commandBuilder) {
        CommandBuilder commandBuilder2 = commandBuilder;
        commandBuilder = ProcessControlProvider.get().command((ShellControl)this, commandBuilder2, commandBuilder2);
        return commandBuilder;
    }

    public abstract void exitAndWait();

    protected boolean d(String string) {
        boolean bl = string != null && !string.contains("New-PSSession");
        return bl;
    }

    public Boolean A() {
        DataStore dataStore = this.getSourceStore();
        if (dataStore.isPresent() && (dataStore = dataStore.get()) instanceof StatefulDataStore) {
            dataStore = (StatefulDataStore)dataStore;
            if ((dataStore = dataStore.getState()) instanceof ShellStoreState) {
                return (dataStore = (ShellStoreState)dataStore).getRunning() != null ? dataStore.getRunning() : false;
            }
        }
        return null;
    }

    public ShellDialect B() {
        DataStore dataStore = this.getSourceStore();
        if (dataStore.isPresent() && (dataStore = dataStore.get()) instanceof StatefulDataStore) {
            dataStore = (StatefulDataStore)dataStore;
            if ((dataStore = dataStore.getState()) instanceof SystemState) {
                dataStore = (SystemState)dataStore;
                dataStore = dataStore.getShellDialect();
                return dataStore;
            }
        }
        return null;
    }

    public ShellTtyState C() {
        DataStore dataStore = this.getSourceStore();
        if (dataStore.isPresent() && (dataStore = dataStore.get()) instanceof StatefulDataStore) {
            dataStore = (StatefulDataStore)dataStore;
            if ((dataStore = dataStore.getState()) instanceof SystemState) {
                if ((dataStore = (SystemState)dataStore).getTtyState() != null) {
                    return dataStore.getTtyState();
                }
                return null;
            }
        }
        return null;
    }

    public OsType D() {
        DataStore dataStore = this.getSourceStore();
        if (dataStore.isPresent() && (dataStore = dataStore.get()) instanceof StatefulDataStore) {
            dataStore = (StatefulDataStore)dataStore;
            if ((dataStore = dataStore.getState()) instanceof SystemState && (dataStore = (SystemState)dataStore).getOsType() != null) {
                return dataStore.getOsType();
            }
        }
        return null;
    }

    public String E() {
        DataStore dataStore = this.getSourceStore();
        if (dataStore.isPresent() && (dataStore = dataStore.get()) instanceof StatefulDataStore) {
            dataStore = (StatefulDataStore)dataStore;
            if ((dataStore = dataStore.getState()) instanceof SystemState && (dataStore = (SystemState)dataStore).getOsName() != null) {
                return dataStore.getOsName();
            }
        }
        return null;
    }

    public ShellControl withExceptionConverter(ProcessExceptionConverter processExceptionConverter) {
        this.Z = processExceptionConverter;
        return this;
    }

    public String prepareTerminalOpen(TerminalInitScriptConfig terminalInitScriptConfig, WorkingDirectoryFunction workingDirectoryFunction) {
        return this.prepareIntermediateTerminalOpen(TerminalInitFunction.none(), terminalInitScriptConfig, workingDirectoryFunction);
    }

    public ShellDialect getShellDialect() {
        return this.al;
    }

    @Generated
    public List<ShellTerminalInitCommand> F() {
        return this.aa;
    }

    @Generated
    public boolean G() {
        return this.ac;
    }

    @Generated
    public void setUser(String string) {
        this.user = string;
    }

    @Generated
    public boolean isInitializing() {
        return this.ai;
    }

    @Generated
    public boolean isExiting() {
        return this.aj;
    }

    @Generated
    public ElevationHandler getElevationHandler() {
        return this.ak;
    }

    @Generated
    public void setElevationHandler(ElevationHandler elevationHandler) {
        this.ak = elevationHandler;
    }

    @Generated
    public String getOsName() {
        return this.osName;
    }

    @Generated
    public ShellDialect H() {
        return this.al;
    }

    @Generated
    public OsType.Any getOsType() {
        return this.osType;
    }

    @Generated
    public boolean isInteractive() {
        return this.an;
    }

    @Generated
    public ShellTtyState getTtyState() {
        return this.ao;
    }

    @Generated
    public boolean isSubShellActive() {
        return this.aq;
    }

    @Generated
    public void setSubShellActive(boolean bl) {
        this.aq = bl;
    }
}

