/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.env;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ParentSystemAccess;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellEnvironmentStoreState;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import lombok.Generated;
import lombok.NonNull;

@JsonTypeName(value="msys2")
@JsonDeserialize(builder=b.class)
public final class j
implements ShellStore,
StatefulDataStore<ShellEnvironmentStoreState> {
    private final DataStoreEntryRef<ShellStore> host;
    private final String location;

    public final Class<ShellEnvironmentStoreState> getStateClass() {
        return ShellEnvironmentStoreState.class;
    }

    public final void checkComplete() {
        Validators.nonNull((Object)this.location);
        Validators.nonNull(this.host);
        Validators.isType(this.host, ShellStore.class);
    }

    private CommandBuilder joinCommand(FilePath object, String stringArray) {
        stringArray = stringArray.split("\\s+", 2);
        object = String.valueOf(object) + "\\" + stringArray[0];
        return CommandBuilder.of().add(arg_0 -> j.lambda$joinCommand$0((String)object, stringArray, arg_0));
    }

    private ShellOpenFunction createOpenFunction() {
        FilePath filePath = FilePath.of((String[])new String[]{this.location, "usr", "bin"});
        return new ShellOpenFunction(){
            private /* synthetic */ FilePath bE;
            private /* synthetic */ j bI;
            {
                this.bE = filePath;
                this.bI = j2;
            }

            public final CommandBuilder prepareWithoutInitCommand() {
                return this.bI.joinCommand(this.bE, ShellDialects.BASH.getLaunchCommand().loginCommand());
            }

            public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                if (string == null) {
                    throw new NullPointerException("command is marked non-null but is null");
                }
                return this.bI.joinCommand(this.bE, string);
            }
        };
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(){

            public final ShellControl control(ShellControl shellControl2) {
                ShellOpenFunction shellOpenFunction = j.this.createOpenFunction();
                shellControl2 = shellControl2.subShell();
                shellControl2.setDumbOpen(shellOpenFunction);
                shellControl2.setTerminalOpen(shellOpenFunction);
                shellControl2.onExit(shellControl -> {
                    try {
                        shellControl.closeStdin();
                        return;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                });
                shellControl2.setParentSystemAccess(new ParentSystemAccess(this){
                    private /* synthetic */ 2 bK;
                    {
                        this.bK = var1_1;
                    }

                    public final boolean supportsSameUsers() {
                        return false;
                    }

                    public final boolean supportsFileSystemAccess() {
                        return true;
                    }

                    public final boolean supportsExecutables() {
                        return false;
                    }

                    public final boolean supportsExecutableEnvironment() {
                        return false;
                    }

                    public final FilePath translateFromLocalSystemPath(FilePath filePath) {
                        ShellControl shellControl = this.bK.j.this.getOrStartSession();
                        return FilePath.of((String)shellControl.command(CommandBuilder.of().add(new String[]{"cygpath", "--unix"}).addFile(filePath)).readStdoutOrThrow());
                    }

                    public final FilePath translateToLocalSystemPath(FilePath filePath) {
                        ShellControl shellControl = this.bK.j.this.getOrStartSession();
                        return FilePath.of((String)shellControl.command(CommandBuilder.of().add(new String[]{"cygpath", "--windows"}).addFile(filePath)).readStdoutOrThrow());
                    }

                    public final boolean isIdentity() {
                        return false;
                    }
                });
                shellControl2.withSourceStore((DataStore)j.this);
                shellControl2.withShellStateInit((StatefulDataStore)j.this);
                shellControl2.withShellStateFail((StatefulDataStore)j.this);
                shellControl2.onInit(object -> {
                    object = object.getShellDialect().queryVersion(object);
                    j.this.setState((DataStoreState)((ShellEnvironmentStoreState)j.this.getState()).toBuilder().shellName((String)object).build());
                });
                return shellControl2;
            }

            public final ShellStore getParentStore() {
                return (ShellStore)j.this.host.getStore();
            }
        };
    }

    @Generated
    protected j(a<?, ?> a2) {
        this.host = a2.host;
        this.location = a2.location;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public final String getLocation() {
        return this.location;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof j)) {
            return false;
        }
        object = (j)object;
        Object object2 = this.getHost();
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = ((j)object).getHost();
        if (object2 == null ? dataStoreEntryRef != null : !object2.equals(dataStoreEntryRef)) {
            return false;
        }
        object2 = this.getLocation();
        object = ((j)object).getLocation();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = this.getHost();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        String string = this.getLocation();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "Msys2Store(host=" + String.valueOf(this.getHost()) + ", location=" + this.getLocation() + ")";
    }

    private static /* synthetic */ String lambda$joinCommand$0(String string, String[] stringArray, ShellControl shellControl) {
        return shellControl.getShellDialect().fileArgument(string) + " " + stringArray[1];
    }

    @Generated
    public static abstract class a<C extends j, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> host;
        @Generated
        private String location;

        @Generated
        public B host(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.host = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B location(String string) {
            this.location = string;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Msys2Store.Msys2StoreBuilder(host=" + String.valueOf(this.host) + ", location=" + this.location + ")";
        }
    }

    @JsonTypeName(value="msys2")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<j, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final j build() {
            return new j(this);
        }
    }
}

