/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.env;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ParentSystemAccess;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellEnvironmentStoreState;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import lombok.Generated;
import lombok.NonNull;

@JsonTypeName(value="gitWindows")
@JsonDeserialize(builder=b.class)
public final class e
implements ShellStore,
StatefulDataStore<ShellEnvironmentStoreState> {
    private final DataStoreEntryRef<ShellStore> host;
    private final String location;

    public final Class<ShellEnvironmentStoreState> getStateClass() {
        return ShellEnvironmentStoreState.class;
    }

    public final void checkComplete() {
        Validators.nonNull((Object)this.location);
        Validators.nonNull(this.host);
        Validators.isType(this.host, ShellStore.class);
    }

    private CommandBuilder joinCommand(FilePath object, String stringArray) {
        stringArray = stringArray.split("\\s+", 2);
        object = String.valueOf(object) + "\\" + stringArray[0];
        return CommandBuilder.of().addFile((String)object).add(new String[]{stringArray[1]});
    }

    private ShellOpenFunction createOpenFunction() {
        FilePath filePath = FilePath.of((String[])new String[]{this.location, "usr", "bin"});
        return new ShellOpenFunction(){
            private /* synthetic */ FilePath bE;
            private /* synthetic */ e bF;
            {
                this.bE = filePath;
                this.bF = e2;
            }

            public final CommandBuilder prepareWithoutInitCommand() {
                return this.bF.joinCommand(this.bE, ShellDialects.BASH.getLaunchCommand().loginCommand());
            }

            public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                if (string == null) {
                    throw new NullPointerException("command is marked non-null but is null");
                }
                return this.bF.joinCommand(this.bE, string);
            }
        };
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(){

            public final ShellControl control(ShellControl shellControl) {
                ShellOpenFunction shellOpenFunction = e.this.createOpenFunction();
                shellControl = shellControl.subShell();
                shellControl.setDumbOpen(shellOpenFunction);
                shellControl.setTerminalOpen(shellOpenFunction);
                shellControl.setParentSystemAccess(new ParentSystemAccess(this){
                    private /* synthetic */ 2 bH;
                    {
                        this.bH = var1_1;
                    }

                    public final boolean supportsSameUsers() {
                        return false;
                    }

                    public final boolean supportsFileSystemAccess() {
                        return true;
                    }

                    public final boolean supportsExecutables() {
                        return false;
                    }

                    public final boolean supportsExecutableEnvironment() {
                        return false;
                    }

                    public final FilePath translateFromLocalSystemPath(FilePath filePath) {
                        ShellControl shellControl = this.bH.e.this.getOrStartSession();
                        return FilePath.of((String)shellControl.command(CommandBuilder.of().add(new String[]{"cygpath", "--unix"}).addFile(filePath)).readStdoutOrThrow());
                    }

                    public final FilePath translateToLocalSystemPath(FilePath filePath) {
                        ShellControl shellControl = this.bH.e.this.getOrStartSession();
                        return FilePath.of((String)shellControl.command(CommandBuilder.of().add(new String[]{"cygpath", "--windows"}).addFile(filePath)).readStdoutOrThrow());
                    }

                    public final boolean isIdentity() {
                        return false;
                    }
                });
                shellControl.withSourceStore((DataStore)e.this);
                shellControl.withShellStateInit((StatefulDataStore)e.this);
                shellControl.withShellStateFail((StatefulDataStore)e.this);
                shellControl.onInit(object -> {
                    object = object.getShellDialect().queryVersion(object);
                    e.this.setState((DataStoreState)((ShellEnvironmentStoreState)e.this.getState()).toBuilder().shellName((String)object).build());
                });
                return shellControl;
            }

            public final ShellStore getParentStore() {
                return (ShellStore)e.this.host.getStore();
            }
        };
    }

    @Generated
    protected e(a<?, ?> a2) {
        this.host = a2.host;
        this.location = a2.location;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public final String getLocation() {
        return this.location;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof e)) {
            return false;
        }
        object = (e)object;
        Object object2 = this.getHost();
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = ((e)object).getHost();
        if (object2 == null ? dataStoreEntryRef != null : !object2.equals(dataStoreEntryRef)) {
            return false;
        }
        object2 = this.getLocation();
        object = ((e)object).getLocation();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = this.getHost();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        String string = this.getLocation();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "GitForWindowsStore(host=" + String.valueOf(this.getHost()) + ", location=" + this.getLocation() + ")";
    }

    @Generated
    public static abstract class a<C extends e, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> host;
        @Generated
        private String location;

        @Generated
        public B host(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.host = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B location(String string) {
            this.location = string;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "GitForWindowsStore.GitForWindowsStoreBuilder(host=" + String.valueOf(this.host) + ", location=" + this.location + ")";
        }
    }

    @JsonTypeName(value="gitWindows")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<e, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final e build() {
            return new e(this);
        }
    }
}

