/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc;

import io.xpipe.app.core.AppProperties;
import io.xpipe.app.core.AppSid;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.core.mode.OperationMode;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorAction;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.issue.TrackEvent;
import io.xpipe.app.process.CommandConfiguration;
import io.xpipe.app.process.CountDown;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ElevationHandler;
import io.xpipe.app.process.LocalProcessInputStream;
import io.xpipe.app.process.LocalProcessOutputStream;
import io.xpipe.app.process.ParentSystemAccess;
import io.xpipe.app.process.SecretReference;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.process.ShellSecurityPolicy;
import io.xpipe.app.process.ShellSpawnException;
import io.xpipe.app.process.ShellTerminalInitCommand;
import io.xpipe.app.process.ShellTtyState;
import io.xpipe.app.process.ShellView;
import io.xpipe.app.process.TerminalInitFunction;
import io.xpipe.app.process.TerminalInitScriptConfig;
import io.xpipe.app.process.WorkingDirectoryFunction;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.terminal.TerminalLauncher;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.SecretManager;
import io.xpipe.app.util.SecretQuery;
import io.xpipe.app.util.ShellTemp;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.core.FailableConsumer;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.f;
import io.xpipe.ext.proc.h;
import io.xpipe.ext.proc.io.c;
import io.xpipe.ext.proc.io.g;
import io.xpipe.ext.proc.j;
import io.xpipe.ext.proc.k;
import io.xpipe.ext.proc.util.d;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;

public final class e
extends j {
    private static final UUID F = UUID.randomUUID();
    private static String G;
    private static FilePath H;
    private final boolean I;
    private final 1 J = new ReentrantLock(this){
        private /* synthetic */ e O;
        {
            this.O = e2;
        }

        @Override
        public final void lock() {
            super.lock();
        }

        @Override
        public final void unlock() {
            if (super.isHeldByCurrentThread()) {
                super.unlock();
            }
        }
    };
    private Process K;
    private LocalProcessOutputStream L;
    private LocalProcessInputStream M;
    private LocalProcessInputStream N;

    public e(boolean bl) {
        this.I = bl;
        this.ak = new ElevationHandler(){

            public final boolean handleRequest(UUID uUID, CountDown countDown, boolean bl, boolean bl2) {
                SecretReference secretReference = this.getSecretRef();
                SecretManager.expectAskpass((UUID)uUID, (UUID)secretReference.getSecretId(), List.of(SecretQuery.confirmElevationIfNeeded((SecretQuery)SecretQuery.prompt((boolean)true), (boolean)bl)), (SecretQuery)SecretQuery.prompt((boolean)false), List.of(), List.of(), (CountDown)countDown, (boolean)bl2);
                return true;
            }

            public final SecretReference getSecretRef() {
                return SecretReference.ofUuid((UUID)F);
            }
        };
    }

    public static void n() {
        H = null;
        G = null;
    }

    @Override
    public final ShellView view() {
        if (this.ap == null) {
            this.ap = new f(this);
        }
        return this.ap;
    }

    @Override
    public final void exitAndWait() {
        try {
            this.getLock().lock();
            this.refreshRunningState();
            if (!this.running) {
                this.resetData();
                return;
            }
            this.af.accept(this);
            this.aj = true;
            if (this.K.isAlive()) {
                boolean bl = this.isAnyStreamClosed() || OperationMode.isInShutdown();
                if (!bl) {
                    this.getShellDialect().getDumbMode().prepareDumbExit((ShellControl)this);
                }
                this.getStdout().close();
                this.getStderr().close();
                this.getStdin().close();
                if (bl) {
                    this.K.destroy();
                }
                try {
                    this.K.waitFor(7500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.resetData();
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final void resetData() {
        this.X = null;
        this.running = false;
        this.K = null;
        this.L = null;
        this.M = null;
        this.N = null;
        this.ai = false;
        this.aj = false;
    }

    public final void refreshRunningState() {
        this.running = this.K != null && this.K.isAlive();
    }

    public final void closeStdin() {
        try {
            this.getLock().lock();
            if (this.K == null) {
                return;
            }
            this.getStdin().close();
            ThreadHelper.sleep((long)100L);
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final boolean isAnyStreamClosed() {
        if (this.K == null) {
            return false;
        }
        return this.getStdin().isClosed() || this.getStdout().isClosed() || this.getStderr().isClosed();
    }

    public final void close() {
        try {
            this.getLock().lock();
            if (!this.I) {
                return;
            }
            TrackEvent.withTrace((String)"Closing local shell ...").handle();
            try {
                ((j)this).exitAndWait();
            }
            catch (IOException iOException) {
                this.kill();
                throw iOException;
            }
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final void shutdown() {
        this.close();
    }

    public final void kill() {
        try {
            this.getLock().lock();
            if (!this.running) {
                this.resetData();
                return;
            }
            TrackEvent.withTrace((String)"Killing local shell ...").handle();
            this.K.destroyForcibly();
            List<ProcessHandle> list = this.K.descendants().toList();
            list.forEach(processHandle -> {
                try {
                    processHandle.destroyForcibly();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    return;
                }
            });
            this.resetData();
            this.ag.run();
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final void killExternal() {
        try {
            if (!this.isRunning(true)) {
                return;
            }
            TrackEvent.withTrace((String)"Killing local shell ...").handle();
            this.K.destroyForcibly();
            List<ProcessHandle> list = this.K.descendants().toList();
            list.forEach(processHandle -> {
                try {
                    processHandle.destroyForcibly();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    return;
                }
            });
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final void setDumbOpen(ShellOpenFunction shellOpenFunction) {
        throw new UnsupportedOperationException();
    }

    public final void setTerminalOpen(ShellOpenFunction shellOpenFunction) {
        throw new UnsupportedOperationException();
    }

    public final Optional<ShellControl> getParentControl() {
        return Optional.empty();
    }

    public final void closeStdout() {
        try {
            this.getLock().lock();
            if (this.K == null) {
                return;
            }
            this.getStdout().close();
            this.getStderr().close();
            ThreadHelper.sleep((long)100L);
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final List<UUID> getExitUuids() {
        return List.of();
    }

    public final ParentSystemAccess getParentSystemAccess() {
        return ParentSystemAccess.identity();
    }

    public final void setParentSystemAccess(ParentSystemAccess parentSystemAccess) {
        throw new UnsupportedOperationException();
    }

    public final ParentSystemAccess getLocalSystemAccess() {
        return ParentSystemAccess.identity();
    }

    public final boolean isLocal() {
        return true;
    }

    public final ShellDialect getOriginalShellDialect() {
        return this.getShellDialect();
    }

    public final void setOriginalShellDialect(ShellDialect shellDialect) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ShellControl start() {
        try {
            try {
                this.getLock().lock();
                if (this.K != null && !this.K.isAlive()) {
                    this.resetData();
                }
                if (this.running) {
                    e e2 = this;
                    return e2;
                }
                if (this.ai) {
                    e e3 = this;
                    return e3;
                }
                this.o();
                e e4 = this;
                return e4;
            }
            catch (Throwable throwable) {
                this.ah.accept(throwable);
                Object object = this.Z.convert(throwable);
                AtomicBoolean atomicBoolean = new AtomicBoolean();
                ErrorEvent.ErrorEventBuilder errorEventBuilder = ErrorEventFactory.fromThrowable((Throwable)object).description("Unable to launch local shell " + h.get().getEffectiveLocalDialect().getDisplayName()).documentationLink(this.I ? DocumentationLink.LOCAL_SHELL_OCCASIONAL : DocumentationLink.LOCAL_SHELL_ERROR);
                Object object2 = h.get().getNextFallbackDialect();
                object2 = new ErrorAction(){
                    private /* synthetic */ ShellDialect P;
                    private /* synthetic */ AtomicBoolean Q;
                    {
                        this.P = shellDialect;
                        this.Q = atomicBoolean;
                    }

                    public final String getName() {
                        return "Fall back to " + this.P.getDisplayName() + " as an alternative shell";
                    }

                    public final String getDescription() {
                        return "Attempt to handle all operations only using " + this.P.getDisplayName();
                    }

                    public final boolean handle(ErrorEvent errorEvent) {
                        this.Q.set(true);
                        return true;
                    }
                };
                if (!this.I) {
                    errorEventBuilder.customAction((ErrorAction)object2);
                }
                errorEventBuilder.handle();
                if (!atomicBoolean.get()) throw object;
                try {
                    h.get().toggleFallbackShell();
                    this.o();
                    object = this;
                    return object;
                }
                catch (Exception exception) {
                    this.ah.accept(throwable);
                    Throwable throwable2 = this.Z.convert((Throwable)exception);
                    ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)exception).documentationLink(DocumentationLink.LOCAL_SHELL_ERROR));
                    throw throwable2;
                }
            }
            finally {
                ((ReentrantLock)this.J).unlock();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            throw throwable;
        }
    }

    public final LocalProcessInputStream getStdout() {
        return this.M;
    }

    public final LocalProcessOutputStream getStdin() {
        return this.L;
    }

    public final LocalProcessInputStream getStderr() {
        return this.N;
    }

    public final void checkLicenseOrThrow() {
        for (LicensedFeature licensedFeature : this.ad) {
            licensedFeature.throwIfUnsupported();
        }
    }

    public final String prepareIntermediateTerminalOpen(TerminalInitFunction terminalInitFunction, TerminalInitScriptConfig terminalInitScriptConfig, WorkingDirectoryFunction workingDirectoryFunction) {
        ShellControl shellControl = this.getActiveReplacementBackgroundSession().orElseThrow();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(shellControl.getShellDialect().prepareTerminalEnvironmentCommands());
        arrayList.add(shellControl.getShellDialect().getCdCommand(AppSystemInfo.ofCurrent().getUserHome().toString()));
        arrayList.add(shellControl.getShellDialect().getSetEnvironmentVariableCommand("XPIPE_SESSION", AppProperties.get().getSessionId().toString()));
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (ShellTerminalInitCommand bl : this.aa) {
            Optional optional;
            if (!bl.canPotentiallyRunInDialect(shellControl.getShellDialect()) || !(optional = bl.terminalContent(shellControl)).isPresent()) continue;
            arrayList2.add((String)optional.get());
        }
        String string = terminalInitFunction.isSpecified() ? terminalInitFunction.apply(shellControl) : null;
        String string2 = string == null && terminalInitScriptConfig.getTerminalSpecificCommands().isSpecified() ? terminalInitScriptConfig.getTerminalSpecificCommands().apply(shellControl) : null;
        if (string2 != null) {
            arrayList2.add(string2);
        }
        if (string != null) {
            arrayList2.add(string);
        }
        boolean bl = this.d(string);
        terminalInitFunction = TerminalLauncher.constructTerminalInitFile((ShellDialect)shellControl.getShellDialect(), (ShellControl)shellControl, (WorkingDirectoryFunction)workingDirectoryFunction, arrayList, arrayList2, (TerminalInitScriptConfig)terminalInitScriptConfig, (boolean)bl);
        TrackEvent.withDebug((String)"Writing open init script").tag("initFile", (Object)terminalInitFunction).tag("preInit", arrayList).tag("postInit", arrayList2).handle();
        return shellControl.getShellDialect().terminalInitCommand(shellControl, terminalInitFunction.toString(), bl);
    }

    public final ShellControl withSecurityPolicy(ShellSecurityPolicy shellSecurityPolicy) {
        return this;
    }

    public final ShellSecurityPolicy getEffectiveSecurityPolicy() {
        return new ShellSecurityPolicy(){

            public final boolean permitTempScriptCreation() {
                return true;
            }
        };
    }

    public final String buildElevatedCommand(CommandConfiguration commandConfiguration, String string, UUID uUID, CountDown countDown, String string2) {
        return this.getShellDialect().getAskpass().elevateDumbCommand((ShellControl)this, uUID, this.ak, countDown, string, string2, commandConfiguration);
    }

    public final void restart() {
        try {
            this.getLock().lock();
            this.close();
            this.start();
            return;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public final ShellControl elevated(ElevationFunction elevationFunction) {
        return this;
    }

    public final Optional<ShellControl> getActiveReplacementBackgroundSession() {
        DataStorage dataStorage = DataStorage.get();
        if (dataStorage == null) {
            return Optional.of(new e(true).start());
        }
        dataStorage = (ShellStore)dataStorage.local().getStore();
        return Optional.of(dataStorage.getOrStartSession());
    }

    public final void o() {
        try {
            this.K = e.s();
            this.C = this.K.info().commandLine().orElse(null);
            this.X = UUID.randomUUID();
            TrackEvent.withTrace((String)"Starting local shell").tag("command", (Object)this.C).tag("id", (Object)this.getUuid()).handle();
            this.L = this.r();
            this.M = this.p();
            this.N = this.q();
            this.running = true;
            Object object = CountDown.of();
            object.start(OsType.getLocal() == OsType.WINDOWS ? 15000L : 10000L);
            this.ai = true;
            d d22 = new d(this, StandardCharsets.US_ASCII, this.C, UUID.randomUUID().toString(), (CountDown)object, null);
            d22.dw();
            this.al = d22.dH();
            this.ao = d22.dr();
            if (this.getTtyState() != ShellTtyState.NONE) {
                object = new UnsupportedOperationException("Local background shell has a tty allocated");
                ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)object).documentationLink(DocumentationLink.TTY));
                throw object;
            }
            this.al.getDumbMode().throwIfUnsupported();
            TrackEvent.withTrace((String)"Local shell started up").tag("elapsed", (Object)(object.getMillisecondsElapsed() + "ms")).handle();
            if (this.Y == null) {
                this.Y = this.getShellDialect().determineCharset((ShellControl)this);
            }
            this.osType = OsType.getLocal().toAny();
            this.al.getDumbMode().prepareDumbInit((ShellControl)this);
            if (!this.isRunning(true)) {
                throw new IllegalStateException("Local shell exited upon startup");
            }
            if (this.ae == null) {
                this.ae = H != null ? H : io.xpipe.ext.proc.util.e.J(this);
                H = this.ae;
            }
            ShellTemp.checkTempDirectory((ShellControl)this);
            if (this.osName == null) {
                this.osName = G != null ? G : io.xpipe.ext.proc.util.e.K(this);
                G = this.osName;
            }
            e e2 = this;
            e2.writeLine(e2.H().getSetEnvironmentVariableCommand("XPIPE_SESSION", AppProperties.get().getSessionId().toString()));
            if (this.am.isSpecified()) {
                object = this.am.apply((ShellControl)this);
                ((j)this).view().cd(object.toString());
            }
            e e3 = this;
            e3.writeLine(e3.H().addToPathVariableCommand(List.of(AppProperties.get().getDataBinDir().toString()), true));
            for (FailableConsumer failableConsumer : this.ab) {
                failableConsumer.accept((Object)this);
            }
            k.b(this);
            this.ai = false;
            return;
        }
        catch (Throwable throwable) {
            G = null;
            H = null;
            this.kill();
            throw throwable;
        }
    }

    private LocalProcessInputStream p() {
        try {
            InputStream inputStream = this.K.getInputStream();
            if (OsType.getLocal() == OsType.WINDOWS) {
                return new io.xpipe.ext.proc.io.f(inputStream);
            }
            return new c(inputStream);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    private LocalProcessInputStream q() {
        try {
            if (OsType.getLocal() == OsType.WINDOWS) {
                return new io.xpipe.ext.proc.io.f(this.K.getErrorStream());
            }
            return new c(this.K.getErrorStream());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    private LocalProcessOutputStream r() {
        try {
            if (OsType.getLocal() == OsType.WINDOWS) {
                return new g(this.K.getOutputStream());
            }
            return new io.xpipe.ext.proc.io.d(this.K.getOutputStream());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    private static Process s() {
        Object object = h.get().getEffectiveLocalDialect().getLaunchCommand().localCommand().stream();
        object = OsType.getLocal() == OsType.WINDOWS || !AppSid.isHasSetsid() ? object : Stream.concat(Stream.of("setsid"), object);
        object = new ProcessBuilder(object.toList());
        Object object2 = AppProperties.get().getDataDir().resolve("shell");
        FileUtils.forceMkdir((File)object2.toFile());
        ((ProcessBuilder)object).directory(object2.toFile());
        object2 = ((ProcessBuilder)object).environment();
        object2.put((String)"NO_COLOR", (String)"true");
        object2.put("TERM", "dumb");
        object2.put("LC_ALL", "C.UTF-8");
        object2.put("LANGUAGE", "C.UTF-8");
        object2.put("LANG", "C.UTF-8");
        if (OsType.getLocal() == OsType.WINDOWS) {
            object2.remove("PSModulePath");
        }
        object2.put("DISABLE_AUTO_UPDATE", "true");
        object2.put("POWERLEVEL9K_INSTANT_PROMPT", "off");
        object2.remove("_JPACKAGE_LAUNCHER");
        if (OsType.getLocal() == OsType.LINUX) {
            object2.put("ELECTRON_OZONE_PLATFORM_HINT", "auto");
        }
        try {
            return ((ProcessBuilder)object).start();
        }
        catch (IOException iOException) {
            throw new ShellSpawnException("Unable to launch required system shell: " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
    }

    @Generated
    public final ReentrantLock getLock() {
        return this.J;
    }
}

