/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.docker;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.FixedHierarchyStore;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.proc.docker.c;
import io.xpipe.ext.proc.docker.h;
import io.xpipe.ext.proc.docker.o;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

@JsonTypeName(value="dockerContext")
@JsonDeserialize(builder=b.class)
public final class s
implements FixedChildStore,
NameableStore,
SelfReferentialStore,
StatefulDataStore<c>,
FixedHierarchyStore {
    private final DataStoreEntryRef<io.xpipe.ext.proc.docker.a> cmd;
    private final String name;

    public final void checkLicense() {
        if (!(((c)this.getState()).isCurrent() || this.name.contains("desktop-") || this.name.equals("default"))) {
            LicenseProvider.get().getFeature("dockerContext").throwIfUnsupported();
        }
    }

    public final void checkComplete() {
        Validators.nonNull(this.cmd);
        Validators.isType(this.cmd, io.xpipe.ext.proc.docker.a.class);
        ((io.xpipe.ext.proc.docker.a)this.cmd.getStore()).checkComplete();
        Validators.nonNull((Object)this.name);
    }

    private void checkLicenseSupport(String string) {
        LicensedFeature licensedFeature = LicenseProvider.get().getFeature("dockerCommercial");
        if (licensedFeature.isSupported()) {
            return;
        }
        if (string != null && (string.contains("Enterprise") || string.contains("Mirantis"))) {
            throw new LicenseRequiredException(licensedFeature);
        }
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.name));
    }

    public final List<? extends DataStoreEntryRef<? extends FixedChildStore>> listChildren() {
        this.checkLicense();
        try {
            Object object;
            ShellControl shellControl = ((ShellStore)((io.xpipe.ext.proc.docker.a)this.getCmd().getStore()).getHost().getStore()).getOrStartSession();
            Object object2 = new io.xpipe.ext.proc.docker.c(shellControl).y(this.name);
            object2 = ((c.e)((Object)object2)).az();
            List<c.a.a> list = Pattern.compile("Version: +([^ ]+)");
            Object object3 = Pattern.compile("Server:(?: +([^ ]+))?");
            list = ((Pattern)((Object)list)).matcher((CharSequence)object2);
            object2 = ((Pattern)object3).matcher((CharSequence)object2);
            object2 = ((Matcher)object2).find() && ((Matcher)object2).groupCount() > 1 ? ((Matcher)object2).group(1).strip() : (((Matcher)((Object)list)).find() ? "Docker v" + ((Matcher)((Object)list)).group(1).strip() : null);
            this.checkLicenseSupport((String)object2);
            s s2 = this;
            s2.setState(((c.a)((Object)((c)s2.getState()).toBuilder().reachable(Boolean.TRUE))).build());
            object2 = new ArrayList();
            list = new io.xpipe.ext.proc.docker.c(shellControl).A(this.name);
            list = ((c.a)((Object)list)).aa();
            object3 = list.stream().map(a2 -> {
                Object object = ((h.a)((h.a)((h.a)((h.a)h.builder().context((DataStoreEntryRef<s>)this.getSelfEntry().ref())).configFiles(a2.ad())).name(a2.ab())).restriction(a2.ae())).build();
                object = DataStoreEntry.createNew((String)a2.ab(), object);
                object.setStorePersistentState(((h.c.a)((Object)((Object)h.c.builder().state(a2.ac())))).build());
                return object.ref();
            }).toList();
            ((ArrayList)object2).addAll(object3);
            ArrayList arrayList = new ArrayList();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                object = (DataStoreEntryRef)object3.next();
                try {
                    object = ((h)object.getStore()).listServices(list);
                    arrayList.addAll(object);
                }
                catch (ProcessOutputException processOutputException) {
                    object = processOutputException;
                    ErrorEventFactory.fromThrowable((Throwable)processOutputException).omit().expected().handle();
                }
            }
            object3 = new io.xpipe.ext.proc.docker.c(shellControl).z(this.name);
            object = ((c.c)((Object)object3)).ap().stream().filter(a2 -> arrayList.stream().noneMatch(a3 -> a3.am().equals(a2.aq()))).map(a2 -> {
                boolean bl = a2.as() != null && a2.as().startsWith("Up");
                o o2 = new o((DataStoreEntryRef<s>)this.getSelfEntry().ref(), null, a2.aq());
                o2 = DataStoreEntry.createNew((String)a2.aq(), (DataStore)o2);
                o2.setStorePersistentState((DataStoreState)((ContainerStoreState.ContainerStoreStateBuilder)ContainerStoreState.builder().containerState(a2.as()).imageName(a2.ar()).running(Boolean.valueOf(bl))).build());
                return o2.ref();
            }).toList();
            ((ArrayList)object2).addAll(object);
            return object2;
        }
        catch (Exception exception) {
            s s3 = this;
            s3.setState(((c.a)((Object)((c)s3.getState()).toBuilder().reachable(Boolean.FALSE))).build());
            throw exception;
        }
    }

    @Generated
    protected s(a<?, ?> a2) {
        this.cmd = a2.cmd;
        this.name = a2.name;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<io.xpipe.ext.proc.docker.a> getCmd() {
        return this.cmd;
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof s)) {
            return false;
        }
        object = (s)object;
        Object object2 = this.getCmd();
        DataStoreEntryRef<io.xpipe.ext.proc.docker.a> dataStoreEntryRef = ((s)object).getCmd();
        if (object2 == null ? dataStoreEntryRef != null : !object2.equals(dataStoreEntryRef)) {
            return false;
        }
        object2 = this.getName();
        object = ((s)object).getName();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<io.xpipe.ext.proc.docker.a> dataStoreEntryRef = this.getCmd();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "DockerContextStore(cmd=" + String.valueOf(this.getCmd()) + ", name=" + this.getName() + ")";
    }

    @JsonDeserialize(builder=b.class)
    public static final class c
    extends DataStoreState {
        private final String description;
        private final boolean showNonRunning;
        private final Boolean reachable;
        private final boolean current;

        public final DataStoreState mergeCopy(DataStoreState dataStoreState) {
            dataStoreState = (c)dataStoreState;
            return ((a)((Object)((a)((Object)((a)((Object)((a)((Object)c.builder().description((String)c.useNewer((Object)this.description, (Object)dataStoreState.description)))).showNonRunning(this.showNonRunning))).reachable((Boolean)c.useNewer((Object)this.reachable, (Object)dataStoreState.reachable)))).current(dataStoreState.current))).build();
        }

        @Generated
        protected c(a<?, ?> a2) {
            super(a2);
            this.description = a2.description;
            this.showNonRunning = a2.showNonRunning;
            this.reachable = a2.reachable;
            this.current = a2.current;
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        @Generated
        public final a<?, ?> toBuilder() {
            return new b().$fillValuesFrom(this);
        }

        @Generated
        public final String getDescription() {
            return this.description;
        }

        @Generated
        public final boolean isShowNonRunning() {
            return this.showNonRunning;
        }

        @Generated
        public final Boolean getReachable() {
            return this.reachable;
        }

        @Generated
        public final boolean isCurrent() {
            return this.current;
        }

        @Generated
        public final String toString() {
            return "DockerContextStore.State(description=" + this.getDescription() + ", showNonRunning=" + this.isShowNonRunning() + ", reachable=" + this.getReachable() + ", current=" + this.isCurrent() + ")";
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof c)) {
                return false;
            }
            Object object2 = (c)((Object)object);
            if (!object2.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.isShowNonRunning() != object2.isShowNonRunning()) {
                return false;
            }
            if (this.isCurrent() != object2.isCurrent()) {
                return false;
            }
            object = this.getReachable();
            Boolean bl = object2.getReachable();
            if (object == null ? bl != null : !object.equals(bl)) {
                return false;
            }
            object = this.getDescription();
            object2 = object2.getDescription();
            return !(object == null ? object2 != null : !object.equals(object2));
        }

        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof c;
        }

        @Generated
        public final int hashCode() {
            int n2 = super.hashCode();
            n2 = n2 * 59 + (this.isShowNonRunning() ? 79 : 97);
            n2 = n2 * 59 + (this.isCurrent() ? 79 : 97);
            Object object = this.getReachable();
            n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
            object = this.getDescription();
            n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
            return n2;
        }

        @Generated
        public static abstract class a<C extends c, B extends a<C, B>>
        extends DataStoreState.DataStoreStateBuilder<C, B> {
            @Generated
            private String description;
            @Generated
            private boolean showNonRunning;
            @Generated
            private Boolean reachable;
            @Generated
            private boolean current;

            @Generated
            protected B $fillValuesFrom(C c2) {
                super.$fillValuesFrom(c2);
                a.$fillValuesFromInstanceIntoBuilder(c2, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(c c2, a<?, ?> a2) {
                a2.description(c2.description);
                a2.showNonRunning(c2.showNonRunning);
                a2.reachable(c2.reachable);
                a2.current(c2.current);
            }

            @Generated
            public B description(String string) {
                this.description = string;
                return (B)this.self();
            }

            @Generated
            public B showNonRunning(boolean bl) {
                this.showNonRunning = bl;
                return (B)this.self();
            }

            @Generated
            public B reachable(Boolean bl) {
                this.reachable = bl;
                return (B)this.self();
            }

            @Generated
            public B current(boolean bl) {
                this.current = bl;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DockerContextStore.State.StateBuilder(super=" + super.toString() + ", description=" + this.description + ", showNonRunning=" + this.showNonRunning + ", reachable=" + this.reachable + ", current=" + this.current + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<c, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final c build() {
                return new c(this);
            }
        }
    }

    @Generated
    public static abstract class a<C extends s, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<io.xpipe.ext.proc.docker.a> cmd;
        @Generated
        private String name;

        @Generated
        public B cmd(DataStoreEntryRef<io.xpipe.ext.proc.docker.a> dataStoreEntryRef) {
            this.cmd = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B name(String string) {
            this.name = string;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DockerContextStore.DockerContextStoreBuilder(cmd=" + String.valueOf(this.cmd) + ", name=" + this.name + ")";
        }
    }

    @JsonTypeName(value="dockerContext")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<s, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final s build() {
            return new s(this);
        }
    }
}

